//=============================================================================
// TDPBeams.  (Made by RedGreasel for The Darma Project)
// Added Tick
//=============================================================================
class TDPBeams expands BeamTrigger;

//Meshs:
//==================================================================================================

#exec mesh IMPORT MESH=hdtpBeamTrigger ANIVFILE=Models\hdtpBeamTrigger_a.3d DATAFILE=Models\hdtpBeamTrigger_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=hdtpBeamTrigger X=0 Y=0 Z=0 yaw=64

#exec mesh SEQUENCE MESH=hdtpBeamTrigger SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=hdtpBeamTrigger SEQ=still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new MESHMAP=hdtpBeamTrigger MESH=hdtpBeamTrigger
#exec MESHMAP scale MESHMAP=hdtpBeamTrigger X=0.00390625 Y=0.00390625 Z=0.00390625

//Vars:
//==================================================================================================

//Private - no dynamic change (use dynamicSetBeamTexture)
var(Display) private Texture laserTexture;

//Private - no dynamic change (use dynamicSetDisabledTextures)
var(Display) private Texture disabledTextures[8];

var(Display) Texture laserSpotTexture;

//Unallow destroying them.
var(BeamTrigger) bool bInvincibleExplode;
var(BeamTrigger) bool bInvincibleEMP;

//This is just to store the original textures (I could have used defaults, but I'm not sure that is acceptable)
var private Texture enabledTextures[8];

//Functions:
//==================================================================================================

//Yay  for a  redifinition  of  static functions.  Despite  the  fact  that
//normal high  level languages (C++/Java)  don't allow   the  programmer to 
//override static functions you can, infact, override them in unrealScript.

//Called at each clock cycle when there is someone blocking the laser.  Other
//programmers are welcome to override this  class in a subclass.  I only pass
//the beam in because certain lasers may need to take advantage of variables.
//This DOESN'T mean that  this should become a big giant mess like most other
//functions (notice the lack of deltaTime).

static event doLaserEffects(TDPBeams beam, Actor ac);  

function Tick(float dt)
{
	super.tick(dt);
	if(LastHitActor != none)
		doLaserEffects(self,lastHitActor);
	setLaserSpot(laserSpotTexture,emitter);
}

static event setBeamTexture(Texture t, LaserEmitter laser){
	if (laser.proxy != None)
		laser.proxy.Skin = t;
}

static event setLaserSpot(Texture t, LaserEmitter laser){
	//This is some sad programming, but I'm stuck with it because of the DX team's
	//inability to write object oriented code.
	
	if(laser.spot[0] != none && laser.spot[0].Skin != t)
		laser.spot[0].Skin = t;
	if(laser.spot[1] != none && laser.spot[1].Skin != t)
		laser.spot[1].Skin = t;
}

function dynamicSetDisabledTextures(Texture t[8]){
	local int i;
	for(i=0;i<8;i++)
		disabledTextures[i] = t[i];
	updateTextures();
}

function dynamicSetEnabledTextures(Texture t[8]){
	local int i;
	for(i=0;i<8;i++)
		enabledTextures[i] = t[i];
	updateTextures();
}

event updateTextures(){
	local int i;
	if(!bIsOn)
		for(i=0;i<8;i++)
			multiskins[i] = disabledTextures[i];
	else
		for(i=0;i<8;i++)
			multiskins[i] = enabledTextures[i];
}

function dynamicSetBeamTexture(Texture t){
	laserTexture = t;
	setBeamTexture(t,emitter);
}

function preBeginPlay(){
	dynamicSetEnabledTextures(Multiskins);
	super.preBeginPlay();
}

function BeginPlay()
{
	LastHitActor = None;
	emitter = Spawn(class'LaserEmitter');

	if (emitter != None)
	{
		setBeamTexture(laserTexture,emitter);
		emitter.TurnOn();
		bIsOn = True;
	}
	else
		bIsOn = False;
		
	updateTextures();
}



function Trigger(Actor Other, Pawn Instigator)
{
	super.Trigger(Other,Instigator);
	updateTextures();
}

function UnTrigger(Actor Other, Pawn Instigator)
{
	super.UnTrigger(Other,Instigator);
	updateTextures();
}

function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
{
	local MetalFragment frag;
	local DeusexPlayer dxp;

	if ((DamageType == 'Exploded') || (DamageType == 'Shot'))
	{
		if (bInvincibleExplode)
		{
			dxp.ClientMessage("This Laser is protected from any explosion type");
			return;
		}
		Else
		{
			if (Damage >= minDamageThreshold)
				HitPoints -= Damage;

			if (HitPoints <= 0)
			{
				frag = Spawn(class'MetalFragment', Owner);

				if (frag != None)
				{
					frag.Instigator = EventInstigator;
					frag.CalcVelocity(Momentum,0);
					frag.DrawScale = 0.5*FRand();
					frag.Skin = GetMeshTexture();
				}
				Destroy();
			}
		}
	}
	
	if (DamageType == 'EMP')
	{
		if (bInvincibleEMP)
		{
			dxp.ClientMessage("This Laser is protected from any EMP damage");
			return;
		}
		Else
		{
		confusionTimer = 0;
		
		if (!bConfused)
			{
				bConfused = True;
				PlaySound(sound'EMPZap', SLOT_None,,, 1280);
			}
		}
	}
}

defaultproperties
{
disabledTextures(0)=Texture'TDPDeco.Laser.NBeamTriggerTex0'
disabledTextures(1)=Texture'DeusExItems.Skins.BlackMaskTex'
}
