//=============================================================================
// TDPFlagPole.
//=============================================================================
class TDPFlagPole extends TDPDecoration;

enum ESkinColor
{
	SC_Belgium,
	SC_Netherlands,
	SC_California,
	SC_UK,
	SC_Peace,
	SC_Science
};

var(TDPNewFlags) travel ESkinColor SkinColor;

// ----------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------

function BeginPlay()
{
	Super.BeginPlay();

	SetSkin();
}

// ----------------------------------------------------------------------
// TravelPostAccept()
// ----------------------------------------------------------------------

function TravelPostAccept()
{
	Super.TravelPostAccept();

	SetSkin();
}

// ----------------------------------------------------------------------
// SetSkin()
// ----------------------------------------------------------------------

function SetSkin()
{
	switch (SkinColor)
	{
		case SC_Belgium:	Skin = Texture'FlagPoleBelg'; break;
		case SC_Netherlands:	Skin = Texture'FlagPoleNDL'; break;
		case SC_California:	Skin = Texture'FlagPoleCA'; break;
		case SC_UK:		Skin = Texture'FlagPoleUK'; break;
		case SC_Peace:		Skin = Texture'FlagPolePeace'; break;
		case SC_Science:	Skin = Texture'FlagPoleScience'; break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
defaultproperties
{
    FragType=Class'WoodFragment'
    ItemName="Flag Pole"
    Skin=Texture'FlagPoleScience'
    Mesh=LodMesh'DeusExDeco.FlagPole'
    CollisionRadius=17.00
    CollisionHeight=56.39
    Mass=40.00
    Buoyancy=30.00
}
