//=============================================================================
// Mug from TNM, with new names :)
//=============================================================================
class TDPMug extends TDPDecoration;

enum ESkinColor
{
	SC_NoName,
    	SC_Darma,
	SC_Hydra,
	SC_Morpheus,
	SC_Playor,
	SC_RedGreasel,
	SC_Nerdenstein,
	SC_Bolts,
	SC_WCCC
};

var(TDPNewMug) ESkinColor SkinColor;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_NoName:      	Texture = Texture'TnmDeco.JMugTex1'; 	break;
        	case SC_Darma:		Texture = Texture'MugDarma'; 		break;
		case SC_Hydra:	        Texture = Texture'MugHydra'; 		break;
		case SC_Morpheus:	Texture = Texture'MugMorpheus'; 	break;
		case SC_Playor:	        Texture = Texture'MugPlayor'; 		break;
		case SC_RedGreasel:	Texture = Texture'MugRed'; 		break;
		case SC_Nerdenstein:    Texture = Texture'MugNerd'; 		break;
		case SC_Bolts:		Texture = Texture'MugBolts'; 		break;
		case SC_Wccc:    	Texture = Texture'MugWCCC'; 		break;
	}
}

defaultproperties
{
     bHighlight=true
     ItemName="Coffee Mug"
     bPushable=true
     Mesh=LodMesh'TNMDeco.Mug'
     Texture=Texture'tnmdeco.JMugTex1'
     DrawScale=0.830000
     CollisionRadius=5.000000
     CollisionHeight=4.000000
     Mass=5.000000
     Buoyancy=3.000000
     FragType=Class'DeusEx.PlasticFragment'
     PushSound=Sound'DeusExSounds.Generic.PushPlastic'
}
