//===============================================================================
// TDPPhone. Plays a random sound clip then a busy signal. With new phones reply.
//===============================================================================
class TDPPhone extends ElectronicDevices;

var(TDPPhone) sound	soundPhoneBusy,
		soundPhoneDialtone;
var bool	bPlayed;
var bool	bUsing;
var(TDPPhone) sound	soundList[19];
var int		dialToneId;
var string HDTPmeshName, HDTPtexname;


function beginplay()
{
	local mesh M;
	local texture newtex;

	M = lodmesh(dynamicloadObject(HDTPmeshname,class'mesh',true));
	newtex = texture(dynamicloadObject(HDTPtexname,class'texture',true)); 
	if(M != none && newtex != none)
	{
		mesh = M;
		default.Mesh = M;
		skin = newtex;
		default.skin = newtex;
	}

	super.beginplay();
}
	
	

function Timer()
{
	bUsing = False;
	if(dialToneId != default.dialToneId)
	{
		StopSound(dialToneId);
		dialToneId = Default.dialToneId;
	}
}

function Frob(actor Frobber, Inventory frobWith)
{
	local float rnd;
	local flagbase flags;
	local int sid;

	flags = playerpawnext(getplayerpawn()).flagbase;

	Super.Frob(Frobber, frobWith);

	if (bUsing)
		return;

	rnd = FRand();

	bUsing = true;
	SetTimer(3.0, false);

	sid = flags.getInt('PhoneSoundsPlayed');

	if(!bPlayed && sid < arraycount(soundList))
	{
		PlaySound(soundList[sid++], SLOT_Misc,,, 256);
		flags.setInt('PhoneSoundsPlayed', sid, , 0);
		bPlayed = true;
	}
	else
	{
		if(rnd<0.5)
			dialToneId=PlaySound(soundPhoneBusy, SLOT_Misc,,, 256);
		else
			dialToneId=PlaySound(soundPhoneDialtone, SLOT_Misc,,, 256);
	}
}

defaultproperties
{
     soundPhoneBusy=Sound'DeusExSounds.Special.PhoneBusy'
     soundPhoneDialtone=Sound'DeusExSounds.Special.PhoneDialtone'
     ItemName="Telephone"
     Mesh=LodMesh'DeusExDeco.Phone'
     CollisionRadius=11.870000
     CollisionHeight=3.780000
     Mass=20.000000
     Buoyancy=15.000000
     HDTPtexname="HDTPAnim.animated.Phonefr1"
     HDTPmeshname="HDTPDecos.HDTPphone"
     soundList(0)=Sound'TDPDeco.PhoneSounds.TDPPhone01'
     soundList(1)=Sound'TDPDeco.PhoneSounds.Phone02'
     soundList(2)=Sound'TDPDeco.PhoneSounds.Phone03'
     soundList(3)=Sound'TDPDeco.PhoneSounds.Phone04'
     soundList(4)=Sound'TDPDeco.PhoneSounds.Phone05'
     soundList(5)=Sound'TDPDeco.PhoneSounds.Phone06'
     soundList(6)=Sound'TDPDeco.PhoneSounds.Phone07'
     soundList(7)=Sound'TDPDeco.PhoneSounds.TDPPhone03'
     soundList(8)=Sound'TDPDeco.PhoneSounds.Phone09'
     soundList(9)=Sound'TDPDeco.PhoneSounds.Phone10'
     soundList(10)=Sound'TDPDeco.PhoneSounds.Phone11'
     soundList(11)=Sound'TDPDeco.PhoneSounds.Phone12'
     soundList(12)=Sound'TDPDeco.PhoneSounds.Phone13'
     soundList(13)=Sound'TDPDeco.PhoneSounds.Phone08'
     soundList(14)=Sound'TDPDeco.PhoneSounds.Phone01'
     soundList(15)=Sound'TDPDeco.PhoneSounds.TDPPhone02'
     soundList(16)=Sound'TDPDeco.PhoneSounds.Phone17'
     soundList(17)=Sound'TDPDeco.PhoneSounds.Phone18'
     soundList(18)=Sound'TDPDeco.PhoneSounds.TDPPhone04'
     dialToneId=-1
}
