//=============================================================================
// TeleportLaser.  (Made by RedGreasel for The Darma (desolate) Project)
//=============================================================================
class TeleportLaser expands TDPBeams;

//Private - no dynamic change (use setTeleportName)
var(Teleporter) private name teleportName;
var vector teleportPosition;
var(Teleporter) Class<Actor> specialEffects;

function setTeleportName(name tn){
	teleportName = tn;
	findPosition();
}

function name getTeleportName(){
	return teleportName;
}

function findPosition(){
	local Actor a;
	foreach AllActors(Class'Actor', a, teleportName){
		teleportPosition = a.Location;
		return;
	}
}

static function doLaserEffects(TDPBeams beam, Actor ac)
{
	Local DeusExPlayer DXP;

	spawnSpecialEffects(TeleportLaser(beam),ac);
	ac.setLocation(TeleportLaser(beam).teleportPosition);
}

static function spawnSpecialEffects(TeleportLaser beam, Actor ac){
	if(beam != none && ac != none)
		beam.Spawn(beam.specialEffects,,,ac.Location,ac.Rotation);
		ac.Spawn(beam.specialEffects,,,ac.Location,ac.Rotation);
}

function beginPlay(){
	super.beginPlay();
	findPosition();
}

defaultproperties
{
    teleportName=PlayerStart
    laserTexture=FireTexture'TDP_Effects.Laser.TLaser'
    laserSpotTexture=FireTexture'TDP_Effects.spot.TSpot'
    Mesh=LodMesh'hdtpBeamTrigger'
    MultiSkins(0)=Texture'TDPDeco.Laser.TBeamTriggerTex1'
    MultiSkins(1)=FireTexture'TDP_Effects.spot.TSpot'
    enabledTextures(0)=Texture'TDPDeco.Laser.TBeamTriggerTex1'
    enabledTextures(1)=FireTexture'TDP_Effects.spot.TSpot'
}
