//=============================================================================
// Weaponbangun.
//=============================================================================
class WeaponBanGun extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
	}
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local ScriptedPawn Pawn;
	If (Pawn.bInvincible)
		{
		return;
		}
  	Else
		{
  		Spawn(Class'BanEffect',Other);
		Other.Style=STY_Translucent;
  		Other.Destroy();
		Other.PlaySound(Sound'TNMSounds.OneShot.IntroBan',SLOT_None,2.0,,);
		Super.ProcessTraceHit (Other, HitLocation, HitNormal, X, Y, Z);
		}
}

defaultproperties
{
    LowAmmoWaterMark=6
    GoverningSkill=Class'SkillWeaponPistol'
    EnviroEffective=1
    Concealability=1
    ShotTime=0.1
    reloadTime=0.00
    HitDamage=0
    maxRange=50000
    AccurateRange=24000
    BaseAccuracy=0.70
    bCanHaveScope=True
    ScopeFOV=25
    bCanHaveLaser=True
    recoilStrength=0.30
    mpReloadTime=2.00
    mpHitDamage=20
    mpBaseAccuracy=0.20
    mpAccurateRange=1200
    mpMaxRange=1200
    mpReloadCount=9
    bCanHaveModBaseAccuracy=True
    bCanHaveModReloadCount=True
    bCanHaveModAccurateRange=True
    bCanHaveModReloadTime=True
    bCanHaveModRecoilStrength=True
    AmmoName=Class'Ammo10mm'
    ReloadCount=6
    PickupAmmoCount=6
    bInstantHit=True
    FireOffset=(X=-22.00,Y=10.00,Z=14.00),
    shakemag=50.00
    FireSound=Sound'DeusExSounds.Weapons.PistolFire'
    CockingSound=Sound'DeusExSounds.Weapons.PistolReload'
    SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
    InventoryGroup=2
    ItemName="Ban Gun"
    PlayerViewOffset=(X=22.00,Y=-10.00,Z=-14.00),
    PlayerViewMesh=LodMesh'DeusExItems.Glock'
    PickupViewMesh=LodMesh'DeusExItems.GlockPickup'
    ThirdPersonMesh=LodMesh'DeusExItems.Glock3rd'
    Icon=Texture'DeusExUI.Icons.BeltIconPistol'
    largeIcon=Texture'DeusExUI.Icons.LargeIconPistol'
    largeIconWidth=46
    largeIconHeight=28
    Description="With the technology of the FireStaff, this gun can ban any NPC.."
    beltDescription="BAN-GUN"
    Mesh=LodMesh'DeusExItems.GlockPickup'
    CollisionRadius=7.00
    CollisionHeight=1.00
}
