//=============================================================================
// SyndAgent.
//=============================================================================
class SyndAgent expands JCDentonMale;

#exec TEXTURE IMPORT NAME=SyndAgentTex0 FILE=Textures\SyndAgentTex0.pcx MIPS=on FLAGS=0 TEXFLAGS=0
#exec TEXTURE IMPORT NAME=SyndAgentTex1 FILE=Textures\SyndAgentTex1.pcx MIPS=on FLAGS=0 TEXFLAGS=0
#exec TEXTURE IMPORT NAME=SyndAgentTex2 FILE=Textures\SyndAgentTex2.pcx MIPS=on FLAGS=0 TEXFLAGS=0
#exec TEXTURE IMPORT NAME=SyndAgentTex3 FILE=Textures\SyndAgentTex3.pcx MIPS=on FLAGS=0 TEXFLAGS=0

#exec AUDIO IMPORT FILE="Sounds\incoming.wav"
#exec AUDIO IMPORT FILE="Sounds\DrawTyping.WAV"


function ClientShake(vector shake)
{
	shaketimer = 0.000000;
	shakemag = 0;
	shakevert = 0.000000;
	maxshake = 0.000000;
	verttimer = 0.000000;
	bShakeDir = false;
}

function ShakeView( float shaketime, float RollMag, float vertmag)
{
	shaketimer = 0.000000;
	shakemag = 0;
	shakevert = 0.000000;
	maxshake = 0.000000;
	verttimer = 0.000000;
	bShakeDir = false;
	
	ClientShake(vect(0.000000,0.000000,0.000000));
}

function ViewShake(float DeltaTime)
{
	shaketimer = 0.000000;
	shakemag = 0;
	shakevert = 0.000000;
	maxshake = 0.000000;
	verttimer = 0.000000;
	bShakeDir = false;
}

//== Overloaded so spider stuff works
function UpdateRotation(float DeltaTime, float maxPitch)
{
	local rotator newRotation;

	DesiredRotation = ViewRotation; //save old rotation

	ViewRotation.Pitch += 32.0 * DeltaTime * aLookUp;
	ViewRotation.Pitch = ViewRotation.Pitch & 65535;
	If ((ViewRotation.Pitch > 18000) && (ViewRotation.Pitch < 49152))
	{
		If (aLookUp > 0) 
			ViewRotation.Pitch = 18000;
		else
			ViewRotation.Pitch = 49152;
	}
	ViewRotation.Yaw += 32.0 * DeltaTime * aTurn;
	ViewRotation.Roll = 0;
	//ViewShake(deltaTime);
	ViewFlash(deltaTime);
		
	newRotation = Rotation;
	newRotation.Yaw = ViewRotation.Yaw;
	if(Physics != PHYS_Spider)
	{
		newRotation.Pitch = ViewRotation.Pitch;
		If ( (newRotation.Pitch > maxPitch * RotationRate.Pitch) && (newRotation.Pitch < 65536 - maxPitch * RotationRate.Pitch) )
		{
			If (ViewRotation.Pitch < 32768) 
				newRotation.Pitch = maxPitch * RotationRate.Pitch;
			else
				newRotation.Pitch = 65536 - maxPitch * RotationRate.Pitch;
		}

    		// added to keep the player's model from pitching or rolling - DEUS_EX CNN
		newRotation.Pitch = 0;
		newRotation.Roll = 0;
	}

	setRotation(newRotation);
}


// ----------------------------------------------------------------------
// ResetPlayer()
//
// Called when a new game is started. 
//
// 1) Erase all flags except those beginning with "SKTemp_"
// 2) Dumps inventory
// 3) Restore any other defaults
// ----------------------------------------------------------------------

function ResetPlayer(optional bool bTraining)
{
	local inventory anItem;
	local inventory nextItem;

	ResetPlayerToDefaults();

	// Reset Augmentations
	if (AugmentationSystem != None)
	{
		AugmentationSystem.ResetAugmentations();
		AugmentationSystem.Destroy();
		AugmentationSystem = None;
	}

	// Give all skills
	if ( SkillSystem != None )
	{
		AllSkillPoints();
		SkillSystem.AddAllSkills();
	}

	Credits = 999999;

	// Give the player a pistol and a prod
	if (!bTraining)
	{
		anItem = Spawn(class'WeaponPistol');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		anItem = Spawn(class'WeaponProd');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		anItem = Spawn(class'MedKit');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		anItem = Spawn(class'SyndAgent.UltraLockPick');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		AddObjectToBelt(anItem, 8, true);
		anItem = Spawn(class'SyndAgent.UltraMultiTool');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		AddObjectToBelt(anItem, 9, true);
	}
}

// ----------------------------------------------------------------------
// InitializeSubSystems()
// ----------------------------------------------------------------------

function InitializeSubSystems()
{
	// Spawn the BarkManager
	if (BarkManager == None)
		BarkManager = Spawn(class'BarkManager', Self);

	// Spawn the Color Manager
	CreateColorThemeManager();
    ThemeManager.SetOwner(self);

	// install the augmentation system if not found
	if (AugmentationSystem == None)
	{
		AugmentationSystem = Spawn(class'SyndAgent.SyndAugMan', Self);
		AugmentationSystem.CreateAugmentations(Self);
		AugmentationSystem.AddDefaultAugmentations();        
        AugmentationSystem.SetOwner(Self);       
	}
	else
	{
		AugmentationSystem.SetPlayer(Self);
        AugmentationSystem.SetOwner(Self);
	}

	// install the skill system if not found
	if (SkillSystem == None)
	{
		SkillSystem = Spawn(class'SkillManager', Self);
		SkillSystem.CreateSkills(Self);
		SkillSystem.AddAllSkills();
	}
	else
	{
		SkillSystem.SetPlayer(Self);
	}

   if ((Level.Netmode == NM_Standalone) || (!bBeltIsMPInventory))
   {
      // Give the player a keyring
      CreateKeyRing();
   }
}

// ----------------------------------------------------------------------
// TravelPostAccept()
// ----------------------------------------------------------------------

event TravelPostAccept()
{
	local DeusExLevelInfo info;

	Super(Human).TravelPostAccept();
	
	MultiSkins[0] = Texture'SyndAgent.SyndAgentTex0';
}

// ----------------------------------------------------------------------
// StartPoison()
// 
// Gakk!  We've been poisoned! ... Not really.
// ----------------------------------------------------------------------

function StartPoison( Pawn poisoner, int Damage )
{
	myPoisoner = None;
	poisonCounter = 0;
	poisonTimer   = 0;
	poisonDamage  = 0;
}

function UpdatePoison(float deltaTime)
{
	poisonTimer = 0;
	poisonCounter = 0;
	StopPoison();
}

// ----------------------------------------------------------------------
// Landed()
//
// copied from Engine.PlayerPawn new landing code for Deus Ex
// zero damage if falling from 15 feet or less
// scaled damage from 15 to 60 feet
// death over 60 feet
// ----------------------------------------------------------------------

function Landed(vector HitNormal)
{
    local vector legLocation;
	local int augLevel;
	local float augReduce, dmg;

	//Note - physics changes type to PHYS_Walking by default for landed pawns
	PlayLanded(Velocity.Z);
	if (Velocity.Z < -1.4 * JumpZ)
		MakeNoise(-0.5 * Velocity.Z/(FMax(JumpZ, 150.0)));
	else if ( (Level.Game != None) && (Level.Game.Difficulty > 1) && (Velocity.Z > 0.5 * JumpZ) )
		MakeNoise(0.1 * Level.Game.Difficulty);				
	bJustLanded = true;
}

// ----------------------------------------------------------------------
// TakeDamage()
// ----------------------------------------------------------------------

function TakeDamage(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
{
	local int actualDamage;
	local bool bAlreadyDead, bPlayAnim, bDamageGotReduced;
	local Vector offset, dst;
	local float headOffsetZ, headOffsetY, armOffset;
	local float origHealth, fdst;
	local DeusExLevelInfo info;
	local DeusExWeapon dxw;
	local String bodyString;
	local int MPHitLoc;

	if ( bNintendoImmunity )
		return;

	bodyString = "";
	origHealth = Health;

   if (Level.NetMode != NM_Standalone)
      Damage *= MPDamageMult;

	// use the hitlocation to determine where the pawn is hit
	// transform the worldspace hitlocation into objectspace
	// in objectspace, remember X is front to back
	// Y is side to side, and Z is top to bottom
	offset = (hitLocation - Location) << Rotation;

	if(damageType == 'Flared')
		damageType = 'Flamed';

	// add a HUD icon for this damage type
	if ((damageType == 'Poison') || (damageType == 'PoisonEffect'))  // hack
		AddDamageDisplay('PoisonGas', offset);
	else if (damageType == 'ExplodeShot') //hackish
		AddDamageDisplay('Exploded', offset);
	else
		AddDamageDisplay(damageType, offset);

	// nanovirus damage doesn't affect us
	if (damageType == 'NanoVirus')
		return;

	// handle poison
	if ((damageType == 'Poison') || ((Level.NetMode != NM_Standalone) && (damageType=='TearGas')) )
	{
		// Notify player if they're getting burned for the first time
		if ( Level.NetMode != NM_Standalone )
			ServerConditionalNotifyMsg( MPMSG_FirstPoison );

		StartPoison( instigatedBy, Damage );
	}

	// reduce our damage correctly
	if (ReducedDamageType == damageType)
		actualDamage = float(actualDamage) * (1.0 - ReducedDamagePct);

	// check for augs or inventory items
	bDamageGotReduced = DXReduceDamage(Damage, damageType, hitLocation, actualDamage, False);

	if(damageType == 'ExplodeShot')
		damageType = 'Exploded';

   // DEUS_EX AMSD Multiplayer shield
   if (Level.NetMode != NM_Standalone)
   {
      if (bDamageGotReduced)
      {
         ShieldStatus = SS_Strong;
         ShieldTimer = 1.0;
      }
   }

	if (ReducedDamageType == 'All') //God mode
		actualDamage = 0;

	// Multiplayer only code
	if ( Level.NetMode != NM_Standalone )
	{
		if ( ( instigatedBy != None ) && (instigatedBy.IsA('DeusExPlayer')) )
		{
			// Special case the sniper rifle
			if ((DeusExPlayer(instigatedBy).Weapon != None) && ( DeusExPlayer(instigatedBy).Weapon.class == class'WeaponRifle' ))
			{
				dxw = DeusExWeapon(DeusExPlayer(instigatedBy).Weapon);
				if ( (dxw != None ) && ( !dxw.bZoomed ))
					actualDamage *= WeaponRifle(dxw).mpNoScopeMult; // Reduce damage if we're not using the scope
			}
			if ( (TeamDMGame(DXGame) != None) && (TeamDMGame(DXGame).ArePlayersAllied(DeusExPlayer(instigatedBy),Self)) )
			{
				// Don't notify if the player hurts themselves
				if ( DeusExPlayer(instigatedBy) != Self )
				{
					actualDamage *= TeamDMGame(DXGame).fFriendlyFireMult;
					if (( damageType != 'TearGas' ) && ( damageType != 'PoisonEffect' ))
						DeusExPlayer(instigatedBy).MultiplayerNotifyMsg( MPMSG_TeamHit );
				}
			}

		}
	}

	// EMP attacks drain BE energy
	if (damageType == 'EMP')
	{
		EnergyDrain += actualDamage;
		EnergyDrainTotal += actualDamage;
		PlayTakeHitSound(actualDamage, damageType, 1);
		return;
	}

	bPlayAnim = True;

	// if we're burning, don't play a hit anim when taking burning damage
	if (damageType == 'Burned')
		bPlayAnim = False;

	if (Physics == PHYS_None)
		SetMovementPhysics();
	if (Physics == PHYS_Walking)
		momentum.Z = 0.4 * VSize(momentum);
	if ( instigatedBy == self )
		momentum *= 0.6;
	momentum = momentum/Mass;
	//	AddVelocity( momentum ); 	// doesn't do anything anyway

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.78;
	headOffsetY = CollisionRadius * 0.35;
	armOffset = CollisionRadius * 0.35;

	// We decided to just have 3 hit locations in multiplayer MBCODE
	if (( Level.NetMode == NM_DedicatedServer ) || ( Level.NetMode == NM_ListenServer ))
	{
		MPHitLoc = GetMPHitLocation(HitLocation);

		if (MPHitLoc == 0)
			return;
		else if (MPHitLoc == 1 )
		{
			// MP Headshot is 2x damage
			// narrow the head region
			actualDamage *= 2;
			HealthHead -= actualDamage;
			bodyString = HeadString;
			if (bPlayAnim)
				PlayAnim('HitHead', , 0.1);
		}
		else if ((MPHitLoc == 3) || (MPHitLoc == 4))	// Leg region
		{
			HealthLegRight -= actualDamage;
			HealthLegLeft -= actualDamage;

			if (MPHitLoc == 4)
			{
				if (bPlayAnim)
					PlayAnim('HitLegRight', , 0.1);
			}
			else if (MPHitLoc == 3)
			{
				if (bPlayAnim)
					PlayAnim('HitLegLeft', , 0.1);
			}
			// Since the legs are in sync only bleed up damage from one leg (otherwise it's double damage)
			if (HealthLegLeft < 0)
			{
				HealthArmRight += HealthLegLeft;
				HealthTorso += HealthLegLeft;
				HealthArmLeft += HealthLegLeft;
				bodyString = TorsoString;
				HealthLegLeft = 0;
				HealthLegRight = 0;
			}
		}
		else // arms and torso now one region
		{
			HealthArmLeft -= actualDamage;
			HealthTorso -= actualDamage;
			HealthArmRight -= actualDamage;

			bodyString = TorsoString;

			if (MPHitLoc == 6)
			{
				if (bPlayAnim)
					PlayAnim('HitArmRight', , 0.1);
			}
			else if (MPHitLoc == 5)
			{
				if (bPlayAnim)
					PlayAnim('HitArmLeft', , 0.1);
			}
			else
			{
				if (bPlayAnim)
					PlayAnim('HitTorso', , 0.1);
			}
		}
	}
	else // Normal damage code path for single player
	{
		if (offset.z > headOffsetZ)		// head
		{
			// narrow the head region
			if ((Abs(offset.x) < headOffsetY) || (Abs(offset.y) < headOffsetY))
			{
				HealthHead -= actualDamage * 2;
				if (bPlayAnim)
					PlayAnim('HitHead', , 0.1);
			}
		}
		else if (offset.z < 0.0)	// legs
		{
			if (offset.y > 0.0)
			{
				HealthLegRight -= actualDamage;
				if (bPlayAnim)
					PlayAnim('HitLegRight', , 0.1);
			}
			else
			{
				HealthLegLeft -= actualDamage;
				if (bPlayAnim)
					PlayAnim('HitLegLeft', , 0.1);
			}

 			// if this part is already dead, damage the adjacent part
			if ((HealthLegRight < 0) && (HealthLegLeft > 0))
			{
				HealthLegLeft += HealthLegRight;
				HealthLegRight = 0;
			}
			else if ((HealthLegLeft < 0) && (HealthLegRight > 0))
			{
				HealthLegRight += HealthLegLeft;
				HealthLegLeft = 0;
			}

			if (HealthLegLeft < 0)
			{
				HealthTorso += HealthLegLeft;
				HealthLegLeft = 0;
			}
			if (HealthLegRight < 0)
			{
				HealthTorso += HealthLegRight;
				HealthLegRight = 0;
			}
		}
		else						// arms and torso
		{
			if (offset.y > armOffset)
			{
				HealthArmRight -= actualDamage;
				if (bPlayAnim)
					PlayAnim('HitArmRight', , 0.1);
			}
			else if (offset.y < -armOffset)
			{
				HealthArmLeft -= actualDamage;
				if (bPlayAnim)
					PlayAnim('HitArmLeft', , 0.1);
			}
			else
			{
				HealthTorso -= actualDamage * 2;
				if (bPlayAnim)
					PlayAnim('HitTorso', , 0.1);
			}

			// if this part is already dead, damage the adjacent part
			if (HealthArmLeft < 0)
			{
				HealthTorso += HealthArmLeft;
				HealthArmLeft = 0;
			}
			if (HealthArmRight < 0)
			{
				HealthTorso += HealthArmRight;
				HealthArmRight = 0;
			}
		}
	}

	// check for a back hit and play the correct anim
	if ((offset.x < 0.0) && bPlayAnim)
	{
		if (offset.z > headOffsetZ)		// head from the back
		{
			// narrow the head region
			if ((Abs(offset.x) < headOffsetY) || (Abs(offset.y) < headOffsetY))
				PlayAnim('HitHeadBack', , 0.1);
		}
		else
			PlayAnim('HitTorsoBack', , 0.1);
	}

	// check for a water hit
	if (Region.Zone.bWaterZone)
	{
		if ((offset.x < 0.0) && bPlayAnim)
			PlayAnim('WaterHitTorsoBack',,0.1);
		else
			PlayAnim('WaterHitTorso',,0.1);
	}

	GenerateTotalHealth();

	if ((damageType != 'Stunned') && (damageType != 'TearGas') && (damageType != 'HalonGas') &&
	    (damageType != 'PoisonGas') && (damageType != 'Radiation') && (damageType != 'EMP') &&
	    (damageType != 'NanoVirus') && (damageType != 'Drowned') && (damageType != 'KnockedOut'))
		bleedRate += (origHealth-Health)/30.0;  // 30 points of damage = bleed profusely

	if (CarriedDecoration != None)
		DropDecoration();

	if (Health <= 0)
	{
		HealthTorso = FMax(HealthTorso, 4);
		HealthHead = FMax(HealthHead, 4);
		GenerateTotalHealth();
	}

	if ((Level.NetMode != NM_Standalone) && (HealthLegLeft==0) && (HealthLegRight==0))
		ServerConditionalNotifyMsg( MPMSG_LostLegs );

	if (instigatedBy != None)
		damageAttitudeTo(instigatedBy);
	PlayDXTakeDamageHit(actualDamage, hitLocation, damageType, momentum, bDamageGotReduced);
	AISendEvent('Distress', EAITYPE_Visual);

	MakeNoise(1.0); 

	if ((DamageType == 'Flamed') && !bOnFire)
	{
		// Notify player if they're getting burned for the first time
		if ( Level.NetMode != NM_Standalone )
			ServerConditionalNotifyMsg( MPMSG_FirstBurn );

		CatchFire( instigatedBy );
	}
	myProjKiller = None;
}

// ----------------------------------------------------------------------
// Died()
//
// Checks to see if a conversation is playing when the PC dies.
// If so, nukes it.
// ----------------------------------------------------------------------

function Died(pawn Killer, name damageType, vector HitLocation)
{
/*	if (conPlay != None)
		conPlay.TerminateConversation();*/
		
	TakeDamage(MaxInt, Killer, HitLocation, vect(0,0,0), 'All');
}

// ----------------------------------------------------------------------
// PlayHit()
// ----------------------------------------------------------------------

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
	if ((Damage > 0) && (damageType == 'Shot') || (damageType == 'Exploded') || (damageType == 'AutoShot'))
		SpawnBlood(HitLocation, Damage);
}

// ----------------------------------------------------------------------
// DoFrob()
// 
// Frob the target
// ----------------------------------------------------------------------

function ForcePickHack(Actor Frobber, Inventory frobWith)
{
	// Unlock\hack ANYTHING possible
	if( (SkilledTool(frobWith) != None) && (FrobTarget != None) )
	{
		if ( (frobWith.IsA('UltraLockpick')) || (frobWith.IsA('UltraMultitool')) )
		{
			if( (FrobTarget.IsA('DeusExMover')) && !DeusExMover(FrobTarget).bPickable 
				&& DeusExMover(FrobTarget).bIsDoor )
			{
				DeusExMover(FrobTarget).bPickable = true;
				DeusExMover(FrobTarget).lockStrength = 1.0;
				DeusExMover(FrobTarget).initiallockStrength = 1.0;
			}
			else if( (FrobTarget.IsA('HackableDevices')) && !HackableDevices(FrobTarget).bHackable )
			{
				HackableDevices(FrobTarget).bHackable = true;
				HackableDevices(FrobTarget).hackStrength = 1.0;
			}
		}
	}
}

function DoFrob(Actor Frobber, Inventory frobWith)
{
	local DeusExRootWindow root;
	local Ammo ammo;
	local Inventory item;
	local Actor A;

	// make sure nothing is based on us if we're an inventory
	if (FrobTarget.IsA('Inventory'))
		foreach FrobTarget.BasedActors(class'Actor', A)
			A.SetBase(None);

	// Unlock\hack ANYTHING possible, and enhance the speed.
	if( (SkilledTool(frobWith) != None) && (FrobTarget != None) )
		ForcePickHack(Frobber,frobWith);

	FrobTarget.Frob(Frobber, frobWith);

	// if the object destroyed itself, get out
	if (FrobTarget == None)
		return;

	// Enhance lockpicking time, etc
	if( (SkilledTool(frobWith) != None) && (FrobTarget != None) )
	{
		if ( (frobWith.IsA('UltraLockpick')) || (frobWith.IsA('UltraMultitool')) )
		{
			if( FrobTarget.IsA('DeusExMover') )
			{
				DeusExMover(FrobTarget).pickValue *= 8;
				DeusExMover(FrobTarget).numPicks = MaxInt;
			}
			else if( FrobTarget.IsA('HackableDevices') )
			{
				HackableDevices(FrobTarget).hackValue *= 8;
				HackableDevices(FrobTarget).numHacks = MaxInt;
			}
		}
	}

	// if the inventory item aborted it's own pickup, get out
	if (FrobTarget.IsA('Inventory') && (FrobTarget.Owner != Self))
		return;

	// alert NPCs that I'm messing with stuff
	if (FrobTarget.bOwned)
		AISendEvent('Futz', EAITYPE_Visual);

	// play an animation
	PlayPickupAnim(FrobTarget.Location);

	// set the base so the inventory follows us around correctly
	if (FrobTarget.IsA('Inventory'))
		FrobTarget.SetBase(Frobber);
}

// ----------------------------------------------------------------------
// MaintainEnergy()
// Changed to allow energy to regenerate outside of multiplayer, up to 100%.
// ----------------------------------------------------------------------

function MaintainEnergy(float deltaTime)
{
	local Float energyUse;
   local Float energyRegen;

	// make sure we can't continue to go negative if we take damage
	// after we're already out of energy
	if (Energy <= 0)
	{
		Energy = 0;
		EnergyDrain = 0;
		EnergyDrainTotal = 0;
	}

   energyUse = 0;

	// Don't waste time doing this if the player is dead or paralyzed
	if ((!IsInState('Dying')) && (!IsInState('Paralyzed')))
   {
      if (Energy > 0)
      {
         // Decrement energy used for augmentations
         energyUse = AugmentationSystem.CalcEnergyUse(deltaTime);
         
         Energy -= EnergyUse;
         
         // Calculate the energy drain due to EMP attacks
         if (EnergyDrain > 0)
         {
            energyUse = EnergyDrainTotal * deltaTime;
            Energy -= EnergyUse;
            EnergyDrain -= EnergyUse;
            if (EnergyDrain <= 0)
            {
               EnergyDrain = 0;
               EnergyDrainTotal = 0;
            }
         }
      }

      //Do check if energy is 0.  
      // If the player's energy drops to zero, deactivate 
      // all augmentations
      if (Energy <= 0)
      {
         //If we were using energy, then tell the client we're out.
         //Otherwise just make sure things are off.  If energy was
         //already 0, then energy use will still be 0, so we won't
         //spam.  DEUS_EX AMSD
         if (energyUse > 0)         
            ClientMessage(EnergyDepleted);
         Energy = 0;
         EnergyDrain = 0;
         EnergyDrainTotal = 0;         
         AugmentationSystem.DeactivateAll();
      }

      // If all augs are off, then start regenerating in multiplayer,
      // up to 25%.
      if ( (energyUse == 0) && (Energy < 100) )
      {
         energyRegen = RegenRate * deltaTime;
         Energy += energyRegen;
      }
	}
}

// ----------------------------------------------------------------------
// StartDataLinkTransmission()
//
// Locates and starts the DataLink passed in
// Modified to use a different sound...
// ----------------------------------------------------------------------

function Bool StartDataLinkTransmission(
	String datalinkName, 
	Optional DataLinkTrigger datalinkTrigger)
{
	local Conversation activeDataLink;
	local bool bDataLinkPlaySpawned;

	// Don't allow DataLinks to start if we're in PlayersOnly mode
	if ( Level.bPlayersOnly )
		return False;

	activeDataLink = GetActiveDataLink(datalinkName);

	if ( activeDataLink != None )
	{
		// Search to see if there's an active DataLinkPlay object 
		// before creating one

		if ( dataLinkPlay == None )
		{
			datalinkPlay = Spawn(class'DataLinkPlay');
			bDataLinkPlaySpawned = True;
		}
		datalinkPlay.startSound = Sound'SyndAgent.Incoming';

		// Call SetConversation(), which returns 
		if (datalinkPlay.SetConversation(activeDataLink))
		{
			datalinkPlay.SetTrigger(datalinkTrigger);

			if (datalinkPlay.StartConversation(Self))
			{
				return True;
			}
			else
			{
				// Datalink must already be playing, or in queue
				if (bDataLinkPlaySpawned)
				{
					datalinkPlay.Destroy();
					datalinkPlay = None;
				}
				
				return False;
			}
		}
		else
		{
			// Datalink must already be playing, or in queue
			if (bDataLinkPlaySpawned)
			{
				datalinkPlay.Destroy();
				datalinkPlay = None;
			}
			return False;
		}
	}
	else
	{
		return False;
	}
}

// ----------------------------------------------------------------------
// state Conversation
// Modified, I don't want to put away weapons while talking, nobody else does it.. so what the hell.
// ----------------------------------------------------------------------

state Conversation
{
ignores SeePlayer, HearNoise, Bump, TakeDamage, Died; //Can't get hurt or die anyways so what the hell.

	event PlayerTick(float deltaTime)
	{
		local rotator tempRot;
		local float   yawDelta;

		UpdateInHand();
		UpdateDynamicMusic(deltaTime);

		DrugEffects(deltaTime);
		Bleed(deltaTime);
		MaintainEnergy(deltaTime);

		// must update viewflash manually incase a flash happens during a convo
		ViewFlash(deltaTime);

		// Check if player has walked outside a first-person convo.
		CheckActiveConversationRadius();
	
		// Check if all the people involved in a conversation are 
		// still within a reasonable radius.
		CheckActorDistances();

		Super.PlayerTick(deltaTime);
		LipSynch(deltaTime);

		// Keep turning towards the person we're speaking to
		if (ConversationActor != None)
		{
			LookAtActor(ConversationActor, true, true, true, 0, 0.5);

			// Hacky way to force the player to turn...
			tempRot = rot(0,0,0);
			tempRot.Yaw = (DesiredRotation.Yaw - Rotation.Yaw) & 65535;
			if (tempRot.Yaw > 32767)
				tempRot.Yaw -= 65536;
			yawDelta = RotationRate.Yaw * deltaTime;
			if (tempRot.Yaw > yawDelta)
				tempRot.Yaw = yawDelta;
			else if (tempRot.Yaw < -yawDelta)
				tempRot.Yaw = -yawDelta;
			SetRotation(Rotation + tempRot);
		}

		// Update Time Played
		UpdateTimePlayed(deltaTime);
	}

	function LoopHeadConvoAnim()
	{
	}

	function EndState()
	{
		conPlay = None;

		// Re-enable the PC's detectability
		MakePlayerIgnored(false);

		MoveTarget = None;
		bBehindView = false;
		StopBlendAnims();
		ConversationActor = None;
	}

Begin:
	// Make sure we're stopped
	Velocity.X = 0;
	Velocity.Y = 0;
	Velocity.Z = 0;

	Acceleration = Velocity;

	PlayRising();

	// Make sure the player isn't on fire!
	if (bOnFire)
		ExtinguishFire();

	// Make sure the PC can't be attacked while in conversation
	MakePlayerIgnored(true);

	LookAtActor(conPlay.startActor, true, false, true, 0, 0.5);

	SetRotation(DesiredRotation);

	PlayTurning();

	if (!conPlay.StartConversation(Self))
	{
		AbortConversation(True);
	}
	else
	{
		if ( conPlay.GetDisplayMode() == DM_ThirdPerson )
			bBehindView = true;	
	}
}

defaultproperties
{
     TruePlayerName="Krauze"
     HitSound1=None
     HitSound2=None
     Die=None
     Texture=Texture'SyndAgent.SyndAgentTex1'
     Skin=Texture'SyndAgent.SyndAgentTex0'
     MultiSkins(0)=Texture'SyndAgent.SyndAgentTex0'
     MultiSkins(1)=Texture'SyndAgent.SyndAgentTex2'
     MultiSkins(2)=Texture'SyndAgent.SyndAgentTex3'
     MultiSkins(3)=Texture'SyndAgent.SyndAgentTex0'
     MultiSkins(4)=Texture'SyndAgent.SyndAgentTex1'
     MultiSkins(5)=Texture'SyndAgent.SyndAgentTex2'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     FamiliarName="Special Agent Krauze"
     UnfamiliarName="Special Agent Krauze"
}
