//=============================================================================
// SyndAugMan.
//=============================================================================
class SyndAugMan expands AugmentationManager;

// ----------------------------------------------------------------------
// CalcEnergyUse()
//
// Calculates energy use for all active augmentations
// ----------------------------------------------------------------------

simulated function Float CalcEnergyUse(float deltaTime)
{
	local float energyUse;
	local Augmentation anAug;
    local Augmentation PowerAug;

	energyUse = 0;

	anAug = FirstAug;
	while(anAug != None)
	{
		if (anAug.bHasIt && anAug.bIsActive)
		{
			energyUse += ((anAug.GetEnergyRate()/60) * deltaTime);
			
			//=== AugHealing doesn't deactivate automatically, instead goes to an "idle" drain level
			if (anAug.IsA('AugHealing'))
			{
				if(player.Health >= 100)
					energyUse -= ((anAug.GetEnergyRate()/60) * (9/10) * deltaTime);
			}
		}
		anAug = anAug.next;
	}

	return energyUse*0.25;
}

// ----------------------------------------------------------------------
// AddDefaultAugmentations()
// ----------------------------------------------------------------------

function AddDefaultAugmentations()
{
	local int augIndex;

	for(augIndex=0; augIndex<arrayCount(defaultAugs); augIndex++)
	{
		if (defaultAugs[augIndex] != None)
			GivePlayerAugmentation(defaultAugs[augIndex]);
	}
	GivePlayerAugmentation(Class'DeusEx.AugDefense');
	GivePlayerAugmentation(Class'DeusEx.AugTarget');
	GivePlayerAugmentation(Class'DeusEx.AugHealing');
	GivePlayerAugmentation(Class'DeusEx.AugAqualung');
	GivePlayerAugmentation(Class'DeusEx.AugBallistic');
	GivePlayerAugmentation(Class'DeusEx.AugSpeed');
	GivePlayerAugmentation(Class'DeusEx.AugMuscle');
	GivePlayerAugmentation(Class'DeusEx.AugEnviro');
	GivePlayerAugmentation(Class'DeusEx.AugEMP');
	SetAllAugsToMaxLevel();
}

defaultproperties
{
}
