//=============================================================================
// SyndHUD.
// ....
//=============================================================================
class SyndHUD expands DeusExHUD;

var SyndAgent SA;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	local DeusExRootWindow root;
	local DeusExPlayer player;

	Super.InitWindow();

	// Get a pointer to the root window
	root = DeusExRootWindow(GetRootWindow());

	// Get a pointer to the player
	player = DeusExPlayer(root.parentPawn);
	
	SA = SyndAgent(player);
}

// ----------------------------------------------------------------------
// CreateInfoLinkWindow()
//
// Creates the InfoLink window used to display messages.  If a 
// InfoLink window already exists, then return None.  If the Log window
// is visible, it hides it.
// ----------------------------------------------------------------------

function HUDInfoLinkDisplay CreateInfoLinkWindow()
{
	if ( infolink != None )
		return None;

	infolink = SyndHUDInfoLinkDisplay(NewChild(Class'SyndAgent.SyndHUDInfoLinkDisplay'));


	SyndHUDInfoLinkDisplay(infolink).SA = SA;

	// Hide Log window
	if ( msgLog != None )
		msgLog.Hide();

	infolink.AskParentForReconfigure();

	return infolink;
}

defaultproperties
{
}
