//=============================================================================
// UltraLockpick.
// WORKS ON ANYTHING LULZ.
//=============================================================================
class UltraLockpick expands Lockpick;

#exec TEXTURE IMPORT NAME=UltrapickPOVTex1 FILE=Textures\UltrapickPOVTex1.pcx MIPS=on FLAGS=0 TEXFLAGS=0
#exec TEXTURE IMPORT NAME=UltrapickTex1 FILE=Textures\UltrapickTex1.pcx MIPS=on FLAGS=2 TEXFLAGS=0

#exec TEXTURE IMPORT NAME=LargeIconUltraPick FILE=Textures\LargeIconUltraPick.pcx MIPS=off FLAGS=2 TEXFLAGS=0
#exec TEXTURE IMPORT NAME=BeltIconUltraPick FILE=Textures\BeltIconUltraPick.pcx MIPS=off FLAGS=2 TEXFLAGS=0

// ----------------------------------------------------------------------
// UseOnce()
//
// Subtract a use, then destroy if out of uses
// ----------------------------------------------------------------------

function UseOnce();

simulated event RenderOverlays(canvas Canvas)
{
	MultiSkins[0] = Texture'WeaponHandsTex';
	Super.RenderOverlays(Canvas);
	MultiSkins[0] = Class.Default.MultiSkins[0];
}

//
// Become a pickup.
//
function BecomePickup()
{
	Super.BecomePickup();
	MultiSkins[0] = Class.Default.MultiSkins[0];
}

defaultproperties
{
     bCanHaveMultipleCopies=False
     ItemName="Ultra Lockpick"
     msgTooMany="You only need one of these."
     Description="The ultimate lockpick. This special high class version of the Lockpick will never wear, out and can pick ANY lock imaginable.|n|n<UNATCO OPS FILE NOTE AJ006-BLACK> Here's what they don't tell you: despite the product literature, you can use a standard lockpick to bypass all but the most high-class nanolocks. -- Alex Jacobson <END NOTE>"
     maxCopies=1
     beltDescription="ULTRAPICK"
     Icon=Texture'SyndAgent.BeltIconUltraPick'
     largeIcon=Texture'SyndAgent.LargeIconUltraPick'
     MultiSkins(0)=Texture'SyndAgent.UltrapickTex1'
     MultiSkins(1)=Texture'SyndAgent.UltrapickPOVTex1'
}
