//=============================================================================
// UltraMultitool.
// WORKS ON ANYTHING LULZ. HAX.
//=============================================================================
class UltraMultitool expands Multitool;

#exec TEXTURE IMPORT NAME=UltratoolPOVTex1 FILE=Textures\UltratoolPOVTex1.pcx MIPS=on FLAGS=2 TEXFLAGS=0
#exec TEXTURE IMPORT NAME=UltratoolTex1 FILE=Textures\UltratoolTex1.pcx MIPS=on FLAGS=0 TEXFLAGS=0

#exec TEXTURE IMPORT NAME=LargeIconUltraTool FILE=Textures\LargeIconUltraTool.pcx MIPS=off FLAGS=2 TEXFLAGS=0
#exec TEXTURE IMPORT NAME=BeltIconUltraTool FILE=Textures\BeltIconUltraTool.pcx MIPS=off FLAGS=2 TEXFLAGS=0

// ----------------------------------------------------------------------
// UseOnce()
//
// Subtract a use, then destroy if out of uses
// ----------------------------------------------------------------------

function UseOnce();

//using different first person skin
simulated event RenderOverlays(canvas Canvas)
{
	MultiSkins[0] = Texture'SyndAgent.UltratoolPOVTex1';
	Super.RenderOverlays(Canvas);
	MultiSkins[0] = Class.Default.MultiSkins[0];
}

//
// Become a pickup.
//
function BecomePickup()
{
	Super.BecomePickup();
	MultiSkins[0] = Class.Default.MultiSkins[0];
}

defaultproperties
{
     bCanHaveMultipleCopies=False
     ItemName="Ultimate Multitool"
     Icon=Texture'SyndAgent.BeltIconUltraTool'
     msgTooMany="You only need one of these."
     largeIcon=Texture'SyndAgent.LargeIconUltraTool'
     maxCopies=1
     Description="The ultimate electronics tool. This special high class version of the Multitool will never wear out, and can hack ANYTHING imaginable."
     beltDescription="ULTRATOOL"
     MultiSkins(0)=Texture'SyndAgent.UltratoolTex1'
     MultiSkins(2)=Texture'SyndAgent.UltratoolPOVTex1'
     MultiSkins(3)=Texture'SyndAgent.UltratoolPOVTex1'
     MultiSkins(4)=Texture'SyndAgent.UltratoolPOVTex1'
}
