class DXRMenuScreenNewGame extends MenuScreenNewGame;

var DXRando dxr;
var DXRFlags flags;

function SetDxr(DXRando d)
{
    dxr=d;
    flags = DXRFlags(dxr.FindModule(class'DXRFlags'));
    CopySkills();
    PopulateSkillsList();
    UpdateSkillPoints();
    EnableButtons();
}

function ResetToDefaults()
{
    editName.SetText(player.TruePlayerName);

    player.SkillPointsAvail = player.Default.SkillPointsAvail;
    player.SkillPointsTotal = player.Default.SkillPointsTotal;

    portraitIndex = 0;
    btnPortrait.SetBackground(texPortraits[portraitIndex]);

    if( flags != None && flags.skills_disable_downgrades == 0 ) {
        CopySkills();
        PopulateSkillsList();
        UpdateSkillPoints();
    }
    EnableButtons();
}

function EnableButtons()
{
    local bool allow_downgrade;
    local int level;
    Super.EnableButtons();

    if ( selectedSkill != None )
        level = selectedSkill.GetCurrentLevel();

    allow_downgrade = level > 0;
    allow_downgrade = allow_downgrade && level > flags.skills_disable_downgrades;
    btnDowngrade.EnableWindow(allow_downgrade);
}

// ----------------------------------------------------------------------
// CopySkills()
//
// Makes a local copy of the skills so we can manipulate them without
// actually making changes to the ones attached to the player.
// ----------------------------------------------------------------------

function CopySkills()
{
    local DXRSkills dxrs;
    local int i;

    Super.CopySkills();

    for(i=1; i<ArrayCount(localSkills); i++) {
        localSkills[i-1].next = localSkills[i];
    }

    if(dxr!=None) {
        //dxrs = dxr.Spawn(class'DXRSkills', None);
        //dxr.modules[dxr.num_modules] = dxrs;
        //dxr.num_modules++;
        dxrs = DXRSkills(dxr.FindModule(class'DXRSkills'));
    }
    if( dxrs != None )
        dxrs.RandoSkills(localSkills[0]);
}

function SaveSettings()
{
    local Inventory i;

    foreach player.AllActors(class'Inventory', i) {
        i.Destroy();
    }
    player.RestoreAllHealth();
    if (DeusExRootWindow(player.rootWindow) != None)
        DeusExRootWindow(player.rootWindow).ResetFlags();

    Super.SaveSettings();

    dxr.flags.SaveFlags();
    dxr.Destroy();
    foreach player.AllActors(class'DXRando', dxr)
        dxr.Destroy();
}

defaultproperties
{
    actionButtons(0)=(Align=HALIGN_Left,Action=AB_Cancel)
}
