class DXRAllActors extends DXRBase transient;

var int i;

function bool is_valid(string s, class<Object> o)
{
    local class<Actor> a;
    a = class<Actor>(o);
    if ( a == None ) return false;
    if ( a.default.bHidden ) return false;
    if ( a.default.Mesh == None ) return false;
    if ( a.default.DrawType != DT_Mesh ) return false;
    if ( a.default.Style != STY_Normal ) return false;

    log( "if ( r == i++ ) return class'" $ s $ "';" );
    i++;
    return true;
}

function FirstEntry()
{
    is_valid("AcousticSensor", class'AcousticSensor');
    is_valid("ActorDisplayWindow", class'ActorDisplayWindow');
    is_valid("AdaptiveArmor", class'AdaptiveArmor');
    is_valid("advteamdmgame", class'advteamdmgame');
    is_valid("AIPrototype", class'AIPrototype');
    is_valid("AirBubble", class'AirBubble');
    is_valid("AlarmLight", class'AlarmLight');
    is_valid("AlarmUnit", class'AlarmUnit');
    is_valid("AlexJacobson", class'AlexJacobson');
    is_valid("AlexJacobsonCarcass", class'AlexJacobsonCarcass');
    is_valid("AlignWindow", class'AlignWindow');
    is_valid("AllianceTrigger", class'AllianceTrigger');
    is_valid("AmbientSoundTriggered", class'AmbientSoundTriggered');
    is_valid("AmbrosiaPool", class'AmbrosiaPool');
    is_valid("Ammo10mm", class'Ammo10mm');
    is_valid("Ammo20mm", class'Ammo20mm');
    is_valid("Ammo3006", class'Ammo3006');
    is_valid("Ammo762mm", class'Ammo762mm');
    is_valid("AmmoBattery", class'AmmoBattery');
    is_valid("ammocrate", class'ammocrate');
    is_valid("AmmoDart", class'AmmoDart');
    is_valid("AmmoDartFlare", class'AmmoDartFlare');
    is_valid("AmmoDartPoison", class'AmmoDartPoison');
    is_valid("AmmoEMPGrenade", class'AmmoEMPGrenade');
    is_valid("AmmoGasGrenade", class'AmmoGasGrenade');
    is_valid("AmmoGraySpit", class'AmmoGraySpit');
    is_valid("AmmoGreaselSpit", class'AmmoGreaselSpit');
    is_valid("AmmoLAM", class'AmmoLAM');
    is_valid("AmmoNanoVirusGrenade", class'AmmoNanoVirusGrenade');
    is_valid("AmmoNapalm", class'AmmoNapalm');
    is_valid("AmmoNone", class'AmmoNone');
    is_valid("AmmoPepper", class'AmmoPepper');
    is_valid("AmmoPlasma", class'AmmoPlasma');
    is_valid("AmmoRocket", class'AmmoRocket');
    is_valid("AmmoRocketMini", class'AmmoRocketMini');
    is_valid("AmmoRocketRobot", class'AmmoRocketRobot');
    is_valid("AmmoRocketWP", class'AmmoRocketWP');
    is_valid("AmmoSabot", class'AmmoSabot');
    is_valid("AmmoShell", class'AmmoShell');
    is_valid("AmmoShuriken", class'AmmoShuriken');
    is_valid("Animal", class'Animal');
    is_valid("AnimatedSprite", class'AnimatedSprite');
    is_valid("AnnaNavarre", class'AnnaNavarre');
    is_valid("AnnaNavarreCarcass", class'AnnaNavarreCarcass');
    is_valid("ATM", class'ATM');
    is_valid("ATMWindow", class'ATMWindow');
    is_valid("AttackHelicopter", class'AttackHelicopter');
    is_valid("AugAqualung", class'AugAqualung');
    is_valid("AugBallistic", class'AugBallistic');
    is_valid("AugCloak", class'AugCloak');
    is_valid("AugCombat", class'AugCombat');
    is_valid("AugDatalink", class'AugDatalink');
    is_valid("AugDefense", class'AugDefense');
    is_valid("AugDrone", class'AugDrone');
    is_valid("AugEMP", class'AugEMP');
    is_valid("AugEnviro", class'AugEnviro');
    is_valid("AugHealing", class'AugHealing');
    is_valid("AugHeartLung", class'AugHeartLung');
    is_valid("AugIFF", class'AugIFF');
    is_valid("AugLight", class'AugLight');
    is_valid("Augmentation", class'Augmentation');
    is_valid("AugmentationCannister", class'AugmentationCannister');
    is_valid("AugmentationDisplayWindow", class'AugmentationDisplayWindow');
    is_valid("AugmentationManager", class'AugmentationManager');
    is_valid("AugmentationUpgradeCannister", class'AugmentationUpgradeCannister');
    is_valid("AugMuscle", class'AugMuscle');
    is_valid("AugPower", class'AugPower');
    is_valid("AugRadarTrans", class'AugRadarTrans');
    is_valid("AugShield", class'AugShield');
    is_valid("AugSpeed", class'AugSpeed');
    is_valid("AugStealth", class'AugStealth');
    is_valid("AugTarget", class'AugTarget');
    is_valid("AugVision", class'AugVision');
    is_valid("AutoTurret", class'AutoTurret');
    is_valid("AutoTurretGun", class'AutoTurretGun');
    is_valid("AutoTurretGunSmall", class'AutoTurretGunSmall');
    is_valid("AutoTurretSmall", class'AutoTurretSmall');
    is_valid("BallisticArmor", class'BallisticArmor');
    is_valid("BarkManager", class'BarkManager');
    is_valid("Barrel1", class'Barrel1');
    is_valid("BarrelAmbrosia", class'BarrelAmbrosia');
    is_valid("BarrelFire", class'BarrelFire');
    is_valid("BarrelVirus", class'BarrelVirus');
    is_valid("Bartender", class'Bartender');
    is_valid("BartenderCarcass", class'BartenderCarcass');
    is_valid("basicteamdmgame", class'basicteamdmgame');
    is_valid("Basket", class'Basket');
    is_valid("Basketball", class'Basketball');
    is_valid("Beam", class'Beam');
    is_valid("BeamTrigger", class'BeamTrigger');
    is_valid("BehindTheCurtain", class'BehindTheCurtain');
    is_valid("Binoculars", class'Binoculars');
    is_valid("BioelectricCell", class'BioelectricCell');
    is_valid("Bird", class'Bird');
    is_valid("BlackHelicopter", class'BlackHelicopter');
    is_valid("BloodDrop", class'BloodDrop');
    is_valid("BloodPool", class'BloodPool');
    is_valid("BloodSplat", class'BloodSplat');
    is_valid("BloodSpurt", class'BloodSpurt');
    is_valid("BoatPerson", class'BoatPerson');
    is_valid("BoatPersonCarcass", class'BoatPersonCarcass');
    is_valid("BobPage", class'BobPage');
    is_valid("BobPageAugmented", class'BobPageAugmented');
    is_valid("BobPageCarcass", class'BobPageCarcass');
    is_valid("BoneFemur", class'BoneFemur');
    is_valid("BoneSkull", class'BoneSkull');
    is_valid("BookClosed", class'BookClosed');
    is_valid("BookOpen", class'BookOpen');
    is_valid("BoxLarge", class'BoxLarge');
    is_valid("BoxMedium", class'BoxMedium');
    is_valid("BoxSmall", class'BoxSmall');
    is_valid("BreakableGlass", class'BreakableGlass');
    is_valid("BreakableWall", class'BreakableWall');
    is_valid("BulletHole", class'BulletHole');
    is_valid("BumFemale", class'BumFemale');
    is_valid("BumFemaleCarcass", class'BumFemaleCarcass');
    is_valid("BumMale", class'BumMale');
    is_valid("BumMale2", class'BumMale2');
    is_valid("BumMale2Carcass", class'BumMale2Carcass');
    is_valid("BumMale3", class'BumMale3');
    is_valid("BumMale3Carcass", class'BumMale3Carcass');
    is_valid("BumMaleCarcass", class'BumMaleCarcass');
    is_valid("Buoy", class'Buoy');
    is_valid("BurnMark", class'BurnMark');
    is_valid("Bushes1", class'Bushes1');
    is_valid("Bushes2", class'Bushes2');
    is_valid("Bushes3", class'Bushes3');
    is_valid("Businessman1", class'Businessman1');
    is_valid("Businessman1Carcass", class'Businessman1Carcass');
    is_valid("Businessman2", class'Businessman2');
    is_valid("Businessman2Carcass", class'Businessman2Carcass');
    is_valid("Businessman3", class'Businessman3');
    is_valid("Businessman3Carcass", class'Businessman3Carcass');
    is_valid("Businesswoman1", class'Businesswoman1');
    is_valid("Businesswoman1Carcass", class'Businesswoman1Carcass');
    is_valid("Butler", class'Butler');
    is_valid("ButlerCarcass", class'ButlerCarcass');
    is_valid("Button1", class'Button1');
    is_valid("Cactus1", class'Cactus1');
    is_valid("Cactus2", class'Cactus2');
    is_valid("CageLight", class'CageLight');
    is_valid("Candybar", class'Candybar');
    is_valid("CarBurned", class'CarBurned');
    is_valid("CarStripped", class'CarStripped');
    is_valid("Cart", class'Cart');
    is_valid("CarWrecked", class'CarWrecked');
    is_valid("Cat", class'Cat');
    is_valid("CatCarcass", class'CatCarcass');
    is_valid("CeilingFan", class'CeilingFan');
    is_valid("CeilingFanMotor", class'CeilingFanMotor');
    is_valid("Chad", class'Chad');
    is_valid("ChadCarcass", class'ChadCarcass');
    is_valid("Chair1", class'Chair1');
    is_valid("ChairLeather", class'ChairLeather');
    is_valid("Chandelier", class'Chandelier');
    is_valid("CharacterModelButton", class'CharacterModelButton');
    is_valid("ChargedPickup", class'ChargedPickup');
    is_valid("Chef", class'Chef');
    is_valid("ChefCarcass", class'ChefCarcass');
    is_valid("ChildMale", class'ChildMale');
    is_valid("ChildMale2", class'ChildMale2');
    is_valid("ChildMale2Carcass", class'ChildMale2Carcass');
    is_valid("ChildMaleCarcass", class'ChildMaleCarcass');
    is_valid("CigaretteMachine", class'CigaretteMachine');
    is_valid("Cigarettes", class'Cigarettes');
    is_valid("CinematicWindow", class'CinematicWindow');
    is_valid("CleanerBot", class'CleanerBot');
    is_valid("ClothesRack", class'ClothesRack');
    is_valid("Cloud", class'Cloud');
    is_valid("CoffeeTable", class'CoffeeTable');
    is_valid("ColorTheme", class'ColorTheme');
    is_valid("ColorThemeHUD", class'ColorThemeHUD');
    is_valid("ColorThemeHUD_Amber", class'ColorThemeHUD_Amber');
    is_valid("ColorThemeHUD_Cops", class'ColorThemeHUD_Cops');
    is_valid("ColorThemeHUD_Cyan", class'ColorThemeHUD_Cyan');
    is_valid("ColorThemeHUD_DarkBlue", class'ColorThemeHUD_DarkBlue');
    is_valid("ColorThemeHUD_Default", class'ColorThemeHUD_Default');
    is_valid("ColorThemeHUD_DesertStorm", class'ColorThemeHUD_DesertStorm');
    is_valid("ColorThemeHUD_DriedBlood", class'ColorThemeHUD_DriedBlood');
    is_valid("ColorThemeHUD_Dusk", class'ColorThemeHUD_Dusk');
    is_valid("ColorThemeHUD_Grey", class'ColorThemeHUD_Grey');
    is_valid("ColorThemeHUD_IonStorm", class'ColorThemeHUD_IonStorm');
    is_valid("ColorThemeHUD_Nightvision", class'ColorThemeHUD_Nightvision');
    is_valid("ColorThemeHUD_Ninja", class'ColorThemeHUD_Ninja');
    is_valid("ColorThemeHUD_PaleGreen", class'ColorThemeHUD_PaleGreen');
    is_valid("ColorThemeHUD_Pastel", class'ColorThemeHUD_Pastel');
    is_valid("ColorThemeHUD_Plasma", class'ColorThemeHUD_Plasma');
    is_valid("ColorThemeHUD_Primaries", class'ColorThemeHUD_Primaries');
    is_valid("ColorThemeHUD_Purple", class'ColorThemeHUD_Purple');
    is_valid("ColorThemeHUD_Red", class'ColorThemeHUD_Red');
    is_valid("ColorThemeHUD_SoylentGreen", class'ColorThemeHUD_SoylentGreen');
    is_valid("ColorThemeHUD_Starlight", class'ColorThemeHUD_Starlight');
    is_valid("ColorThemeHUD_SteelGreen", class'ColorThemeHUD_SteelGreen');
    is_valid("ColorThemeHUD_Superhero", class'ColorThemeHUD_Superhero');
    is_valid("ColorThemeHUD_Terminator", class'ColorThemeHUD_Terminator');
    is_valid("ColorThemeHUD_Violet", class'ColorThemeHUD_Violet');
    is_valid("ColorThemeManager", class'ColorThemeManager');
    is_valid("ColorThemeMenu", class'ColorThemeMenu');
    is_valid("ColorThemeMenu_Blue", class'ColorThemeMenu_Blue');
    is_valid("ColorThemeMenu_BlueAndGold", class'ColorThemeMenu_BlueAndGold');
    is_valid("ColorThemeMenu_CoolGreen", class'ColorThemeMenu_CoolGreen');
    is_valid("ColorThemeMenu_Cops", class'ColorThemeMenu_Cops');
    is_valid("ColorThemeMenu_Cyan", class'ColorThemeMenu_Cyan');
    is_valid("ColorThemeMenu_Default", class'ColorThemeMenu_Default');
    is_valid("ColorThemeMenu_DesertStorm", class'ColorThemeMenu_DesertStorm');
    is_valid("ColorThemeMenu_DriedBlood", class'ColorThemeMenu_DriedBlood');
    is_valid("ColorThemeMenu_Dusk", class'ColorThemeMenu_Dusk');
    is_valid("ColorThemeMenu_Earth", class'ColorThemeMenu_Earth');
    is_valid("ColorThemeMenu_Green", class'ColorThemeMenu_Green');
    is_valid("ColorThemeMenu_Grey", class'ColorThemeMenu_Grey');
    is_valid("ColorThemeMenu_IonStorm", class'ColorThemeMenu_IonStorm');
    is_valid("ColorThemeMenu_Lava", class'ColorThemeMenu_Lava');
    is_valid("ColorThemeMenu_NightVision", class'ColorThemeMenu_NightVision');
    is_valid("ColorThemeMenu_Ninja", class'ColorThemeMenu_Ninja');
    is_valid("ColorThemeMenu_Olive", class'ColorThemeMenu_Olive');
    is_valid("ColorThemeMenu_PaleGreen", class'ColorThemeMenu_PaleGreen');
    is_valid("ColorThemeMenu_Pastel", class'ColorThemeMenu_Pastel');
    is_valid("ColorThemeMenu_Plasma", class'ColorThemeMenu_Plasma');
    is_valid("ColorThemeMenu_Primaries", class'ColorThemeMenu_Primaries');
    is_valid("ColorThemeMenu_Purple", class'ColorThemeMenu_Purple');
    is_valid("ColorThemeMenu_Red", class'ColorThemeMenu_Red');
    is_valid("ColorThemeMenu_Seawater", class'ColorThemeMenu_Seawater');
    is_valid("ColorThemeMenu_SoylentGreen", class'ColorThemeMenu_SoylentGreen');
    is_valid("ColorThemeMenu_Starlight", class'ColorThemeMenu_Starlight');
    is_valid("ColorThemeMenu_Steel", class'ColorThemeMenu_Steel');
    is_valid("ColorThemeMenu_SteelGreen", class'ColorThemeMenu_SteelGreen');
    is_valid("ColorThemeMenu_Superhero", class'ColorThemeMenu_Superhero');
    is_valid("ColorThemeMenu_Terminator", class'ColorThemeMenu_Terminator');
    is_valid("ColorThemeMenu_Violet", class'ColorThemeMenu_Violet');
    is_valid("ComputerCameraUIChoice", class'ComputerCameraUIChoice');
    is_valid("ComputerPersonal", class'ComputerPersonal');
    is_valid("ComputerPublic", class'ComputerPublic');
    is_valid("Computers", class'Computers');
    is_valid("ComputerScreenATM", class'ComputerScreenATM');
    is_valid("ComputerScreenATMDisabled", class'ComputerScreenATMDisabled');
    is_valid("ComputerScreenATMWithdraw", class'ComputerScreenATMWithdraw');
    is_valid("ComputerScreenBulletins", class'ComputerScreenBulletins');
    is_valid("ComputerScreenEmail", class'ComputerScreenEmail');
    is_valid("ComputerScreenHack", class'ComputerScreenHack');
    is_valid("ComputerScreenHackAccounts", class'ComputerScreenHackAccounts');
    is_valid("ComputerScreenLogin", class'ComputerScreenLogin');
    is_valid("ComputerScreenSecurity", class'ComputerScreenSecurity');
    is_valid("ComputerScreenSpecialOptions", class'ComputerScreenSpecialOptions');
    is_valid("ComputerSecurity", class'ComputerSecurity');
    is_valid("ComputerSecurityCameraViewButton", class'ComputerSecurityCameraViewButton');
    is_valid("ComputerSecurityCameraWindow", class'ComputerSecurityCameraWindow');
    is_valid("ComputerSecurityChoice_Camera", class'ComputerSecurityChoice_Camera');
    is_valid("ComputerSecurityChoice_DoorAccess", class'ComputerSecurityChoice_DoorAccess');
    is_valid("ComputerSecurityChoice_DoorOpen", class'ComputerSecurityChoice_DoorOpen');
    is_valid("ComputerSecurityChoice_MPCamera", class'ComputerSecurityChoice_MPCamera');
    is_valid("ComputerSecurityChoice_Turret", class'ComputerSecurityChoice_Turret');
    is_valid("ComputerSecuritySliderWindow", class'ComputerSecuritySliderWindow');
    is_valid("ComputerUIScaleClientWindow", class'ComputerUIScaleClientWindow');
    is_valid("ComputerUIWindow", class'ComputerUIWindow');
    is_valid("ConChoiceWindow", class'ConChoiceWindow');
    is_valid("ConPlay", class'ConPlay');
    is_valid("ConPlayBark", class'ConPlayBark');
    is_valid("ConPlayBase", class'ConPlayBase');
    is_valid("Containers", class'Containers');
    is_valid("ControlPanel", class'ControlPanel');
    is_valid("ConversationTrigger", class'ConversationTrigger');
    is_valid("ConWindow", class'ConWindow');
    is_valid("ConWindowActive", class'ConWindowActive');
    is_valid("ConWindowSpeech", class'ConWindowSpeech');
    is_valid("Cop", class'Cop');
    is_valid("CopCarcass", class'CopCarcass');
    is_valid("CouchLeather", class'CouchLeather');
    is_valid("CrateBreakableMedCombat", class'CrateBreakableMedCombat');
    is_valid("CrateBreakableMedGeneral", class'CrateBreakableMedGeneral');
    is_valid("CrateBreakableMedMedical", class'CrateBreakableMedMedical');
    is_valid("CrateExplosiveSmall", class'CrateExplosiveSmall');
    is_valid("CrateUnbreakableLarge", class'CrateUnbreakableLarge');
    is_valid("CrateUnbreakableMed", class'CrateUnbreakableMed');
    is_valid("CrateUnbreakableSmall", class'CrateUnbreakableSmall');
    is_valid("Credits", class'Credits');
    is_valid("CreditsScrollWindow", class'CreditsScrollWindow');
    is_valid("CreditsWindow", class'CreditsWindow');
    is_valid("Crosshair", class'Crosshair');
    is_valid("Cushion", class'Cushion');
    is_valid("DamageHUDDisplay", class'DamageHUDDisplay');
    is_valid("DamageTrigger", class'DamageTrigger');
    is_valid("Dart", class'Dart');
    is_valid("DartFlare", class'DartFlare');
    is_valid("DartPoison", class'DartPoison');
    is_valid("DataCube", class'DataCube');
    is_valid("DataLinkPlay", class'DataLinkPlay');
    is_valid("DataLinkTrigger", class'DataLinkTrigger');
    is_valid("DataVaultImage", class'DataVaultImage');
    is_valid("DataVaultImageNote", class'DataVaultImageNote');
    is_valid("DeathMatchGame", class'DeathMatchGame');
    is_valid("DemoSplashWindow", class'DemoSplashWindow');
    is_valid("DentonClone", class'DentonClone');
    is_valid("DeusExAmmo", class'DeusExAmmo');
    is_valid("DeusExBaseWindow", class'DeusExBaseWindow');
    is_valid("DeusExCarcass", class'DeusExCarcass');
    is_valid("DeusExDecal", class'DeusExDecal');
    is_valid("DeusExDecoration", class'DeusExDecoration');
    is_valid("DeusExEditWindow", class'DeusExEditWindow');
    is_valid("DeusExFragment", class'DeusExFragment');
    is_valid("DeusExGameInfo", class'DeusExGameInfo');
    is_valid("DeusExGoal", class'DeusExGoal');
    is_valid("deusexgspylink", class'deusexgspylink');
    is_valid("DeusExHUD", class'DeusExHUD');
    is_valid("DeusExLevelInfo", class'DeusExLevelInfo');
    is_valid("deusexlocallink", class'deusexlocallink');
    is_valid("DeusExLog", class'DeusExLog');
    is_valid("DeusExMover", class'DeusExMover');
    is_valid("DeusExMPGame", class'DeusExMPGame');
    is_valid("DeusExNote", class'DeusExNote');
    is_valid("DeusExPickup", class'DeusExPickup');
    is_valid("DeusExPlayer", class'DeusExPlayer');
    is_valid("DeusExProjectile", class'DeusExProjectile');
    is_valid("DeusExRootWindow", class'DeusExRootWindow');
    is_valid("DeusExSaveInfo", class'DeusExSaveInfo');
    is_valid("DeusExScopeView", class'DeusExScopeView');
    is_valid("DeusExScrollAreaWindow", class'DeusExScrollAreaWindow');
    is_valid("deusexserverlist", class'deusexserverlist');
    is_valid("deusexserverping", class'deusexserverping');
    is_valid("DeusExWeapon", class'DeusExWeapon');
    is_valid("DirectionalTrigger", class'DirectionalTrigger');
    is_valid("Doberman", class'Doberman');
    is_valid("DobermanCarcass", class'DobermanCarcass');
    is_valid("Doctor", class'Doctor');
    is_valid("DoctorCarcass", class'DoctorCarcass');
    is_valid("Dog", class'Dog');
    is_valid("DumpLocation", class'DumpLocation');
    is_valid("DumpLocationBaseWindow", class'DumpLocationBaseWindow');
    is_valid("DumpLocationEditWindow", class'DumpLocationEditWindow');
    is_valid("DumpLocationListLocationsWindow", class'DumpLocationListLocationsWindow');
    is_valid("DumpLocationListWindow", class'DumpLocationListWindow');
    is_valid("DXLogo", class'DXLogo');
    is_valid("dxmaplist", class'dxmaplist');
    is_valid("DXRActorsBase", class'DXRActorsBase');
    is_valid("DXRando", class'DXRando');
    is_valid("DXRAugmentations", class'DXRAugmentations');
    is_valid("DXRAutosave", class'DXRAutosave');
    is_valid("DXRBase", class'DXRBase');
    is_valid("DXREnemies", class'DXREnemies');
    is_valid("DXRFixup", class'DXRFixup');
    is_valid("DXRFlags", class'DXRFlags');
    is_valid("DXRKeys", class'DXRKeys');
    is_valid("DXRMenuScreenNewGame", class'DXRMenuScreenNewGame');
    is_valid("DXRMenuSetupRando", class'DXRMenuSetupRando');
    is_valid("DXRNames", class'DXRNames');
    is_valid("DXRPasswords", class'DXRPasswords');
    is_valid("DXRReduceItems", class'DXRReduceItems');
    is_valid("DXRSkills", class'DXRSkills');
    is_valid("DXRSwapItems", class'DXRSwapItems');
    is_valid("DXText", class'DXText');
    is_valid("Earth", class'Earth');
    is_valid("EidosLogo", class'EidosLogo');
    is_valid("ElectricityEmitter", class'ElectricityEmitter');
    is_valid("ElectronicDevices", class'ElectronicDevices');
    is_valid("ElevatorMover", class'ElevatorMover');
    is_valid("EllipseEffect", class'EllipseEffect');
    is_valid("EMPGrenade", class'EMPGrenade');
    is_valid("ExplosionLarge", class'ExplosionLarge');
    is_valid("ExplosionLight", class'ExplosionLight');
    is_valid("ExplosionMedium", class'ExplosionMedium');
    is_valid("ExplosionSmall", class'ExplosionSmall');
    is_valid("FadeTextWindow", class'FadeTextWindow');
    is_valid("FadeViewTrigger", class'FadeViewTrigger');
    is_valid("Fan1", class'Fan1');
    is_valid("Fan1Vertical", class'Fan1Vertical');
    is_valid("Fan2", class'Fan2');
    is_valid("Faucet", class'Faucet');
    is_valid("Female1", class'Female1');
    is_valid("Female1Carcass", class'Female1Carcass');
    is_valid("Female2", class'Female2');
    is_valid("Female2Carcass", class'Female2Carcass');
    is_valid("Female3", class'Female3');
    is_valid("Female3Carcass", class'Female3Carcass');
    is_valid("Female4", class'Female4');
    is_valid("Female4Carcass", class'Female4Carcass');
    is_valid("Fire", class'Fire');
    is_valid("Fireball", class'Fireball');
    is_valid("FireballRocket", class'FireballRocket');
    is_valid("FireComet", class'FireComet');
    is_valid("FireExtinguisher", class'FireExtinguisher');
    is_valid("FirePlug", class'FirePlug');
    is_valid("Fish", class'Fish');
    is_valid("Fish2", class'Fish2');
    is_valid("Fish2Generator", class'Fish2Generator');
    is_valid("Fishes", class'Fishes');
    is_valid("FishGenerator", class'FishGenerator');
    is_valid("FlagAddWindow", class'FlagAddWindow');
    is_valid("FlagEditWindow", class'FlagEditWindow');
    is_valid("FlagPole", class'FlagPole');
    is_valid("FlagTrigger", class'FlagTrigger');
    is_valid("Flare", class'Flare');
    is_valid("Flask", class'Flask');
    is_valid("FleshFragment", class'FleshFragment');
    is_valid("Flowers", class'Flowers');
    is_valid("Fly", class'Fly');
    is_valid("FlyGenerator", class'FlyGenerator');
    is_valid("FordSchick", class'FordSchick');
    is_valid("FordSchickCarcass", class'FordSchickCarcass');
    is_valid("FrobDisplayWindow", class'FrobDisplayWindow');
    is_valid("Furniture", class'Furniture');
    is_valid("GameDirectory", class'GameDirectory');
    is_valid("GarySavage", class'GarySavage');
    is_valid("GarySavageCarcass", class'GarySavageCarcass');
    is_valid("GasGrenade", class'GasGrenade');
    is_valid("GeneratorScout", class'GeneratorScout');
    is_valid("GilbertRenton", class'GilbertRenton');
    is_valid("GilbertRentonCarcass", class'GilbertRentonCarcass');
    is_valid("GlassFragment", class'GlassFragment');
    is_valid("GoalCompleteTrigger", class'GoalCompleteTrigger');
    is_valid("GordonQuick", class'GordonQuick');
    is_valid("GordonQuickCarcass", class'GordonQuickCarcass');
    is_valid("Gray", class'Gray');
    is_valid("GrayCarcass", class'GrayCarcass');
    is_valid("GraySpit", class'GraySpit');
    is_valid("Greasel", class'Greasel');
    is_valid("GreaselCarcass", class'GreaselCarcass');
    is_valid("GreaselSpit", class'GreaselSpit');
    is_valid("GuntherHermann", class'GuntherHermann');
    is_valid("GuntherHermannCarcass", class'GuntherHermannCarcass');
    is_valid("HackableDevices", class'HackableDevices');
    is_valid("HalonGas", class'HalonGas');
    is_valid("HangingChicken", class'HangingChicken');
    is_valid("HangingDecoration", class'HangingDecoration');
    is_valid("HangingShopLight", class'HangingShopLight');
    is_valid("HarleyFilben", class'HarleyFilben');
    is_valid("HarleyFilbenCarcass", class'HarleyFilbenCarcass');
    is_valid("HazMatSuit", class'HazMatSuit');
    is_valid("HECannister20mm", class'HECannister20mm');
    is_valid("HidePoint", class'HidePoint');
    is_valid("Highlight", class'Highlight');
    is_valid("HKBirdcage", class'HKBirdcage');
    is_valid("HKBuddha", class'HKBuddha');
    is_valid("HKChair", class'HKChair');
    is_valid("HKCouch", class'HKCouch');
    is_valid("HKHangingLantern", class'HKHangingLantern');
    is_valid("HKHangingLantern2", class'HKHangingLantern2');
    is_valid("HKHangingPig", class'HKHangingPig');
    is_valid("HKIncenseBurner", class'HKIncenseBurner');
    is_valid("HKMarketLight", class'HKMarketLight');
    is_valid("HKMarketTable", class'HKMarketTable');
    is_valid("HKMarketTarp", class'HKMarketTarp');
    is_valid("HKMilitary", class'HKMilitary');
    is_valid("HKMilitaryCarcass", class'HKMilitaryCarcass');
    is_valid("HKTable", class'HKTable');
    is_valid("HKTukTuk", class'HKTukTuk');
    is_valid("HongKongDecoration", class'HongKongDecoration');
    is_valid("Hooker1", class'Hooker1');
    is_valid("Hooker1Carcass", class'Hooker1Carcass');
    is_valid("Hooker2", class'Hooker2');
    is_valid("Hooker2Carcass", class'Hooker2Carcass');
    is_valid("HowardStrong", class'HowardStrong');
    is_valid("HowardStrongCarcass", class'HowardStrongCarcass');
    is_valid("HUDActiveAug", class'HUDActiveAug');
    is_valid("HUDActiveAugsBorder", class'HUDActiveAugsBorder');
    is_valid("HUDActiveItem", class'HUDActiveItem');
    is_valid("HUDActiveItemBase", class'HUDActiveItemBase');
    is_valid("HUDActiveItemsBorder", class'HUDActiveItemsBorder');
    is_valid("HUDActiveItemsBorderBase", class'HUDActiveItemsBorderBase');
    is_valid("HUDActiveItemsDisplay", class'HUDActiveItemsDisplay');
    is_valid("HUDAmmoDisplay", class'HUDAmmoDisplay');
    is_valid("HUDBarkDisplay", class'HUDBarkDisplay');
    is_valid("HUDBarkDisplayItem", class'HUDBarkDisplayItem');
    is_valid("HUDBaseWindow", class'HUDBaseWindow');
    is_valid("HUDCompassDisplay", class'HUDCompassDisplay');
    is_valid("HUDConWindowFirst", class'HUDConWindowFirst');
    is_valid("HUDHitDisplay", class'HUDHitDisplay');
    is_valid("HUDInfoLinkDisplay", class'HUDInfoLinkDisplay');
    is_valid("HUDInformationDisplay", class'HUDInformationDisplay');
    is_valid("HUDKeypadButton", class'HUDKeypadButton');
    is_valid("HUDKeypadWindow", class'HUDKeypadWindow');
    is_valid("HUDLogDisplay", class'HUDLogDisplay');
    is_valid("HUDMedBotAddAugsScreen", class'HUDMedBotAddAugsScreen');
    is_valid("HUDMedBotAugCanWindow", class'HUDMedBotAugCanWindow');
    is_valid("HUDMedBotAugItemButton", class'HUDMedBotAugItemButton');
    is_valid("HUDMedBotHealthOverlaysWindow", class'HUDMedBotHealthOverlaysWindow');
    is_valid("HUDMedBotHealthScreen", class'HUDMedBotHealthScreen');
    is_valid("HUDMedBotNavBarWindow", class'HUDMedBotNavBarWindow');
    is_valid("HUDMissionStartTextDisplay", class'HUDMissionStartTextDisplay');
    is_valid("HUDMultiplayer", class'HUDMultiplayer');
    is_valid("HUDMultiSkills", class'HUDMultiSkills');
    is_valid("HUDObjectBelt", class'HUDObjectBelt');
    is_valid("HUDObjectSlot", class'HUDObjectSlot');
    is_valid("HUDReceivedDisplay", class'HUDReceivedDisplay');
    is_valid("HUDReceivedDisplayItem", class'HUDReceivedDisplayItem');
    is_valid("HUDRechargeWindow", class'HUDRechargeWindow');
    is_valid("HUDSharedBorderWindow", class'HUDSharedBorderWindow');
    is_valid("Human", class'Human');
    is_valid("HumanCivilian", class'HumanCivilian');
    is_valid("HumanMilitary", class'HumanMilitary');
    is_valid("HumanThug", class'HumanThug');
    is_valid("Image01_GunFireSensor", class'Image01_GunFireSensor');
    is_valid("Image01_LibertyIsland", class'Image01_LibertyIsland');
    is_valid("Image01_TerroristCommander", class'Image01_TerroristCommander');
    is_valid("Image02_Ambrosia_Flyer", class'Image02_Ambrosia_Flyer');
    is_valid("Image02_BobPage_ManOfYear", class'Image02_BobPage_ManOfYear');
    is_valid("Image02_NYC_Warehouse", class'Image02_NYC_Warehouse');
    is_valid("Image03_747Diagram", class'Image03_747Diagram');
    is_valid("Image03_NYC_Airfield", class'Image03_NYC_Airfield');
    is_valid("Image03_WaltonSimons", class'Image03_WaltonSimons');
    is_valid("Image04_NSFHeadquarters", class'Image04_NSFHeadquarters');
    is_valid("Image04_UNATCONotice", class'Image04_UNATCONotice');
    is_valid("Image05_GreaselDisection", class'Image05_GreaselDisection');
    is_valid("Image05_NYC_MJ12Lab", class'Image05_NYC_MJ12Lab');
    is_valid("Image06_HK_Market", class'Image06_HK_Market');
    is_valid("Image06_HK_MJ12Helipad", class'Image06_HK_MJ12Helipad');
    is_valid("Image06_HK_MJ12Lab", class'Image06_HK_MJ12Lab');
    is_valid("Image06_HK_Versalife", class'Image06_HK_Versalife');
    is_valid("Image06_HK_WanChai", class'Image06_HK_WanChai');
    is_valid("Image08_JoeGreenMIBMJ12", class'Image08_JoeGreenMIBMJ12');
    is_valid("Image09_NYC_Ship_Bottom", class'Image09_NYC_Ship_Bottom');
    is_valid("Image09_NYC_Ship_Top", class'Image09_NYC_Ship_Top');
    is_valid("Image10_Paris_Catacombs", class'Image10_Paris_Catacombs');
    is_valid("Image10_Paris_CatacombsTunnels", class'Image10_Paris_CatacombsTunnels');
    is_valid("Image10_Paris_Metro", class'Image10_Paris_Metro');
    is_valid("Image11_Paris_Cathedral", class'Image11_Paris_Cathedral');
    is_valid("Image11_Paris_CathedralEntrance", class'Image11_Paris_CathedralEntrance');
    is_valid("Image12_Tiffany_HostagePic", class'Image12_Tiffany_HostagePic');
    is_valid("Image12_Vandenberg_Command", class'Image12_Vandenberg_Command');
    is_valid("Image12_Vandenberg_Sub", class'Image12_Vandenberg_Sub');
    is_valid("Image14_OceanLab", class'Image14_OceanLab');
    is_valid("Image14_Schematic", class'Image14_Schematic');
    is_valid("Image15_Area51Bunker", class'Image15_Area51Bunker');
    is_valid("Image15_Area51_Sector3", class'Image15_Area51_Sector3');
    is_valid("Image15_Area51_Sector4", class'Image15_Area51_Sector4');
    is_valid("Image15_BlueFusionDevice", class'Image15_BlueFusionDevice');
    is_valid("Image15_GrayDisection", class'Image15_GrayDisection');
    is_valid("InformationDevices", class'InformationDevices');
    is_valid("InterpolateTrigger", class'InterpolateTrigger');
    is_valid("InvokeConWindow", class'InvokeConWindow');
    is_valid("InvulnSphere", class'InvulnSphere');
    is_valid("IonStormLogo", class'IonStormLogo');
    is_valid("JaimeReyes", class'JaimeReyes');
    is_valid("JaimeReyesCarcass", class'JaimeReyesCarcass');
    is_valid("Janitor", class'Janitor');
    is_valid("JanitorCarcass", class'JanitorCarcass');
    is_valid("JCDentonMale", class'JCDentonMale');
    is_valid("JCDentonMaleCarcass", class'JCDentonMaleCarcass');
    is_valid("JCDouble", class'JCDouble');
    is_valid("Jock", class'Jock');
    is_valid("JockCarcass", class'JockCarcass');
    is_valid("JoeGreene", class'JoeGreene');
    is_valid("JoeGreeneCarcass", class'JoeGreeneCarcass');
    is_valid("JoJoFine", class'JoJoFine');
    is_valid("JoJoFineCarcass", class'JoJoFineCarcass');
    is_valid("JordanShea", class'JordanShea');
    is_valid("JordanSheaCarcass", class'JordanSheaCarcass');
    is_valid("JosephManderley", class'JosephManderley');
    is_valid("JosephManderleyCarcass", class'JosephManderleyCarcass');
    is_valid("JuanLebedev", class'JuanLebedev');
    is_valid("JuanLebedevCarcass", class'JuanLebedevCarcass');
    is_valid("JunkieFemale", class'JunkieFemale');
    is_valid("JunkieFemaleCarcass", class'JunkieFemaleCarcass');
    is_valid("JunkieMale", class'JunkieMale');
    is_valid("JunkieMaleCarcass", class'JunkieMaleCarcass');
    is_valid("Karkian", class'Karkian');
    is_valid("KarkianBaby", class'KarkianBaby');
    is_valid("KarkianBabyCarcass", class'KarkianBabyCarcass');
    is_valid("KarkianCarcass", class'KarkianCarcass');
    is_valid("Keypad", class'Keypad');
    is_valid("Keypad1", class'Keypad1');
    is_valid("Keypad2", class'Keypad2');
    is_valid("Keypad3", class'Keypad3');
    is_valid("KillerProfile", class'KillerProfile');
    is_valid("LAM", class'LAM');
    is_valid("Lamp", class'Lamp');
    is_valid("Lamp1", class'Lamp1');
    is_valid("Lamp2", class'Lamp2');
    is_valid("Lamp3", class'Lamp3');
    is_valid("LaserEmitter", class'LaserEmitter');
    is_valid("LaserIterator", class'LaserIterator');
    is_valid("LaserProxy", class'LaserProxy');
    is_valid("LaserSpot", class'LaserSpot');
    is_valid("LaserTrigger", class'LaserTrigger');
    is_valid("LifeSupportBase", class'LifeSupportBase');
    is_valid("Lightbulb", class'Lightbulb');
    is_valid("LightSwitch", class'LightSwitch');
    is_valid("Liquor40oz", class'Liquor40oz');
    is_valid("LiquorBottle", class'LiquorBottle');
    is_valid("LoadMapWindow", class'LoadMapWindow');
    is_valid("Lockpick", class'Lockpick');
    is_valid("LogicTrigger", class'LogicTrigger');
    is_valid("LowerClassFemale", class'LowerClassFemale');
    is_valid("LowerClassFemaleCarcass", class'LowerClassFemaleCarcass');
    is_valid("LowerClassMale", class'LowerClassMale');
    is_valid("LowerClassMale2", class'LowerClassMale2');
    is_valid("LowerClassMale2Carcass", class'LowerClassMale2Carcass');
    is_valid("LowerClassMaleCarcass", class'LowerClassMaleCarcass');
    is_valid("LuciusDeBeers", class'LuciusDeBeers');
    is_valid("MaggieChow", class'MaggieChow');
    is_valid("MaggieChowCarcass", class'MaggieChowCarcass');
    is_valid("Maid", class'Maid');
    is_valid("MaidCarcass", class'MaidCarcass');
    is_valid("Mailbox", class'Mailbox');
    is_valid("Male1", class'Male1');
    is_valid("Male1Carcass", class'Male1Carcass');
    is_valid("Male2", class'Male2');
    is_valid("Male2Carcass", class'Male2Carcass');
    is_valid("Male3", class'Male3');
    is_valid("Male3Carcass", class'Male3Carcass');
    is_valid("Male4", class'Male4');
    is_valid("Male4Carcass", class'Male4Carcass');
    is_valid("MapExit", class'MapExit');
    is_valid("MargaretWilliams", class'MargaretWilliams');
    is_valid("MargaretWilliamsCarcass", class'MargaretWilliamsCarcass');
    is_valid("MaxChen", class'MaxChen');
    is_valid("MaxChenCarcass", class'MaxChenCarcass');
    is_valid("Mechanic", class'Mechanic');
    is_valid("MechanicCarcass", class'MechanicCarcass');
    is_valid("MedicalBot", class'MedicalBot');
    is_valid("MedKit", class'MedKit');
    is_valid("MenuChoice_AdjustBrightness", class'MenuChoice_AdjustBrightness');
    is_valid("MenuChoice_AdjustColors", class'MenuChoice_AdjustColors');
    is_valid("MenuChoice_AlwaysRun", class'MenuChoice_AlwaysRun');
    is_valid("menuchoice_augbonus", class'menuchoice_augbonus');
    is_valid("menuchoice_augsallowed", class'menuchoice_augsallowed');
    is_valid("MenuChoice_Brightness", class'MenuChoice_Brightness');
    is_valid("menuchoice_class", class'menuchoice_class');
    is_valid("menuchoice_connection", class'menuchoice_connection');
    is_valid("MenuChoice_Crosshairs", class'MenuChoice_Crosshairs');
    is_valid("menuchoice_cycle", class'menuchoice_cycle');
    is_valid("MenuChoice_Decals", class'MenuChoice_Decals');
    is_valid("MenuChoice_DetailTextures", class'MenuChoice_DetailTextures');
    is_valid("MenuChoice_EffectsChannels", class'MenuChoice_EffectsChannels');
    is_valid("MenuChoice_EnabledDisabled", class'MenuChoice_EnabledDisabled');
    is_valid("menuchoice_friendlyfire", class'menuchoice_friendlyfire');
    is_valid("MenuChoice_FullScreen", class'MenuChoice_FullScreen');
    is_valid("menuchoice_gametype", class'menuchoice_gametype');
    is_valid("MenuChoice_GoreLevel", class'MenuChoice_GoreLevel');
    is_valid("MenuChoice_HeadBob", class'MenuChoice_HeadBob');
    is_valid("MenuChoice_HUDAugDisplay", class'MenuChoice_HUDAugDisplay');
    is_valid("MenuChoice_HUDBordersVisible", class'MenuChoice_HUDBordersVisible');
    is_valid("MenuChoice_HUDBorderTranslucency", class'MenuChoice_HUDBorderTranslucency');
    is_valid("MenuChoice_HUDColor", class'MenuChoice_HUDColor');
    is_valid("MenuChoice_HUDTranslucency", class'MenuChoice_HUDTranslucency');
    is_valid("MenuChoice_InvertMouse", class'MenuChoice_InvertMouse');
    is_valid("MenuChoice_LogTimeoutValue", class'MenuChoice_LogTimeoutValue');
    is_valid("MenuChoice_LowMedHigh", class'MenuChoice_LowMedHigh');
    is_valid("menuchoice_map", class'menuchoice_map');
    is_valid("MenuChoice_MaxLogLines", class'MenuChoice_MaxLogLines');
    is_valid("menuchoice_maxplayers", class'menuchoice_maxplayers');
    is_valid("MenuChoice_MenuColor", class'MenuChoice_MenuColor');
    is_valid("MenuChoice_MenuTranslucency", class'MenuChoice_MenuTranslucency');
    is_valid("MenuChoice_MouseSensitivity", class'MenuChoice_MouseSensitivity');
    is_valid("menuchoice_multihelp", class'menuchoice_multihelp');
    is_valid("MenuChoice_MusicVolume", class'MenuChoice_MusicVolume');
    is_valid("MenuChoice_ObjectNames", class'MenuChoice_ObjectNames');
    is_valid("MenuChoice_ObjectTextureDetail", class'MenuChoice_ObjectTextureDetail');
    is_valid("MenuChoice_OnOff", class'MenuChoice_OnOff');
    is_valid("MenuChoice_RenderDevice", class'MenuChoice_RenderDevice');
    is_valid("MenuChoice_Resolution", class'MenuChoice_Resolution');
    is_valid("MenuChoice_ReverseStereo", class'MenuChoice_ReverseStereo');
    is_valid("MenuChoice_SampleRate", class'MenuChoice_SampleRate');
    is_valid("menuchoice_servermode", class'menuchoice_servermode');
    is_valid("menuchoice_skillbonus", class'menuchoice_skillbonus');
    is_valid("menuchoice_skilllevel", class'menuchoice_skilllevel');
    is_valid("MenuChoice_SoundQuality", class'MenuChoice_SoundQuality');
    is_valid("MenuChoice_SoundVolume", class'MenuChoice_SoundVolume');
    is_valid("MenuChoice_SpeechVolume", class'MenuChoice_SpeechVolume');
    is_valid("menuchoice_Startingaugs", class'menuchoice_Startingaugs');
    is_valid("menuchoice_startingskills", class'menuchoice_startingskills');
    is_valid("MenuChoice_Subtitles", class'MenuChoice_Subtitles');
    is_valid("MenuChoice_SurroundSound", class'MenuChoice_SurroundSound');
    is_valid("menuchoice_team", class'menuchoice_team');
    is_valid("MenuChoice_TextureColorBits", class'MenuChoice_TextureColorBits');
    is_valid("MenuChoice_ThemeColor", class'MenuChoice_ThemeColor');
    is_valid("MenuChoice_ToggleCrouch", class'MenuChoice_ToggleCrouch');
    is_valid("MenuChoice_UIBackground", class'MenuChoice_UIBackground');
    is_valid("MenuChoice_Use3DHardware", class'MenuChoice_Use3DHardware');
    is_valid("menuchoice_victorytype", class'menuchoice_victorytype');
    is_valid("menuchoice_victoryvalue", class'menuchoice_victoryvalue');
    is_valid("MenuChoice_VisibleHidden", class'MenuChoice_VisibleHidden');
    is_valid("MenuChoice_Volume", class'MenuChoice_Volume');
    is_valid("MenuChoice_WeaponAutoReload", class'MenuChoice_WeaponAutoReload');
    is_valid("MenuChoice_WorldTextureDetail", class'MenuChoice_WorldTextureDetail');
    is_valid("MenuMain", class'MenuMain');
    is_valid("menumpmain", class'menumpmain');
    is_valid("MenuScreenAdjustColors", class'MenuScreenAdjustColors');
    is_valid("MenuScreenAdjustColorsExample", class'MenuScreenAdjustColorsExample');
    is_valid("menuscreenaugsetup", class'menuscreenaugsetup');
    is_valid("MenuScreenBrightness", class'MenuScreenBrightness');
    is_valid("MenuScreenControls", class'MenuScreenControls');
    is_valid("MenuScreenCustomizeKeys", class'MenuScreenCustomizeKeys');
    is_valid("MenuScreenDisplay", class'MenuScreenDisplay');
    is_valid("menuscreenhostgame", class'menuscreenhostgame');
    is_valid("menuscreenhostlan", class'menuscreenhostlan');
    is_valid("menuscreenhostnet", class'menuscreenhostnet');
    is_valid("menuscreenjoingame", class'menuscreenjoingame');
    is_valid("menuscreenjoininternet", class'menuscreenjoininternet');
    is_valid("menuscreenjoinlan", class'menuscreenjoinlan');
    is_valid("MenuScreenLoadGame", class'MenuScreenLoadGame');
    is_valid("MenuScreenNewGame", class'MenuScreenNewGame');
    is_valid("MenuScreenOptions", class'MenuScreenOptions');
    is_valid("menuscreenplayersetup", class'menuscreenplayersetup');
    is_valid("MenuScreenRGB", class'MenuScreenRGB');
    is_valid("MenuScreenRGB_HUDExample", class'MenuScreenRGB_HUDExample');
    is_valid("MenuScreenRGB_MenuExample", class'MenuScreenRGB_MenuExample');
    is_valid("MenuScreenSaveGame", class'MenuScreenSaveGame');
    is_valid("MenuScreenSound", class'MenuScreenSound');
    is_valid("MenuScreenThemesLoad", class'MenuScreenThemesLoad');
    is_valid("MenuScreenThemesSave", class'MenuScreenThemesSave');
    is_valid("MenuSelectDifficulty", class'MenuSelectDifficulty');
    is_valid("MenuSettings", class'MenuSettings');
    is_valid("MenuUIActionButtonBarWindow", class'MenuUIActionButtonBarWindow');
    is_valid("MenuUIActionButtonWindow", class'MenuUIActionButtonWindow');
    is_valid("MenuUIBorderButtonWindow", class'MenuUIBorderButtonWindow');
    is_valid("MenuUICheckboxWindow", class'MenuUICheckboxWindow');
    is_valid("MenuUIChoice", class'MenuUIChoice');
    is_valid("MenuUIChoiceAction", class'MenuUIChoiceAction');
    is_valid("MenuUIChoiceButton", class'MenuUIChoiceButton');
    is_valid("MenuUIChoiceEnum", class'MenuUIChoiceEnum');
    is_valid("MenuUIChoiceSlider", class'MenuUIChoiceSlider');
    is_valid("MenuUIChoiceWindow", class'MenuUIChoiceWindow');
    is_valid("MenuUIClientWindow", class'MenuUIClientWindow');
    is_valid("MenuUIDefaults", class'MenuUIDefaults');
    is_valid("MenuUIEditWindow", class'MenuUIEditWindow');
    is_valid("MenuUIHeaderWindow", class'MenuUIHeaderWindow');
    is_valid("MenuUIHelpWindow", class'MenuUIHelpWindow');
    is_valid("MenuUIInfoButtonWindow", class'MenuUIInfoButtonWindow');
    is_valid("MenuUILabelWindow", class'MenuUILabelWindow');
    is_valid("MenuUILeftEdgeWindow", class'MenuUILeftEdgeWindow');
    is_valid("MenuUIListHeaderButtonWindow", class'MenuUIListHeaderButtonWindow');
    is_valid("MenuUIListWindow", class'MenuUIListWindow');
    is_valid("MenuUILoadSaveEditWindow", class'MenuUILoadSaveEditWindow');
    is_valid("MenuUIMenuButtonWindow", class'MenuUIMenuButtonWindow');
    is_valid("MenuUIMenuWindow", class'MenuUIMenuWindow');
    is_valid("MenuUIMessageBoxShadowWindow", class'MenuUIMessageBoxShadowWindow');
    is_valid("MenuUIMessageBoxWindow", class'MenuUIMessageBoxWindow');
    is_valid("MenuUINavBarWindow", class'MenuUINavBarWindow');
    is_valid("MenuUINavButtonWindow", class'MenuUINavButtonWindow');
    is_valid("MenuUINormalLargeTextWindow", class'MenuUINormalLargeTextWindow');
    is_valid("MenuUIRGBSliderButtonWindow", class'MenuUIRGBSliderButtonWindow');
    is_valid("MenuUIRightEdgeWindow", class'MenuUIRightEdgeWindow');
    is_valid("MenuUIScreenWindow", class'MenuUIScreenWindow');
    is_valid("MenuUIScrollAreaWindow", class'MenuUIScrollAreaWindow');
    is_valid("MenuUIShadowWindow", class'MenuUIShadowWindow');
    is_valid("MenuUISkillInfoWindow", class'MenuUISkillInfoWindow');
    is_valid("MenuUISliderButtonWindow", class'MenuUISliderButtonWindow');
    is_valid("MenuUISmallLabelWindow", class'MenuUISmallLabelWindow');
    is_valid("MenuUISpecialButtonWindow", class'MenuUISpecialButtonWindow');
    is_valid("MenuUIStaticInfoWindow", class'MenuUIStaticInfoWindow');
    is_valid("MenuUITabButtonWindow", class'MenuUITabButtonWindow');
    is_valid("MenuUITitleWindow", class'MenuUITitleWindow');
    is_valid("MenuUIWindow", class'MenuUIWindow');
    is_valid("MetalFragment", class'MetalFragment');
    is_valid("MIB", class'MIB');
    is_valid("MIBCarcass", class'MIBCarcass');
    is_valid("MichaelHamner", class'MichaelHamner');
    is_valid("MichaelHamnerCarcass", class'MichaelHamnerCarcass');
    is_valid("Microscope", class'Microscope');
    is_valid("MilitaryBot", class'MilitaryBot');
    is_valid("MiniSub", class'MiniSub');
    is_valid("Mission00", class'Mission00');
    is_valid("Mission01", class'Mission01');
    is_valid("Mission02", class'Mission02');
    is_valid("Mission03", class'Mission03');
    is_valid("Mission04", class'Mission04');
    is_valid("Mission05", class'Mission05');
    is_valid("Mission06", class'Mission06');
    is_valid("Mission08", class'Mission08');
    is_valid("Mission09", class'Mission09');
    is_valid("Mission10", class'Mission10');
    is_valid("Mission11", class'Mission11');
    is_valid("Mission12", class'Mission12');
    is_valid("Mission14", class'Mission14');
    is_valid("Mission15", class'Mission15');
    is_valid("MissionEndgame", class'MissionEndgame');
    is_valid("MissionIntro", class'MissionIntro');
    is_valid("MissionScript", class'MissionScript');
    is_valid("MJ12Commando", class'MJ12Commando');
    is_valid("MJ12CommandoCarcass", class'MJ12CommandoCarcass');
    is_valid("MJ12Troop", class'MJ12Troop');
    is_valid("MJ12TroopCarcass", class'MJ12TroopCarcass');
    is_valid("Moon", class'Moon');
    is_valid("MorganEverett", class'MorganEverett');
    is_valid("MorganEverettCarcass", class'MorganEverettCarcass');
    is_valid("MoverCollider", class'MoverCollider');
    is_valid("MoverHighlight", class'MoverHighlight');
    is_valid("MovingWindow", class'MovingWindow');
    is_valid("mpmj12", class'mpmj12');
    is_valid("mpnsf", class'mpnsf');
    is_valid("mpplayertrack", class'mpplayertrack');
    is_valid("Mpunatco", class'Mpunatco');
    is_valid("MultiMover", class'MultiMover');
    is_valid("MultiplayerMessageWin", class'MultiplayerMessageWin');
    is_valid("Multitool", class'Multitool');
    is_valid("Mutt", class'Mutt');
    is_valid("MuttCarcass", class'MuttCarcass');
    is_valid("MuzzleFlash", class'MuzzleFlash');
    is_valid("NanoKey", class'NanoKey');
    is_valid("NanoKeyInfo", class'NanoKeyInfo');
    is_valid("NanoKeyRing", class'NanoKeyRing');
    is_valid("NanoVirusGrenade", class'NanoVirusGrenade');
    is_valid("NathanMadison", class'NathanMadison');
    is_valid("NathanMadisonCarcass", class'NathanMadisonCarcass');
    is_valid("NetworkTerminal", class'NetworkTerminal');
    is_valid("NetworkTerminalATM", class'NetworkTerminalATM');
    is_valid("NetworkTerminalPersonal", class'NetworkTerminalPersonal');
    is_valid("NetworkTerminalPublic", class'NetworkTerminalPublic');
    is_valid("NetworkTerminalSecurity", class'NetworkTerminalSecurity');
    is_valid("Newspaper", class'Newspaper');
    is_valid("NewspaperOpen", class'NewspaperOpen');
    is_valid("NewYorkDecoration", class'NewYorkDecoration');
    is_valid("NicoletteDuClare", class'NicoletteDuClare');
    is_valid("NicoletteDuClareCarcass", class'NicoletteDuClareCarcass');
    is_valid("Nurse", class'Nurse');
    is_valid("NurseCarcass", class'NurseCarcass');
    is_valid("NYEagleStatue", class'NYEagleStatue');
    is_valid("NYLiberty", class'NYLiberty');
    is_valid("NYLibertyTop", class'NYLibertyTop');
    is_valid("NYLibertyTorch", class'NYLibertyTorch');
    is_valid("NYPoliceBoat", class'NYPoliceBoat');
    is_valid("OfficeChair", class'OfficeChair');
    is_valid("OrdersTrigger", class'OrdersTrigger');
    is_valid("OutdoorThings", class'OutdoorThings');
    is_valid("Pan1", class'Pan1');
    is_valid("Pan2", class'Pan2');
    is_valid("Pan3", class'Pan3');
    is_valid("Pan4", class'Pan4');
    is_valid("PaperFragment", class'PaperFragment');
    is_valid("ParticleGenerator", class'ParticleGenerator');
    is_valid("ParticleIterator", class'ParticleIterator');
    is_valid("ParticleProxy", class'ParticleProxy');
    is_valid("PaulDenton", class'PaulDenton');
    is_valid("PaulDentonCarcass", class'PaulDentonCarcass');
    is_valid("PawnGenerator", class'PawnGenerator');
    is_valid("PedestrianGenerator", class'PedestrianGenerator');
    is_valid("PersonaActionButtonWindow", class'PersonaActionButtonWindow');
    is_valid("PersonaAmmoDetailButton", class'PersonaAmmoDetailButton');
    is_valid("PersonaAugmentationBodyWindow", class'PersonaAugmentationBodyWindow');
    is_valid("PersonaAugmentationItemButton", class'PersonaAugmentationItemButton');
    is_valid("PersonaAugmentationOverlaysWindow", class'PersonaAugmentationOverlaysWindow');
    is_valid("PersonaBaseWindow", class'PersonaBaseWindow');
    is_valid("PersonaBorderButtonWindow", class'PersonaBorderButtonWindow');
    is_valid("PersonaButtonBarWindow", class'PersonaButtonBarWindow');
    is_valid("PersonaCheckBoxWindow", class'PersonaCheckBoxWindow');
    is_valid("PersonaClientBaseWindow", class'PersonaClientBaseWindow');
    is_valid("PersonaClientBorderWindow", class'PersonaClientBorderWindow');
    is_valid("PersonaClientWindow", class'PersonaClientWindow');
    is_valid("PersonaEditWindow", class'PersonaEditWindow');
    is_valid("PersonaGoalItemWindow", class'PersonaGoalItemWindow');
    is_valid("PersonaGoalTextWindow", class'PersonaGoalTextWindow');
    is_valid("PersonaHeaderLargeTextWindow", class'PersonaHeaderLargeTextWindow');
    is_valid("PersonaHeaderTextWindow", class'PersonaHeaderTextWindow');
    is_valid("PersonaHealthActionButtonWindow", class'PersonaHealthActionButtonWindow');
    is_valid("PersonaHealthBodyWindow", class'PersonaHealthBodyWindow');
    is_valid("PersonaHealthItemButton", class'PersonaHealthItemButton');
    is_valid("PersonaHealthOverlaysWindow", class'PersonaHealthOverlaysWindow');
    is_valid("PersonaHealthRegionWindow", class'PersonaHealthRegionWindow');
    is_valid("PersonaImageNewLegendLabel", class'PersonaImageNewLegendLabel');
    is_valid("PersonaImageNoteWindow", class'PersonaImageNoteWindow');
    is_valid("PersonaImageWindow", class'PersonaImageWindow');
    is_valid("PersonaInfoItemWindow", class'PersonaInfoItemWindow');
    is_valid("PersonaInfoLineWindow", class'PersonaInfoLineWindow');
    is_valid("PersonaInfoWindow", class'PersonaInfoWindow');
    is_valid("PersonaInventoryCreditsWindow", class'PersonaInventoryCreditsWindow');
    is_valid("PersonaInventoryInfoWindow", class'PersonaInventoryInfoWindow');
    is_valid("PersonaInventoryItemButton", class'PersonaInventoryItemButton');
    is_valid("PersonaInventoryObjectBelt", class'PersonaInventoryObjectBelt');
    is_valid("PersonaItemButton", class'PersonaItemButton');
    is_valid("PersonaItemDetailButton", class'PersonaItemDetailButton');
    is_valid("PersonaItemDetailIconWindow", class'PersonaItemDetailIconWindow');
    is_valid("PersonaItemDetailWindow", class'PersonaItemDetailWindow');
    is_valid("PersonaLevelIconWindow", class'PersonaLevelIconWindow');
    is_valid("PersonaListWindow", class'PersonaListWindow');
    is_valid("PersonaNavBarBaseWindow", class'PersonaNavBarBaseWindow');
    is_valid("PersonaNavBarWindow", class'PersonaNavBarWindow');
    is_valid("PersonaNavButtonWindow", class'PersonaNavButtonWindow');
    is_valid("PersonaNormalLargeTextWindow", class'PersonaNormalLargeTextWindow');
    is_valid("PersonaNormalTextWindow", class'PersonaNormalTextWindow');
    is_valid("PersonaNotesEditWindow", class'PersonaNotesEditWindow');
    is_valid("PersonaOverlaysWindow", class'PersonaOverlaysWindow');
    is_valid("PersonaScreenAugmentations", class'PersonaScreenAugmentations');
    is_valid("PersonaScreenBaseWindow", class'PersonaScreenBaseWindow');
    is_valid("PersonaScreenConversations", class'PersonaScreenConversations');
    is_valid("PersonaScreenGoals", class'PersonaScreenGoals');
    is_valid("PersonaScreenHealth", class'PersonaScreenHealth');
    is_valid("PersonaScreenImages", class'PersonaScreenImages');
    is_valid("PersonaScreenInventory", class'PersonaScreenInventory');
    is_valid("PersonaScreenLogs", class'PersonaScreenLogs');
    is_valid("PersonaScreenSkills", class'PersonaScreenSkills');
    is_valid("PersonaScrollAreaWindow", class'PersonaScrollAreaWindow');
    is_valid("PersonaSkillButtonWindow", class'PersonaSkillButtonWindow');
    is_valid("PersonaSkillTextWindow", class'PersonaSkillTextWindow');
    is_valid("PersonaStatusLineWindow", class'PersonaStatusLineWindow');
    is_valid("PersonaTitleTextWindow", class'PersonaTitleTextWindow');
    is_valid("PhilipMead", class'PhilipMead');
    is_valid("PhilipMeadCarcass", class'PhilipMeadCarcass');
    is_valid("Phone", class'Phone');
    is_valid("PickupDistributor", class'PickupDistributor');
    is_valid("PictureWindow", class'PictureWindow');
    is_valid("Pigeon", class'Pigeon');
    is_valid("PigeonCarcass", class'PigeonCarcass');
    is_valid("PigeonGenerator", class'PigeonGenerator');
    is_valid("Pillow", class'Pillow');
    is_valid("Pinball", class'Pinball');
    is_valid("Plant1", class'Plant1');
    is_valid("Plant2", class'Plant2');
    is_valid("Plant3", class'Plant3');
    is_valid("PlasmaBolt", class'PlasmaBolt');
    is_valid("PlasticFragment", class'PlasticFragment');
    is_valid("PlayMusicWindow", class'PlayMusicWindow');
    is_valid("PoisonGas", class'PoisonGas');
    is_valid("Poolball", class'Poolball');
    is_valid("PoolTableLight", class'PoolTableLight');
    is_valid("Pot1", class'Pot1');
    is_valid("Pot2", class'Pot2');
    is_valid("POVCorpse", class'POVCorpse');
    is_valid("ProgressBarWindow", class'ProgressBarWindow');
    is_valid("ProjectileGenerator", class'ProjectileGenerator');
    is_valid("QuotesWindow", class'QuotesWindow');
    is_valid("RachelMead", class'RachelMead');
    is_valid("RachelMeadCarcass", class'RachelMeadCarcass');
    is_valid("RandomEvents", class'RandomEvents');
    is_valid("RandomSounds", class'RandomSounds');
    is_valid("Rat", class'Rat');
    is_valid("RatCarcass", class'RatCarcass');
    is_valid("RatGenerator", class'RatGenerator');
    is_valid("Rebreather", class'Rebreather');
    is_valid("RepairBot", class'RepairBot');
    is_valid("RetinalScanner", class'RetinalScanner');
    is_valid("RiotCop", class'RiotCop');
    is_valid("RiotCopCarcass", class'RiotCopCarcass');
    is_valid("RoadBlock", class'RoadBlock');
    is_valid("Robot", class'Robot');
    is_valid("Rockchip", class'Rockchip');
    is_valid("Rocket", class'Rocket');
    is_valid("RocketLAW", class'RocketLAW');
    is_valid("RocketMini", class'RocketMini');
    is_valid("RocketRobot", class'RocketRobot');
    is_valid("RocketWP", class'RocketWP');
    is_valid("Sailor", class'Sailor');
    is_valid("SailorCarcass", class'SailorCarcass');
    is_valid("SamCarter", class'SamCarter');
    is_valid("SamCarterCarcass", class'SamCarterCarcass');
    is_valid("SandraRenton", class'SandraRenton');
    is_valid("SandraRentonCarcass", class'SandraRentonCarcass');
    is_valid("SarahMead", class'SarahMead');
    is_valid("SarahMeadCarcass", class'SarahMeadCarcass');
    is_valid("SatelliteDish", class'SatelliteDish');
    is_valid("ScientistFemale", class'ScientistFemale');
    is_valid("ScientistFemaleCarcass", class'ScientistFemaleCarcass');
    is_valid("ScientistMale", class'ScientistMale');
    is_valid("ScientistMaleCarcass", class'ScientistMaleCarcass');
    is_valid("ScorchMark", class'ScorchMark');
    is_valid("ScriptedPawn", class'ScriptedPawn');
    is_valid("ScubaDiver", class'ScubaDiver');
    is_valid("ScubaDiverCarcass", class'ScubaDiverCarcass');
    is_valid("Seagull", class'Seagull');
    is_valid("SeagullCarcass", class'SeagullCarcass');
    is_valid("SeagullGenerator", class'SeagullGenerator');
    is_valid("Seat", class'Seat');
    is_valid("Secretary", class'Secretary');
    is_valid("SecretaryCarcass", class'SecretaryCarcass');
    is_valid("SecretService", class'SecretService');
    is_valid("SecretServiceCarcass", class'SecretServiceCarcass');
    is_valid("SecurityBot2", class'SecurityBot2');
    is_valid("SecurityBot3", class'SecurityBot3');
    is_valid("SecurityBot4", class'SecurityBot4');
    is_valid("SecurityCamera", class'SecurityCamera');
    is_valid("SenseTrigger", class'SenseTrigger');
    is_valid("SequenceEvents", class'SequenceEvents');
    is_valid("SequenceTrigger", class'SequenceTrigger');
    is_valid("Shadow", class'Shadow');
    is_valid("ShadowWindow", class'ShadowWindow');
    is_valid("ShakeTrigger", class'ShakeTrigger');
    is_valid("ShellCasing", class'ShellCasing');
    is_valid("ShellCasing2", class'ShellCasing2');
    is_valid("ShellCasingSilent", class'ShellCasingSilent');
    is_valid("shieldeffect", class'shieldeffect');
    is_valid("ShipsWheel", class'ShipsWheel');
    is_valid("ShockRing", class'ShockRing');
    is_valid("ShopLight", class'ShopLight');
    is_valid("ShowClassWindow", class'ShowClassWindow');
    is_valid("ShowerFaucet", class'ShowerFaucet');
    is_valid("ShowerHead", class'ShowerHead');
    is_valid("Shuriken", class'Shuriken');
    is_valid("SignFloor", class'SignFloor');
    is_valid("Skill", class'Skill');
    is_valid("SkillAwardTrigger", class'SkillAwardTrigger');
    is_valid("SkillComputer", class'SkillComputer');
    is_valid("SkillDemolition", class'SkillDemolition');
    is_valid("SkilledTool", class'SkilledTool');
    is_valid("SkillEnviro", class'SkillEnviro');
    is_valid("SkillLockpicking", class'SkillLockpicking');
    is_valid("SkillManager", class'SkillManager');
    is_valid("SkillMedicine", class'SkillMedicine');
    is_valid("SkillRadioBox", class'SkillRadioBox');
    is_valid("SkillSwimming", class'SkillSwimming');
    is_valid("SkillTech", class'SkillTech');
    is_valid("SkillWeaponHeavy", class'SkillWeaponHeavy');
    is_valid("SkillWeaponLowTech", class'SkillWeaponLowTech');
    is_valid("SkillWeaponPistol", class'SkillWeaponPistol');
    is_valid("SkillWeaponRifle", class'SkillWeaponRifle');
    is_valid("smokelessfire", class'smokelessfire');
    is_valid("SmokeTrail", class'SmokeTrail');
    is_valid("Smuggler", class'Smuggler');
    is_valid("SmugglerCarcass", class'SmugglerCarcass');
    is_valid("snipertracer", class'snipertracer');
    is_valid("Sodacan", class'Sodacan');
    is_valid("Soldier", class'Soldier');
    is_valid("SoldierCarcass", class'SoldierCarcass');
    is_valid("SoyFood", class'SoyFood');
    is_valid("Spark", class'Spark');
    is_valid("SpawnPoint", class'SpawnPoint');
    is_valid("SphereEffect", class'SphereEffect');
    is_valid("SpiderBot", class'SpiderBot');
    is_valid("SpiderBot2", class'SpiderBot2');
    is_valid("SpinningLogoWindow", class'SpinningLogoWindow');
    is_valid("SpyDrone", class'SpyDrone');
    is_valid("StantonDowd", class'StantonDowd');
    is_valid("StantonDowdCarcass", class'StantonDowdCarcass');
    is_valid("StaticWindow", class'StaticWindow');
    is_valid("StatueLion", class'StatueLion');
    is_valid("SubwayControlPanel", class'SubwayControlPanel');
    is_valid("SuperBall", class'SuperBall');
    is_valid("Switch1", class'Switch1');
    is_valid("Switch2", class'Switch2');
    is_valid("TAD", class'TAD');
    is_valid("TeamDMGame", class'TeamDMGame');
    is_valid("TearGas", class'TearGas');
    is_valid("TechGoggles", class'TechGoggles');
    is_valid("Terrorist", class'Terrorist');
    is_valid("TerroristCarcass", class'TerroristCarcass');
    is_valid("TerroristCommander", class'TerroristCommander');
    is_valid("TerroristCommanderCarcass", class'TerroristCommanderCarcass');
    is_valid("ThrownProjectile", class'ThrownProjectile');
    is_valid("ThugMale", class'ThugMale');
    is_valid("ThugMale2", class'ThugMale2');
    is_valid("ThugMale2Carcass", class'ThugMale2Carcass');
    is_valid("ThugMale3", class'ThugMale3');
    is_valid("ThugMale3Carcass", class'ThugMale3Carcass');
    is_valid("ThugMaleCarcass", class'ThugMaleCarcass');
    is_valid("TiffanySavage", class'TiffanySavage');
    is_valid("TiffanySavageCarcass", class'TiffanySavageCarcass');
    is_valid("Timer", class'Timer');
    is_valid("TimerDisplay", class'TimerDisplay');
    is_valid("TobyAtanwe", class'TobyAtanwe');
    is_valid("TobyAtanweCarcass", class'TobyAtanweCarcass');
    is_valid("Toilet", class'Toilet');
    is_valid("Toilet2", class'Toilet2');
    is_valid("ToolBorderWindow", class'ToolBorderWindow');
    is_valid("ToolButtonWindow", class'ToolButtonWindow');
    is_valid("ToolCheckboxWindow", class'ToolCheckboxWindow');
    is_valid("ToolEditWindow", class'ToolEditWindow');
    is_valid("ToolListWindow", class'ToolListWindow');
    is_valid("ToolMessageBoxWindow", class'ToolMessageBoxWindow');
    is_valid("ToolRadioButtonWindow", class'ToolRadioButtonWindow');
    is_valid("ToolScrollAreaWindow", class'ToolScrollAreaWindow');
    is_valid("ToolTitleBarWindow", class'ToolTitleBarWindow');
    is_valid("ToolWindow", class'ToolWindow');
    is_valid("tracehithandnonpenspawner", class'tracehithandnonpenspawner');
    is_valid("tracehithandspawner", class'tracehithandspawner');
    is_valid("TraceHitNonPenSpawner", class'TraceHitNonPenSpawner');
    is_valid("TraceHitSpawner", class'TraceHitSpawner');
    is_valid("Tracer", class'Tracer');
    is_valid("TracerTong", class'TracerTong');
    is_valid("TracerTongCarcass", class'TracerTongCarcass');
    is_valid("TrafficLight", class'TrafficLight');
    is_valid("Trash", class'Trash');
    is_valid("Trashbag", class'Trashbag');
    is_valid("Trashbag2", class'Trashbag2');
    is_valid("TrashCan1", class'TrashCan1');
    is_valid("Trashcan2", class'Trashcan2');
    is_valid("TrashCan3", class'TrashCan3');
    is_valid("TrashCan4", class'TrashCan4');
    is_valid("TrashGenerator", class'TrashGenerator');
    is_valid("TrashPaper", class'TrashPaper');
    is_valid("Tree", class'Tree');
    is_valid("Tree1", class'Tree1');
    is_valid("Tree2", class'Tree2');
    is_valid("Tree3", class'Tree3');
    is_valid("Tree4", class'Tree4');
    is_valid("TriadLumPath", class'TriadLumPath');
    is_valid("TriadLumPath2", class'TriadLumPath2');
    is_valid("TriadLumPath2Carcass", class'TriadLumPath2Carcass');
    is_valid("TriadLumPathCarcass", class'TriadLumPathCarcass');
    is_valid("TriadRedArrow", class'TriadRedArrow');
    is_valid("TriadRedArrowCarcass", class'TriadRedArrowCarcass');
    is_valid("Trophy", class'Trophy');
    is_valid("Tumbleweed", class'Tumbleweed');
    is_valid("UNATCOTroop", class'UNATCOTroop');
    is_valid("UNATCOTroopCarcass", class'UNATCOTroopCarcass');
    is_valid("UnTrigger", class'UnTrigger');
    is_valid("Valve", class'Valve');
    is_valid("Van", class'Van');
    is_valid("Vase1", class'Vase1');
    is_valid("Vase2", class'Vase2');
    is_valid("Vehicles", class'Vehicles');
    is_valid("VendingMachine", class'VendingMachine');
    is_valid("VialAmbrosia", class'VialAmbrosia');
    is_valid("VialCrack", class'VialCrack');
    is_valid("WaltonSimons", class'WaltonSimons');
    is_valid("WaltonSimonsCarcass", class'WaltonSimonsCarcass');
    is_valid("WanderPoint", class'WanderPoint');
    is_valid("WashingtonDecoration", class'WashingtonDecoration');
    is_valid("WaterCooler", class'WaterCooler');
    is_valid("WaterDrips", class'WaterDrips');
    is_valid("WaterFountain", class'WaterFountain');
    is_valid("WaterPool", class'WaterPool');
    is_valid("WaterRing", class'WaterRing');
    is_valid("WaterZone", class'WaterZone');
    is_valid("WeaponAssaultGun", class'WeaponAssaultGun');
    is_valid("WeaponAssaultShotgun", class'WeaponAssaultShotgun');
    is_valid("WeaponBaton", class'WeaponBaton');
    is_valid("WeaponCatScratch", class'WeaponCatScratch');
    is_valid("WeaponCombatKnife", class'WeaponCombatKnife');
    is_valid("WeaponCrowbar", class'WeaponCrowbar');
    is_valid("WeaponDogBite", class'WeaponDogBite');
    is_valid("WeaponEMPGrenade", class'WeaponEMPGrenade');
    is_valid("WeaponFlamethrower", class'WeaponFlamethrower');
    is_valid("WeaponGasGrenade", class'WeaponGasGrenade');
    is_valid("WeaponGEPGun", class'WeaponGEPGun');
    is_valid("WeaponGraySpit", class'WeaponGraySpit');
    is_valid("WeaponGraySwipe", class'WeaponGraySwipe');
    is_valid("WeaponGreaselSpit", class'WeaponGreaselSpit');
    is_valid("WeaponHideAGun", class'WeaponHideAGun');
    is_valid("WeaponKarkianBite", class'WeaponKarkianBite');
    is_valid("WeaponKarkianBump", class'WeaponKarkianBump');
    is_valid("WeaponLAM", class'WeaponLAM');
    is_valid("WeaponLAW", class'WeaponLAW');
    is_valid("WeaponMiniCrossbow", class'WeaponMiniCrossbow');
    is_valid("WeaponMJ12Commando", class'WeaponMJ12Commando');
    is_valid("WeaponMJ12Rocket", class'WeaponMJ12Rocket');
    is_valid("WeaponMod", class'WeaponMod');
    is_valid("WeaponModAccuracy", class'WeaponModAccuracy');
    is_valid("WeaponModClip", class'WeaponModClip');
    is_valid("WeaponModLaser", class'WeaponModLaser');
    is_valid("WeaponModRange", class'WeaponModRange');
    is_valid("WeaponModRecoil", class'WeaponModRecoil');
    is_valid("WeaponModReload", class'WeaponModReload');
    is_valid("WeaponModScope", class'WeaponModScope');
    is_valid("WeaponModSilencer", class'WeaponModSilencer');
    is_valid("WeaponNanoSword", class'WeaponNanoSword');
    is_valid("WeaponNanoVirusGrenade", class'WeaponNanoVirusGrenade');
    is_valid("WeaponNPCMelee", class'WeaponNPCMelee');
    is_valid("WeaponNPCRanged", class'WeaponNPCRanged');
    is_valid("WeaponPepperGun", class'WeaponPepperGun');
    is_valid("WeaponPistol", class'WeaponPistol');
    is_valid("WeaponPlasmaRifle", class'WeaponPlasmaRifle');
    is_valid("WeaponProd", class'WeaponProd');
    is_valid("WeaponRatBite", class'WeaponRatBite');
    is_valid("WeaponRifle", class'WeaponRifle');
    is_valid("WeaponRobotMachinegun", class'WeaponRobotMachinegun');
    is_valid("WeaponRobotRocket", class'WeaponRobotRocket');
    is_valid("WeaponSawedOffShotgun", class'WeaponSawedOffShotgun');
    is_valid("WeaponShuriken", class'WeaponShuriken');
    is_valid("WeaponSpiderBot", class'WeaponSpiderBot');
    is_valid("WeaponSpiderBot2", class'WeaponSpiderBot2');
    is_valid("WeaponStealthPistol", class'WeaponStealthPistol');
    is_valid("WeaponSword", class'WeaponSword');
    is_valid("WHBenchEast", class'WHBenchEast');
    is_valid("WHBenchLibrary", class'WHBenchLibrary');
    is_valid("WHBookstandLibrary", class'WHBookstandLibrary');
    is_valid("WHCabinet", class'WHCabinet');
    is_valid("WHChairDining", class'WHChairDining');
    is_valid("WHChairOvalOffice", class'WHChairOvalOffice');
    is_valid("WHChairPink", class'WHChairPink');
    is_valid("WHDeskLibrarySmall", class'WHDeskLibrarySmall');
    is_valid("WHDeskOvalOffice", class'WHDeskOvalOffice');
    is_valid("WHEndtableLibrary", class'WHEndtableLibrary');
    is_valid("WHFireplaceGrill", class'WHFireplaceGrill');
    is_valid("WHFireplaceLog", class'WHFireplaceLog');
    is_valid("WHPhone", class'WHPhone');
    is_valid("WHPiano", class'WHPiano');
    is_valid("WHRedCandleabra", class'WHRedCandleabra');
    is_valid("WHRedCouch", class'WHRedCouch');
    is_valid("WHRedEagleTable", class'WHRedEagleTable');
    is_valid("WHRedLampTable", class'WHRedLampTable');
    is_valid("WHRedOvalTable", class'WHRedOvalTable');
    is_valid("WHRedVase", class'WHRedVase');
    is_valid("WHTableBlue", class'WHTableBlue');
    is_valid("WIB", class'WIB');
    is_valid("WIBCarcass", class'WIBCarcass');
    is_valid("WineBottle", class'WineBottle');
    is_valid("WoodFragment", class'WoodFragment');

    l("i == " $ i);
}

function class<Actor> GetRandomActorClass()
{
    local int r, i;

    r = rng(577);

    if ( r == i++ ) return class'AcousticSensor';
    if ( r == i++ ) return class'AdaptiveArmor';
    if ( r == i++ ) return class'AIPrototype';
    if ( r == i++ ) return class'AlarmLight';
    if ( r == i++ ) return class'AlarmUnit';
    if ( r == i++ ) return class'AlexJacobson';
    if ( r == i++ ) return class'AlexJacobsonCarcass';
    if ( r == i++ ) return class'Ammo10mm';
    if ( r == i++ ) return class'Ammo20mm';
    if ( r == i++ ) return class'Ammo3006';
    if ( r == i++ ) return class'Ammo762mm';
    if ( r == i++ ) return class'AmmoBattery';
    if ( r == i++ ) return class'ammocrate';
    if ( r == i++ ) return class'AmmoDart';
    if ( r == i++ ) return class'AmmoDartFlare';
    if ( r == i++ ) return class'AmmoDartPoison';
    if ( r == i++ ) return class'AmmoEMPGrenade';
    if ( r == i++ ) return class'AmmoGasGrenade';
    if ( r == i++ ) return class'AmmoGraySpit';
    if ( r == i++ ) return class'AmmoGreaselSpit';
    if ( r == i++ ) return class'AmmoLAM';
    if ( r == i++ ) return class'AmmoNanoVirusGrenade';
    if ( r == i++ ) return class'AmmoNapalm';
    if ( r == i++ ) return class'AmmoNone';
    if ( r == i++ ) return class'AmmoPepper';
    if ( r == i++ ) return class'AmmoPlasma';
    if ( r == i++ ) return class'AmmoRocket';
    if ( r == i++ ) return class'AmmoRocketMini';
    if ( r == i++ ) return class'AmmoRocketRobot';
    if ( r == i++ ) return class'AmmoRocketWP';
    if ( r == i++ ) return class'AmmoSabot';
    if ( r == i++ ) return class'AmmoShell';
    if ( r == i++ ) return class'AmmoShuriken';
    if ( r == i++ ) return class'AnnaNavarre';
    if ( r == i++ ) return class'AnnaNavarreCarcass';
    if ( r == i++ ) return class'ATM';
    if ( r == i++ ) return class'AttackHelicopter';
    if ( r == i++ ) return class'AugmentationCannister';
    if ( r == i++ ) return class'AugmentationUpgradeCannister';
    if ( r == i++ ) return class'AutoTurret';
    if ( r == i++ ) return class'AutoTurretGun';
    if ( r == i++ ) return class'AutoTurretGunSmall';
    if ( r == i++ ) return class'AutoTurretSmall';
    if ( r == i++ ) return class'BallisticArmor';
    if ( r == i++ ) return class'Barrel1';
    if ( r == i++ ) return class'BarrelAmbrosia';
    if ( r == i++ ) return class'BarrelFire';
    if ( r == i++ ) return class'BarrelVirus';
    if ( r == i++ ) return class'Bartender';
    if ( r == i++ ) return class'BartenderCarcass';
    if ( r == i++ ) return class'Basket';
    if ( r == i++ ) return class'Basketball';
    if ( r == i++ ) return class'BeamTrigger';
    if ( r == i++ ) return class'Binoculars';
    if ( r == i++ ) return class'BioelectricCell';
    if ( r == i++ ) return class'BlackHelicopter';
    if ( r == i++ ) return class'BoatPerson';
    if ( r == i++ ) return class'BoatPersonCarcass';
    if ( r == i++ ) return class'BobPage';
    if ( r == i++ ) return class'BobPageAugmented';
    if ( r == i++ ) return class'BobPageCarcass';
    if ( r == i++ ) return class'BoneFemur';
    if ( r == i++ ) return class'BoneSkull';
    if ( r == i++ ) return class'BookClosed';
    if ( r == i++ ) return class'BookOpen';
    if ( r == i++ ) return class'BoxLarge';
    if ( r == i++ ) return class'BoxMedium';
    if ( r == i++ ) return class'BoxSmall';
    if ( r == i++ ) return class'BumFemale';
    if ( r == i++ ) return class'BumFemaleCarcass';
    if ( r == i++ ) return class'BumMale';
    if ( r == i++ ) return class'BumMale2';
    if ( r == i++ ) return class'BumMale2Carcass';
    if ( r == i++ ) return class'BumMale3';
    if ( r == i++ ) return class'BumMale3Carcass';
    if ( r == i++ ) return class'BumMaleCarcass';
    if ( r == i++ ) return class'Buoy';
    if ( r == i++ ) return class'Bushes1';
    if ( r == i++ ) return class'Bushes2';
    if ( r == i++ ) return class'Bushes3';
    if ( r == i++ ) return class'Businessman1';
    if ( r == i++ ) return class'Businessman1Carcass';
    if ( r == i++ ) return class'Businessman2';
    if ( r == i++ ) return class'Businessman2Carcass';
    if ( r == i++ ) return class'Businessman3';
    if ( r == i++ ) return class'Businessman3Carcass';
    if ( r == i++ ) return class'Businesswoman1';
    if ( r == i++ ) return class'Businesswoman1Carcass';
    if ( r == i++ ) return class'Butler';
    if ( r == i++ ) return class'ButlerCarcass';
    if ( r == i++ ) return class'Button1';
    if ( r == i++ ) return class'Cactus1';
    if ( r == i++ ) return class'Cactus2';
    if ( r == i++ ) return class'CageLight';
    if ( r == i++ ) return class'Candybar';
    if ( r == i++ ) return class'CarBurned';
    if ( r == i++ ) return class'CarStripped';
    if ( r == i++ ) return class'Cart';
    if ( r == i++ ) return class'CarWrecked';
    if ( r == i++ ) return class'Cat';
    if ( r == i++ ) return class'CatCarcass';
    if ( r == i++ ) return class'CeilingFan';
    if ( r == i++ ) return class'CeilingFanMotor';
    if ( r == i++ ) return class'Chad';
    if ( r == i++ ) return class'ChadCarcass';
    if ( r == i++ ) return class'Chair1';
    if ( r == i++ ) return class'ChairLeather';
    if ( r == i++ ) return class'Chandelier';
    if ( r == i++ ) return class'Chef';
    if ( r == i++ ) return class'ChefCarcass';
    if ( r == i++ ) return class'ChildMale';
    if ( r == i++ ) return class'ChildMale2';
    if ( r == i++ ) return class'ChildMale2Carcass';
    if ( r == i++ ) return class'ChildMaleCarcass';
    if ( r == i++ ) return class'CigaretteMachine';
    if ( r == i++ ) return class'Cigarettes';
    if ( r == i++ ) return class'CleanerBot';
    if ( r == i++ ) return class'ClothesRack';
    if ( r == i++ ) return class'CoffeeTable';
    if ( r == i++ ) return class'ComputerPersonal';
    if ( r == i++ ) return class'ComputerPublic';
    if ( r == i++ ) return class'ComputerSecurity';
    if ( r == i++ ) return class'ControlPanel';
    if ( r == i++ ) return class'Cop';
    if ( r == i++ ) return class'CopCarcass';
    if ( r == i++ ) return class'CouchLeather';
    if ( r == i++ ) return class'CrateBreakableMedCombat';
    if ( r == i++ ) return class'CrateBreakableMedGeneral';
    if ( r == i++ ) return class'CrateBreakableMedMedical';
    if ( r == i++ ) return class'CrateExplosiveSmall';
    if ( r == i++ ) return class'CrateUnbreakableLarge';
    if ( r == i++ ) return class'CrateUnbreakableMed';
    if ( r == i++ ) return class'CrateUnbreakableSmall';
    if ( r == i++ ) return class'Credits';
    if ( r == i++ ) return class'Cushion';
    if ( r == i++ ) return class'Dart';
    if ( r == i++ ) return class'DartFlare';
    if ( r == i++ ) return class'DartPoison';
    if ( r == i++ ) return class'DataCube';
    if ( r == i++ ) return class'DataVaultImage';
    if ( r == i++ ) return class'DentonClone';
    if ( r == i++ ) return class'Doberman';
    if ( r == i++ ) return class'DobermanCarcass';
    if ( r == i++ ) return class'Doctor';
    if ( r == i++ ) return class'DoctorCarcass';
    if ( r == i++ ) return class'DXLogo';
    if ( r == i++ ) return class'DXText';
    if ( r == i++ ) return class'Earth';
    if ( r == i++ ) return class'EidosLogo';
    if ( r == i++ ) return class'EMPGrenade';
    if ( r == i++ ) return class'Fan1';
    if ( r == i++ ) return class'Fan1Vertical';
    if ( r == i++ ) return class'Fan2';
    if ( r == i++ ) return class'Faucet';
    if ( r == i++ ) return class'Female1';
    if ( r == i++ ) return class'Female1Carcass';
    if ( r == i++ ) return class'Female2';
    if ( r == i++ ) return class'Female2Carcass';
    if ( r == i++ ) return class'Female3';
    if ( r == i++ ) return class'Female3Carcass';
    if ( r == i++ ) return class'Female4';
    if ( r == i++ ) return class'Female4Carcass';
    if ( r == i++ ) return class'FireExtinguisher';
    if ( r == i++ ) return class'FirePlug';
    if ( r == i++ ) return class'Fish';
    if ( r == i++ ) return class'Fish2';
    if ( r == i++ ) return class'Fishes';
    if ( r == i++ ) return class'FlagPole';
    if ( r == i++ ) return class'Flare';
    if ( r == i++ ) return class'Flask';
    if ( r == i++ ) return class'FleshFragment';
    if ( r == i++ ) return class'Flowers';
    if ( r == i++ ) return class'Fly';
    if ( r == i++ ) return class'FordSchick';
    if ( r == i++ ) return class'FordSchickCarcass';
    if ( r == i++ ) return class'GarySavage';
    if ( r == i++ ) return class'GarySavageCarcass';
    if ( r == i++ ) return class'GasGrenade';
    if ( r == i++ ) return class'GilbertRenton';
    if ( r == i++ ) return class'GilbertRentonCarcass';
    if ( r == i++ ) return class'GlassFragment';
    if ( r == i++ ) return class'GordonQuick';
    if ( r == i++ ) return class'GordonQuickCarcass';
    if ( r == i++ ) return class'Gray';
    if ( r == i++ ) return class'GrayCarcass';
    if ( r == i++ ) return class'Greasel';
    if ( r == i++ ) return class'GreaselCarcass';
    if ( r == i++ ) return class'GuntherHermann';
    if ( r == i++ ) return class'GuntherHermannCarcass';
    if ( r == i++ ) return class'HangingChicken';
    if ( r == i++ ) return class'HangingShopLight';
    if ( r == i++ ) return class'HarleyFilben';
    if ( r == i++ ) return class'HarleyFilbenCarcass';
    if ( r == i++ ) return class'HazMatSuit';
    if ( r == i++ ) return class'HECannister20mm';
    if ( r == i++ ) return class'HKBirdcage';
    if ( r == i++ ) return class'HKBuddha';
    if ( r == i++ ) return class'HKChair';
    if ( r == i++ ) return class'HKCouch';
    if ( r == i++ ) return class'HKHangingLantern';
    if ( r == i++ ) return class'HKHangingLantern2';
    if ( r == i++ ) return class'HKHangingPig';
    if ( r == i++ ) return class'HKIncenseBurner';
    if ( r == i++ ) return class'HKMarketLight';
    if ( r == i++ ) return class'HKMarketTable';
    if ( r == i++ ) return class'HKMarketTarp';
    if ( r == i++ ) return class'HKMilitary';
    if ( r == i++ ) return class'HKMilitaryCarcass';
    if ( r == i++ ) return class'HKTable';
    if ( r == i++ ) return class'HKTukTuk';
    if ( r == i++ ) return class'Hooker1';
    if ( r == i++ ) return class'Hooker1Carcass';
    if ( r == i++ ) return class'Hooker2';
    if ( r == i++ ) return class'Hooker2Carcass';
    if ( r == i++ ) return class'HowardStrong';
    if ( r == i++ ) return class'HowardStrongCarcass';
    if ( r == i++ ) return class'Image01_GunFireSensor';
    if ( r == i++ ) return class'Image01_LibertyIsland';
    if ( r == i++ ) return class'Image01_TerroristCommander';
    if ( r == i++ ) return class'Image02_Ambrosia_Flyer';
    if ( r == i++ ) return class'Image02_BobPage_ManOfYear';
    if ( r == i++ ) return class'Image02_NYC_Warehouse';
    if ( r == i++ ) return class'Image03_747Diagram';
    if ( r == i++ ) return class'Image03_NYC_Airfield';
    if ( r == i++ ) return class'Image03_WaltonSimons';
    if ( r == i++ ) return class'Image04_NSFHeadquarters';
    if ( r == i++ ) return class'Image04_UNATCONotice';
    if ( r == i++ ) return class'Image05_GreaselDisection';
    if ( r == i++ ) return class'Image05_NYC_MJ12Lab';
    if ( r == i++ ) return class'Image06_HK_Market';
    if ( r == i++ ) return class'Image06_HK_MJ12Helipad';
    if ( r == i++ ) return class'Image06_HK_MJ12Lab';
    if ( r == i++ ) return class'Image06_HK_Versalife';
    if ( r == i++ ) return class'Image06_HK_WanChai';
    if ( r == i++ ) return class'Image08_JoeGreenMIBMJ12';
    if ( r == i++ ) return class'Image09_NYC_Ship_Bottom';
    if ( r == i++ ) return class'Image09_NYC_Ship_Top';
    if ( r == i++ ) return class'Image10_Paris_Catacombs';
    if ( r == i++ ) return class'Image10_Paris_CatacombsTunnels';
    if ( r == i++ ) return class'Image10_Paris_Metro';
    if ( r == i++ ) return class'Image11_Paris_Cathedral';
    if ( r == i++ ) return class'Image11_Paris_CathedralEntrance';
    if ( r == i++ ) return class'Image12_Tiffany_HostagePic';
    if ( r == i++ ) return class'Image12_Vandenberg_Command';
    if ( r == i++ ) return class'Image12_Vandenberg_Sub';
    if ( r == i++ ) return class'Image14_OceanLab';
    if ( r == i++ ) return class'Image14_Schematic';
    if ( r == i++ ) return class'Image15_Area51Bunker';
    if ( r == i++ ) return class'Image15_Area51_Sector3';
    if ( r == i++ ) return class'Image15_Area51_Sector4';
    if ( r == i++ ) return class'Image15_BlueFusionDevice';
    if ( r == i++ ) return class'Image15_GrayDisection';
    if ( r == i++ ) return class'IonStormLogo';
    if ( r == i++ ) return class'JaimeReyes';
    if ( r == i++ ) return class'JaimeReyesCarcass';
    if ( r == i++ ) return class'Janitor';
    if ( r == i++ ) return class'JanitorCarcass';
    if ( r == i++ ) return class'JCDentonMale';
    if ( r == i++ ) return class'JCDentonMaleCarcass';
    if ( r == i++ ) return class'JCDouble';
    if ( r == i++ ) return class'Jock';
    if ( r == i++ ) return class'JockCarcass';
    if ( r == i++ ) return class'JoeGreene';
    if ( r == i++ ) return class'JoeGreeneCarcass';
    if ( r == i++ ) return class'JoJoFine';
    if ( r == i++ ) return class'JoJoFineCarcass';
    if ( r == i++ ) return class'JordanShea';
    if ( r == i++ ) return class'JordanSheaCarcass';
    if ( r == i++ ) return class'JosephManderley';
    if ( r == i++ ) return class'JosephManderleyCarcass';
    if ( r == i++ ) return class'JuanLebedev';
    if ( r == i++ ) return class'JuanLebedevCarcass';
    if ( r == i++ ) return class'JunkieFemale';
    if ( r == i++ ) return class'JunkieFemaleCarcass';
    if ( r == i++ ) return class'JunkieMale';
    if ( r == i++ ) return class'JunkieMaleCarcass';
    if ( r == i++ ) return class'Karkian';
    if ( r == i++ ) return class'KarkianBaby';
    if ( r == i++ ) return class'KarkianBabyCarcass';
    if ( r == i++ ) return class'KarkianCarcass';
    if ( r == i++ ) return class'Keypad1';
    if ( r == i++ ) return class'Keypad2';
    if ( r == i++ ) return class'Keypad3';
    if ( r == i++ ) return class'LAM';
    if ( r == i++ ) return class'Lamp1';
    if ( r == i++ ) return class'Lamp2';
    if ( r == i++ ) return class'Lamp3';
    if ( r == i++ ) return class'LaserTrigger';
    if ( r == i++ ) return class'LifeSupportBase';
    if ( r == i++ ) return class'Lightbulb';
    if ( r == i++ ) return class'LightSwitch';
    if ( r == i++ ) return class'Liquor40oz';
    if ( r == i++ ) return class'LiquorBottle';
    if ( r == i++ ) return class'Lockpick';
    if ( r == i++ ) return class'LowerClassFemale';
    if ( r == i++ ) return class'LowerClassFemaleCarcass';
    if ( r == i++ ) return class'LowerClassMale';
    if ( r == i++ ) return class'LowerClassMale2';
    if ( r == i++ ) return class'LowerClassMale2Carcass';
    if ( r == i++ ) return class'LowerClassMaleCarcass';
    if ( r == i++ ) return class'LuciusDeBeers';
    if ( r == i++ ) return class'MaggieChow';
    if ( r == i++ ) return class'MaggieChowCarcass';
    if ( r == i++ ) return class'Maid';
    if ( r == i++ ) return class'MaidCarcass';
    if ( r == i++ ) return class'Mailbox';
    if ( r == i++ ) return class'Male1';
    if ( r == i++ ) return class'Male1Carcass';
    if ( r == i++ ) return class'Male2';
    if ( r == i++ ) return class'Male2Carcass';
    if ( r == i++ ) return class'Male3';
    if ( r == i++ ) return class'Male3Carcass';
    if ( r == i++ ) return class'Male4';
    if ( r == i++ ) return class'Male4Carcass';
    if ( r == i++ ) return class'MargaretWilliams';
    if ( r == i++ ) return class'MargaretWilliamsCarcass';
    if ( r == i++ ) return class'MaxChen';
    if ( r == i++ ) return class'MaxChenCarcass';
    if ( r == i++ ) return class'Mechanic';
    if ( r == i++ ) return class'MechanicCarcass';
    if ( r == i++ ) return class'MedicalBot';
    if ( r == i++ ) return class'MedKit';
    if ( r == i++ ) return class'MetalFragment';
    if ( r == i++ ) return class'MIB';
    if ( r == i++ ) return class'MIBCarcass';
    if ( r == i++ ) return class'MichaelHamner';
    if ( r == i++ ) return class'MichaelHamnerCarcass';
    if ( r == i++ ) return class'Microscope';
    if ( r == i++ ) return class'MilitaryBot';
    if ( r == i++ ) return class'MiniSub';
    if ( r == i++ ) return class'MJ12Commando';
    if ( r == i++ ) return class'MJ12CommandoCarcass';
    if ( r == i++ ) return class'MJ12Troop';
    if ( r == i++ ) return class'MJ12TroopCarcass';
    if ( r == i++ ) return class'Moon';
    if ( r == i++ ) return class'MorganEverett';
    if ( r == i++ ) return class'MorganEverettCarcass';
    if ( r == i++ ) return class'mpmj12';
    if ( r == i++ ) return class'mpnsf';
    if ( r == i++ ) return class'Mpunatco';
    if ( r == i++ ) return class'Multitool';
    if ( r == i++ ) return class'Mutt';
    if ( r == i++ ) return class'MuttCarcass';
    if ( r == i++ ) return class'NanoKey';
    if ( r == i++ ) return class'NanoVirusGrenade';
    if ( r == i++ ) return class'NathanMadison';
    if ( r == i++ ) return class'NathanMadisonCarcass';
    if ( r == i++ ) return class'Newspaper';
    if ( r == i++ ) return class'NewspaperOpen';
    if ( r == i++ ) return class'NicoletteDuClare';
    if ( r == i++ ) return class'NicoletteDuClareCarcass';
    if ( r == i++ ) return class'Nurse';
    if ( r == i++ ) return class'NurseCarcass';
    if ( r == i++ ) return class'NYEagleStatue';
    if ( r == i++ ) return class'NYLiberty';
    if ( r == i++ ) return class'NYLibertyTop';
    if ( r == i++ ) return class'NYLibertyTorch';
    if ( r == i++ ) return class'NYPoliceBoat';
    if ( r == i++ ) return class'OfficeChair';
    if ( r == i++ ) return class'Pan1';
    if ( r == i++ ) return class'Pan2';
    if ( r == i++ ) return class'Pan3';
    if ( r == i++ ) return class'Pan4';
    if ( r == i++ ) return class'PaperFragment';
    if ( r == i++ ) return class'PaulDenton';
    if ( r == i++ ) return class'PaulDentonCarcass';
    if ( r == i++ ) return class'PhilipMead';
    if ( r == i++ ) return class'PhilipMeadCarcass';
    if ( r == i++ ) return class'Phone';
    if ( r == i++ ) return class'Pigeon';
    if ( r == i++ ) return class'PigeonCarcass';
    if ( r == i++ ) return class'Pillow';
    if ( r == i++ ) return class'Pinball';
    if ( r == i++ ) return class'Plant1';
    if ( r == i++ ) return class'Plant2';
    if ( r == i++ ) return class'Plant3';
    if ( r == i++ ) return class'PlasmaBolt';
    if ( r == i++ ) return class'PlasticFragment';
    if ( r == i++ ) return class'Poolball';
    if ( r == i++ ) return class'PoolTableLight';
    if ( r == i++ ) return class'Pot1';
    if ( r == i++ ) return class'Pot2';
    if ( r == i++ ) return class'POVCorpse';
    if ( r == i++ ) return class'RachelMead';
    if ( r == i++ ) return class'RachelMeadCarcass';
    if ( r == i++ ) return class'Rat';
    if ( r == i++ ) return class'RatCarcass';
    if ( r == i++ ) return class'Rebreather';
    if ( r == i++ ) return class'RepairBot';
    if ( r == i++ ) return class'RetinalScanner';
    if ( r == i++ ) return class'RiotCop';
    if ( r == i++ ) return class'RiotCopCarcass';
    if ( r == i++ ) return class'RoadBlock';
    if ( r == i++ ) return class'Rockchip';
    if ( r == i++ ) return class'Rocket';
    if ( r == i++ ) return class'RocketLAW';
    if ( r == i++ ) return class'RocketMini';
    if ( r == i++ ) return class'RocketRobot';
    if ( r == i++ ) return class'RocketWP';
    if ( r == i++ ) return class'Sailor';
    if ( r == i++ ) return class'SailorCarcass';
    if ( r == i++ ) return class'SamCarter';
    if ( r == i++ ) return class'SamCarterCarcass';
    if ( r == i++ ) return class'SandraRenton';
    if ( r == i++ ) return class'SandraRentonCarcass';
    if ( r == i++ ) return class'SarahMead';
    if ( r == i++ ) return class'SarahMeadCarcass';
    if ( r == i++ ) return class'SatelliteDish';
    if ( r == i++ ) return class'ScientistFemale';
    if ( r == i++ ) return class'ScientistFemaleCarcass';
    if ( r == i++ ) return class'ScientistMale';
    if ( r == i++ ) return class'ScientistMaleCarcass';
    if ( r == i++ ) return class'ScubaDiver';
    if ( r == i++ ) return class'ScubaDiverCarcass';
    if ( r == i++ ) return class'Seagull';
    if ( r == i++ ) return class'SeagullCarcass';
    if ( r == i++ ) return class'Secretary';
    if ( r == i++ ) return class'SecretaryCarcass';
    if ( r == i++ ) return class'SecretService';
    if ( r == i++ ) return class'SecretServiceCarcass';
    if ( r == i++ ) return class'SecurityBot2';
    if ( r == i++ ) return class'SecurityBot3';
    if ( r == i++ ) return class'SecurityBot4';
    if ( r == i++ ) return class'SecurityCamera';
    if ( r == i++ ) return class'ShellCasing';
    if ( r == i++ ) return class'ShellCasing2';
    if ( r == i++ ) return class'ShellCasingSilent';
    if ( r == i++ ) return class'ShipsWheel';
    if ( r == i++ ) return class'ShopLight';
    if ( r == i++ ) return class'ShowerFaucet';
    if ( r == i++ ) return class'ShowerHead';
    if ( r == i++ ) return class'Shuriken';
    if ( r == i++ ) return class'SignFloor';
    if ( r == i++ ) return class'Smuggler';
    if ( r == i++ ) return class'SmugglerCarcass';
    if ( r == i++ ) return class'snipertracer';
    if ( r == i++ ) return class'Sodacan';
    if ( r == i++ ) return class'Soldier';
    if ( r == i++ ) return class'SoldierCarcass';
    if ( r == i++ ) return class'SoyFood';
    if ( r == i++ ) return class'SpiderBot';
    if ( r == i++ ) return class'SpiderBot2';
    if ( r == i++ ) return class'SpyDrone';
    if ( r == i++ ) return class'StantonDowd';
    if ( r == i++ ) return class'StantonDowdCarcass';
    if ( r == i++ ) return class'StatueLion';
    if ( r == i++ ) return class'SubwayControlPanel';
    if ( r == i++ ) return class'Switch1';
    if ( r == i++ ) return class'Switch2';
    if ( r == i++ ) return class'TAD';
    if ( r == i++ ) return class'TechGoggles';
    if ( r == i++ ) return class'Terrorist';
    if ( r == i++ ) return class'TerroristCarcass';
    if ( r == i++ ) return class'TerroristCommander';
    if ( r == i++ ) return class'TerroristCommanderCarcass';
    if ( r == i++ ) return class'ThugMale';
    if ( r == i++ ) return class'ThugMale2';
    if ( r == i++ ) return class'ThugMale2Carcass';
    if ( r == i++ ) return class'ThugMale3';
    if ( r == i++ ) return class'ThugMale3Carcass';
    if ( r == i++ ) return class'ThugMaleCarcass';
    if ( r == i++ ) return class'TiffanySavage';
    if ( r == i++ ) return class'TiffanySavageCarcass';
    if ( r == i++ ) return class'TobyAtanwe';
    if ( r == i++ ) return class'TobyAtanweCarcass';
    if ( r == i++ ) return class'Toilet';
    if ( r == i++ ) return class'Toilet2';
    if ( r == i++ ) return class'Tracer';
    if ( r == i++ ) return class'TracerTong';
    if ( r == i++ ) return class'TracerTongCarcass';
    if ( r == i++ ) return class'TrafficLight';
    if ( r == i++ ) return class'Trashbag';
    if ( r == i++ ) return class'Trashbag2';
    if ( r == i++ ) return class'TrashCan1';
    if ( r == i++ ) return class'Trashcan2';
    if ( r == i++ ) return class'TrashCan3';
    if ( r == i++ ) return class'TrashCan4';
    if ( r == i++ ) return class'TrashPaper';
    if ( r == i++ ) return class'Tree1';
    if ( r == i++ ) return class'Tree2';
    if ( r == i++ ) return class'Tree3';
    if ( r == i++ ) return class'Tree4';
    if ( r == i++ ) return class'TriadLumPath';
    if ( r == i++ ) return class'TriadLumPath2';
    if ( r == i++ ) return class'TriadLumPath2Carcass';
    if ( r == i++ ) return class'TriadLumPathCarcass';
    if ( r == i++ ) return class'TriadRedArrow';
    if ( r == i++ ) return class'TriadRedArrowCarcass';
    if ( r == i++ ) return class'Trophy';
    if ( r == i++ ) return class'Tumbleweed';
    if ( r == i++ ) return class'UNATCOTroop';
    if ( r == i++ ) return class'UNATCOTroopCarcass';
    if ( r == i++ ) return class'Valve';
    if ( r == i++ ) return class'Van';
    if ( r == i++ ) return class'Vase1';
    if ( r == i++ ) return class'Vase2';
    if ( r == i++ ) return class'VendingMachine';
    if ( r == i++ ) return class'VialAmbrosia';
    if ( r == i++ ) return class'VialCrack';
    if ( r == i++ ) return class'WaltonSimons';
    if ( r == i++ ) return class'WaltonSimonsCarcass';
    if ( r == i++ ) return class'WaterCooler';
    if ( r == i++ ) return class'WaterFountain';
    if ( r == i++ ) return class'WeaponAssaultGun';
    if ( r == i++ ) return class'WeaponAssaultShotgun';
    if ( r == i++ ) return class'WeaponBaton';
    if ( r == i++ ) return class'WeaponCatScratch';
    if ( r == i++ ) return class'WeaponCombatKnife';
    if ( r == i++ ) return class'WeaponCrowbar';
    if ( r == i++ ) return class'WeaponDogBite';
    if ( r == i++ ) return class'WeaponEMPGrenade';
    if ( r == i++ ) return class'WeaponFlamethrower';
    if ( r == i++ ) return class'WeaponGasGrenade';
    if ( r == i++ ) return class'WeaponGEPGun';
    if ( r == i++ ) return class'WeaponGraySpit';
    if ( r == i++ ) return class'WeaponGraySwipe';
    if ( r == i++ ) return class'WeaponGreaselSpit';
    if ( r == i++ ) return class'WeaponHideAGun';
    if ( r == i++ ) return class'WeaponKarkianBite';
    if ( r == i++ ) return class'WeaponKarkianBump';
    if ( r == i++ ) return class'WeaponLAM';
    if ( r == i++ ) return class'WeaponLAW';
    if ( r == i++ ) return class'WeaponMiniCrossbow';
    if ( r == i++ ) return class'WeaponMJ12Commando';
    if ( r == i++ ) return class'WeaponMJ12Rocket';
    if ( r == i++ ) return class'WeaponMod';
    if ( r == i++ ) return class'WeaponModAccuracy';
    if ( r == i++ ) return class'WeaponModClip';
    if ( r == i++ ) return class'WeaponModLaser';
    if ( r == i++ ) return class'WeaponModRange';
    if ( r == i++ ) return class'WeaponModRecoil';
    if ( r == i++ ) return class'WeaponModReload';
    if ( r == i++ ) return class'WeaponModScope';
    if ( r == i++ ) return class'WeaponModSilencer';
    if ( r == i++ ) return class'WeaponNanoSword';
    if ( r == i++ ) return class'WeaponNanoVirusGrenade';
    if ( r == i++ ) return class'WeaponNPCMelee';
    if ( r == i++ ) return class'WeaponNPCRanged';
    if ( r == i++ ) return class'WeaponPepperGun';
    if ( r == i++ ) return class'WeaponPistol';
    if ( r == i++ ) return class'WeaponPlasmaRifle';
    if ( r == i++ ) return class'WeaponProd';
    if ( r == i++ ) return class'WeaponRatBite';
    if ( r == i++ ) return class'WeaponRifle';
    if ( r == i++ ) return class'WeaponRobotMachinegun';
    if ( r == i++ ) return class'WeaponRobotRocket';
    if ( r == i++ ) return class'WeaponSawedOffShotgun';
    if ( r == i++ ) return class'WeaponShuriken';
    if ( r == i++ ) return class'WeaponSpiderBot';
    if ( r == i++ ) return class'WeaponSpiderBot2';
    if ( r == i++ ) return class'WeaponStealthPistol';
    if ( r == i++ ) return class'WeaponSword';
    if ( r == i++ ) return class'WHBenchEast';
    if ( r == i++ ) return class'WHBenchLibrary';
    if ( r == i++ ) return class'WHBookstandLibrary';
    if ( r == i++ ) return class'WHCabinet';
    if ( r == i++ ) return class'WHChairDining';
    if ( r == i++ ) return class'WHChairOvalOffice';
    if ( r == i++ ) return class'WHChairPink';
    if ( r == i++ ) return class'WHDeskLibrarySmall';
    if ( r == i++ ) return class'WHDeskOvalOffice';
    if ( r == i++ ) return class'WHEndtableLibrary';
    if ( r == i++ ) return class'WHFireplaceGrill';
    if ( r == i++ ) return class'WHFireplaceLog';
    if ( r == i++ ) return class'WHPhone';
    if ( r == i++ ) return class'WHPiano';
    if ( r == i++ ) return class'WHRedCandleabra';
    if ( r == i++ ) return class'WHRedCouch';
    if ( r == i++ ) return class'WHRedEagleTable';
    if ( r == i++ ) return class'WHRedLampTable';
    if ( r == i++ ) return class'WHRedOvalTable';
    if ( r == i++ ) return class'WHRedVase';
    if ( r == i++ ) return class'WHTableBlue';
    if ( r == i++ ) return class'WIB';
    if ( r == i++ ) return class'WIBCarcass';
    if ( r == i++ ) return class'WineBottle';
    if ( r == i++ ) return class'WoodFragment';
}
