Class AddBasicNoteTrigger extends Trigger;

var() name               NoteTag;
var() string            NoteText;

      


function Trigger(Actor Other, Pawn Instigator)
{
   local DeusExNote Note;
   local DeusExPlayer aReader;

   Super.Trigger(Other, Instigator);

   aReader = DeusExPlayer(GetPlayerPawn());

   if (aReader != None && Notetag != '')
   {
      // Make sure note doesn't already exist
      note = aReader.GetNote(NoteTag);

      if (note == None)
            {
                note = aReader.AddNote(NoteText,, True);
                note.SetTextTag(NoteTag);
            }

   }
}


function Touch(Actor Other)
{
   local DeusExNote Note;
   local DeusExPlayer aReader;


   Super.Touch(Other);

   if (IsRelevant(Other))
   {
      aReader = DeusExPlayer(GetPlayerPawn());

      if (aReader != None && Notetag != '')
      {
         // Make sure note doesn't already exist
         note = aReader.GetNote(NoteTag);

         if (note == None)
                  {
                      note = aReader.AddNote(NoteText,, True);
                      note.SetTextTag(NoteTag);
                  }

      }

      
   }
}




defaultproperties
{
     bTriggerOnceOnly=True
}