//=============================================================================
// AlistairTorsoTrigger.
//=============================================================================
class AlistairTorsoTrigger expands Trigger;

// Insert the torso into the exosuit to activate it

var() int skillPointsAdded;
var() localized String awardMessage;

function Trigger(Actor Other, Pawn Instigator)
{
	local DeusExPlayer player;
	local AlistairTorso AlistairTorso;

// WRAA
	local AlistairCarlsburn AlistairCarlsburn;
	local AlistairEmpty AlistairEmpty;
// WRAA

	Super.Trigger(Other, Instigator);

	player = DeusExPlayer(Instigator);
	
	if ((player != None) && (player.carrieddecoration.isA('AlistairTorso')))
	{
		player.SkillPointsAdd(skillPointsAdded);
		player.ClientMessage(awardMessage);
		player.flagBase.SetBool('TorsoReunited', True,, 70);

// WRAA

			foreach AllActors(class'AlistairTorso', AlistairTorso)
				AlistairTorso.Destroy();

			foreach AllActors(class'AlistairEmpty', AlistairEmpty)
				AlistairEmpty.Destroy();

			foreach AllActors(class'AlistairCarlsburn', AlistairCarlsburn)
				AlistairCarlsburn.EnterWorld();


// WRAA

	}

}

function Touch(Actor Other)
{
	local DeusExPlayer player;
	local AlistairTorso AlistairTorso;

// WRAA
	local AlistairCarlsburn AlistairCarlsburn;
	local AlistairEmpty AlistairEmpty;
// WRAA

	Super.Touch(Other);

	if (IsRelevant(Other))
	{
		player = DeusExPlayer(Other);

	if ((player != None) && (player.carrieddecoration.isA('AlistairTorso')))
	{
		player.SkillPointsAdd(skillPointsAdded);
		player.ClientMessage(awardMessage);
		player.flagBase.SetBool('TorsoReunited', True,, 70);

// WRAA

			foreach AllActors(class'AlistairTorso', AlistairTorso)
				AlistairTorso.Destroy();

			foreach AllActors(class'AlistairEmpty', AlistairEmpty)
				AlistairEmpty.Destroy();

			foreach AllActors(class'AlistairCarlsburn', AlistairCarlsburn)
				AlistairCarlsburn.EnterWorld();


// WRAA

	}

}
	
}


defaultproperties
{
     skillPointsAdded=500
     awardMessage="Abstaining from Cruelty Bonus"
     bTriggerOnceOnly=True
}
