//=============================================================================
// Sodacan.
//=============================================================================
class BurgerSodacan extends DeusExPickup;

#exec TEXTURE IMPORT NAME=BurgerColaTex0 FILE=Textures\BurgerColaTex0.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=LargeIconBurgerSoda FILE=Textures\LargeIconBurgerSoda.pcx GROUP=Icons
#exec TEXTURE IMPORT NAME=BeltIconBurgerSoda FILE=Textures\BeltIconBurgerSoda.pcx GROUP=Icons

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
			player.HealPlayer(4, False);

		PlaySound(sound'MaleBurp');
		UseOnce();
	}
Begin:
}

defaultproperties
{
     maxCopies=10
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Cola"
     ItemArticle="some"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Sodacan'
     PickupViewMesh=LodMesh'DeusExItems.Sodacan'
     ThirdPersonMesh=LodMesh'DeusExItems.Sodacan'
     LandSound=Sound'DeusExSounds.Generic.MetalHit1'
     Icon=Texture'fgrhk.Icons.BeltIconBurgerSoda'
     largeIcon=Texture'fgrhk.Icons.LargeIconBurgerSoda'
     largeIconWidth=24
     largeIconHeight=45
     Description="Cola is a carbonated beverage that was originally flavored and caffeinated by the kola nut, as well as by vanilla and other ingredients. However, most colas now use nanoscale mechanochemical generators to attain a similar taste."
     beltDescription="COLA"
     MultiSkins(0)=Texture'fgrhk.Skins.BurgerColaTex0'
     Mesh=LodMesh'DeusExItems.Sodacan'
     CollisionRadius=3.000000
     CollisionHeight=4.500000
     Mass=5.000000
     Buoyancy=3.000000
}
