//=============================================
// CANMission64Script.
//=============================================
class CANMission64Script expands MissionScript;

function InitStateMachine() {

    super.InitStateMachine();
    FirstFrame();

}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();

	
	if (localURL == "64_WOODFIBRE_TUNNELS")
	{

		if (!flags.GetBool('M64_Tunnels'))
		{
			Player.StartDataLinkTransmission("DL_M67_TunnelsIntro");
			flags.SetBool('M64_Tunnels', True,, 65);
		}


	}
if (localURL == "64_WOODFIBRE_STAFFORD")
	{
			flags.SetBool('M64LevelEndModule', False,, 65);
	}


}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{

	local AutoTurret turret;
	local SecurityBot2 StaffordBot;
	local SecurityCamera cam;
	local int count;

	if (localURL == "64_WOODFIBRE_TUNNELS")
	{
		if (!flags.GetBool('M64RestartFlag') && !flags.GetBool('M64TurretGone'))
		{
			foreach AllActors(class'SecurityBot2', StaffordBot, 'StaffordBot')
				if (StaffordBot.EMPHitPoints > 0)
					count++;

			foreach AllActors(class'AutoTurret', turret)
					count++;

			foreach AllActors(class'SecurityCamera', cam)
					count++;

			if (count == 8)
				flags.SetBool('TunnelsBotsOK', True,, 66);
		}
	}


	Super.PreTravel();

}

// ----------------------------------------------------------------------

function Timer()
{
	local AnthonyStafford AnthonyStafford;
	local Actor A;
	local AlexiaNovikova AlexiaNovikova;
	local ScriptedPawn P;
	local SecurityCamera cam;
	local AutoTurret turret;
	local Datacube Datacube;
	local FakeSecurityConsole fake;
	local MyComputerSecurity comsec;

   Super.Timer();

   if (localURL == "64_WOODFIBRE_STAFFORD")
   {
		if (!flags.GetBool('M64FolderGag'))
		{
		foreach AllActors(class'Datacube', Datacube)
		{
			if (flags.GetBool('YakedoHatesIngram'))
			{
				if ((Datacube.BindName == "YakeCube"))
				{
				Datacube.bHidden = False;
				flags.SetBool('M64FolderGag', True,, 65);
				}
			}
			if (!flags.GetBool('YakedoHatesIngram'))
			{
				if ((Datacube.BindName == "NorCube"))
				{
				Datacube.bHidden = False;
				flags.SetBool('M64FolderGag', True,, 65);
				}
			}
		}
		}
		if (flags.GetBool('M64MissileLaunched') && !flags.GetBool('M64Alarmus'))
		{
				foreach AllActors(class'Actor', A, 'M64NovikovaMagic')
					A.Trigger(Self, Player);
				foreach AllActors(class'ScriptedPawn', P, 'IlluminatiStaff')
				{
						P.bInvincible = False;
						P.HealthTorso = 0;
						P.Health = 0;
						P.TakeDamage(1, P, P.Location, vect(0,0,0), 'Shot');
				}
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = False;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = True;
			flags.SetBool('M64Alarmus', True,, 65);
		}
		if (flags.GetBool('NovikovaMagic') && !flags.GetBool('EnterNovikova'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
			AlexiaNovikova.EnterWorld();
			flags.SetBool('EnterNovikova', True,, 65);
		}
		if (flags.GetBool('M64BoomStarts') && !flags.GetBool('Vengaboom'))
		{
			Player.PlaySound(Sound'LargeExplosion2', SLOT_None, 2.0,, 16384);
			Player.ShakeView(1.0, 1024.0, 32.0);
			flags.SetBool('Vengaboom', True,, 65);
		}
		if (flags.GetBool('NovikovaAppears_Played') && !flags.GetBool('NovikovaGone'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
			AlexiaNovikova.LeaveWorld();
			flags.SetBool('NovikovaGone', True,, 65);
		}
		if (flags.GetBool('M64StaffordSplodes') && flags.GetBool('StaffordDies_Played') && !flags.GetBool('StaffordGone'))
		{
			foreach AllActors(class'AnthonyStafford', AnthonyStafford)
			{
				AnthonyStafford.bInvincible = False;
				AnthonyStafford.HealthTorso = 0;
				AnthonyStafford.Health = 0;
				AnthonyStafford.GotoState('KillswitchActivated');
			}
			flags.SetBool('StaffordGone', True,, 65);
		}


	}
   if (localURL == "64_WOODFIBRE_TUNNELS")
   {
		if (flags.GetBool('M64LevelEndModule') && flags.GetBool('M64DecryptionGoal') && !flags.GetBool('M64RiggidySplit'))
		{
				foreach AllActors(class'Actor', A, 'M64EndLevelDispatcher')
					A.Trigger(Self, Player);
			flags.SetBool('M64RiggidySplit', True,, 65);
		}
		if (flags.GetBool('M64LevelEndModule') && !flags.GetBool('M64DecryptionGoal') && !flags.GetBool('M64RiggidySplit2'))
		{
				foreach AllActors(class'Actor', A, 'ConvoThingamaDig')
					A.Trigger(Self, Player);
			flags.SetBool('M64RiggidySplit2', True,, 65);
		}
		if (flags.GetBool('M64RestartFlag') && !flags.GetBool('M64RestartDelic'))
		{
			foreach AllActors(class'MyComputerSecurity', comsec, 'NewSecurity')
					comsec.bHidden=False;

			foreach AllActors(class'FakeSecurityConsole', fake)
					fake.destroy();

				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
			flags.SetBool('M64TurretGone', True,, 65);
			flags.SetBool('M64RestartDelic', True,, 65);
		}
		if (flags.GetBool('M64TurretGone') && !flags.GetBool('TurretVerschwinden'))
		{
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
			flags.SetBool('TurretVerschwinden', True,, 65);
		}

   }
}

defaultproperties
{
}
