//=============================================================================
// MadIngramPlayer.
//=============================================================================
class MadIngramPlayer extends JCDentonMale;

// ----------------------------------------------------------------------
// UpdatePlayerSkin()
// ----------------------------------------------------------------------

function UpdatePlayerSkin()
{
	local PaulDenton wesley;
	local PaulDentonCarcass wesleyCarcass;
	local MadIngramMaleCarcass madCarcass;
	local MIDouble mad;

	// Wesley Cutter
	foreach AllActors(class'PaulDenton', wesley)
		break;

	if (wesley != None)
		wesley.SetSkin(Self);

	// Wesley Cutter Carcass
	foreach AllActors(class'PaulDentonCarcass', wesleyCarcass)
		break;

	if (wesleyCarcass != None)
		wesleyCarcass.SetSkin(Self);

	// Mad Ingram Carcass
	foreach AllActors(class'MadIngramMaleCarcass', madCarcass)
		break;

	if (madCarcass != None)
		madCarcass.SetSkin(Self);

	// Ingram's stunt double
	foreach AllActors(class'MIDouble', mad)
		break;

	if (mad != None)
		mad.SetSkin(Self);

	// Ingram's stunt double
	foreach AllActors(class'MIDouble', mad, 'SecondIngram')
		break;

	if (mad != None)
		mad.SetSkin(Self);

	// Ingram's stunt double
	foreach AllActors(class'MIDouble', mad, 'ThirdIngram')
		break;

	if (mad != None)
		mad.SetSkin(Self);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------


function Possess() 
{ 

    local DeusExRootWindow root; 

    Super.Possess(); 

    root = DeusExRootWindow(rootWindow); 
      
    root.hud.Destroy(); 
    root.hud = DeusexHUD(root.NewChild(Class'myGameHUD')); 

    root.hud.UpdateSettings(Self); 
    root.hud.SetWindowAlignments(HALIGN_Full,VALIGN_Full, 0, 0); 

}

// ----------------------------------------------------------------------
// StartDataLinkTransmission()
//
// Locates and starts the DataLink passed in
// ----------------------------------------------------------------------

function Bool StartDataLinkTransmission(
	String datalinkName, 
	Optional DataLinkTrigger datalinkTrigger)
{
	local Conversation activeDataLink;
	local bool bDataLinkPlaySpawned;

	// Don't allow DataLinks to start if we're in PlayersOnly mode
	if ( Level.bPlayersOnly )
		return False;

	activeDataLink = GetActiveDataLink(datalinkName);

	if ( activeDataLink != None )
	{
		// Search to see if there's an active DataLinkPlay object 
		// before creating one

		if ( dataLinkPlay == None )
		{
			datalinkPlay = Spawn(class'myDataLinkPlay');
			bDataLinkPlaySpawned = True;
		}

		// Call SetConversation(), which returns 
		if (datalinkPlay.SetConversation(activeDataLink))
		{
			datalinkPlay.SetTrigger(datalinkTrigger);

			if (datalinkPlay.StartConversation(Self))
			{
				return True;
			}
			else
			{
				// Datalink must already be playing, or in queue
				if (bDataLinkPlaySpawned)
				{
					datalinkPlay.Destroy();
					datalinkPlay = None;
				}
				
				return False;
			}
		}
		else
		{
			// Datalink must already be playing, or in queue
			if (bDataLinkPlaySpawned)
			{
				datalinkPlay.Destroy();
				datalinkPlay = None;
			}
			return False;
		}
	}
	else
	{
		return False;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------


function InitializeSubSystems()
{
if (BarkManager == None)
	BarkManager = Spawn(class'BarkManager', Self);

CreateColorThemeManager();
ThemeManager.SetOwner(self);

if (AugmentationSystem == None)
	{
	AugmentationSystem = Spawn(class'AugmentationManager', Self);
	AugmentationSystem.CreateAugmentations(Self);
	AugmentationSystem.AddDefaultAugmentations();
        AugmentationSystem.SetOwner(Self);
	}
else
	{
	AugmentationSystem.SetPlayer(Self);
        AugmentationSystem.SetOwner(Self);
	}

if (SkillSystem == None)
	{
	SkillSystem = Spawn(class'SkillManager', Self);
	SkillSystem.CreateSkills(Self);
	}
else
	SkillSystem.SetPlayer(Self);

CreateKeyRing();
}

// ----------------------------------------------------------------------
// ShowMainMenu thingies()
// ----------------------------------------------------------------------


exec function ShowMainMenu()
{
local DeusExRootWindow root;
local DeusExLevelInfo info;
local MissionEndgame Script;

if (bIgnoreNextShowMenu)
	{
	bIgnoreNextShowMenu = False;
	return;
	}

info = GetLevelInfo();

ConsoleCommand("FLUSH");

if ((info != None) && (info.MissionNumber == 68)) 
	{
	bIgnoreNextShowMenu = True;
	PostIntro();
	}
	else if ((info != None) && (info.MissionNumber == 68))
	{
	foreach AllActors(class'MissionEndgame', Script)
		break;

	if (Script != None)
		Script.FinishCinematic();
	}
else
	{
	root = DeusExRootWindow(rootWindow);
	if (root != None)
		root.InvokeMenu(Class'fgrhk.MyMainMenu');
	}
}

// ----------------------------------------------------------------------
// PostIntro()
// ----------------------------------------------------------------------

function PostIntro()
{
	if (bStartNewGameAfterIntro)
	{
		bStartNewGameAfterIntro = False;
		StartNewGame(strStartMap);
	}
	else
	{
		Level.Game.SendPlayer(Self, "dxonly");
	}
}

// ----------------------------------------------------------------------
// ShowIntro()
// ----------------------------------------------------------------------

function ShowIntro(optional bool bStartNewGame)
{
	if (DeusExRootWindow(rootWindow) != None)
		DeusExRootWindow(rootWindow).ClearWindowStack();

	bStartNewGameAfterIntro = bStartNewGame;

	// Make sure all augmentations are OFF before going into the intro
	AugmentationSystem.DeactivateAll();

	// Reset the player
	Level.Game.SendPlayer(Self, "59_Intro");
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

// ----------------------------------------------------------------------
// ShowCredits()
// This is stuff for setting up custom end credits
// ----------------------------------------------------------------------

function ShowCredits(optional bool bLoadIntro)
{
	local DeusExRootWindow root;
	local MyCreditsWindow winCredits;

	root = DeusExRootWindow(rootWindow);

	if (root != None)
	{
		// Show the credits screen and force the game not to pause
		// if we're showing the credits after the endgame
		winCredits = MyCreditsWindow(root.InvokeMenuScreen(Class'MyCreditsWindow', bLoadIntro));
		winCredits.SetLoadIntro(bLoadIntro);
	}
}

// ------------------------------------------------------------------------
// GiveInitialInventory()
// ------------------------------------------------------------------------

function GiveInitialInventory()
{
   local Inventory anItem;

   // Give the player a pistol.

   // spawn it.
   if ((!Level.Game.IsA('DeusExMPGame')) || (DeusExMPGame(Level.Game).bStartWithPistol))
   {
      
      anItem = Spawn(class'Ammo10mm');
      DeusExAmmo(anItem).AmmoAmount=10;
      anItem.Frob(Self,None);
      anItem.Destroy();
   }
}
// ----------------------------------------------------------------------
// ResetPlayer()
//
// Called when a new game is started. 
//
// 1) Erase all flags except those beginning with "SKTemp_"
// 2) Dumps inventory
// 3) Restore any other defaults
// ----------------------------------------------------------------------

function ResetPlayer(optional bool bTraining)
{
	local inventory anItem;
	local inventory nextItem;

	ResetPlayerToDefaults();

	// Reset Augmentations
	if (AugmentationSystem != None)
	{
		AugmentationSystem.ResetAugmentations();
		AugmentationSystem.Destroy();
		AugmentationSystem = None;
	}

	// Give the player a pistol and a prod
	if (!bTraining)
	{
		anItem = Spawn(class'Ammo10mm');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
	}
}

// ----------------------------------------------------------------------
// TravelPostAccept()
// ----------------------------------------------------------------------

event TravelPostAccept()
{
	local DeusExLevelInfo info;

	Super.TravelPostAccept();

	switch(PlayerSkin)
	{
		case 0:	MultiSkins[1] = Texture'MadIngramTex2'; 
				MultiSkins[0] = Texture'WesleyCutterTex0';
				MultiSkins[3] = Texture'MadIngramTex1';
				MultiSkins[5] = Texture'MadIngramTex2';
				break;
		case 1:	MultiSkins[1] = Texture'MadIngramTex2'; 
				MultiSkins[0] = Texture'WesleyCutterTex01';
				MultiSkins[2] = Texture'MadIngramTex3';
				MultiSkins[3] = Texture'MadIngramTex12';
				MultiSkins[4] = Texture'MadIngramTex12';
				MultiSkins[5] = Texture'MadIngramTex2';
				break;
		case 2:	MultiSkins[1] = Texture'MadIngramTex14'; 
				MultiSkins[0] = Texture'WesleyCutterTex01';
				MultiSkins[2] = Texture'MadIngramTex32';
				MultiSkins[3] = Texture'MadIngramTex15';
				MultiSkins[4] = Texture'MadIngramTex15';
				MultiSkins[5] = Texture'MadIngramTex14';
 				MultiSkins[6] = Texture'FramesTex1';
 				MultiSkins[7] = Texture'LensesTex1';
				break;
		case 3:	MultiSkins[1] = Texture'JockTex2'; 
				MultiSkins[0] = Texture'WesleyCutterTex02';
				MultiSkins[2] = Texture'SoldierTex2';
				MultiSkins[3] = Texture'MadIngramTex13';
				MultiSkins[4] = Texture'MadIngramTex13';
				MultiSkins[5] = Texture'PinkMaskTex';
				break;
		case 4:	MultiSkins[1] = Texture'MadIngramTex10'; 
				MultiSkins[0] = Texture'WesleyCutterTex0';
				MultiSkins[3] = Texture'WesleyCutterTex0';
				MultiSkins[4] = Texture'MadIngramTex11';
				MultiSkins[5] = Texture'MadIngramTex10';
 				MultiSkins[6] = Texture'FramesTex3';
 				MultiSkins[7] = Texture'LensesTex7';
				break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     TruePlayerName="Mad Ingram"
     strStartMap="60_HongKong_MPSHelipad"
     bStartNewGameAfterIntro=True
     SkillPointsTotal=6000
     SkillPointsAvail=6000
     CarcassType=Class'fgrhk.MadIngramMaleCarcass'
     MultiSkins(0)=Texture'fgrhk.Skins.WesleyCutterTex0'
     MultiSkins(1)=Texture'fgrhk.Skins.MadIngramTex2'
     MultiSkins(2)=Texture'fgrhk.Skins.MadIngramTex3'
     MultiSkins(3)=Texture'fgrhk.Skins.MadIngramTex1'
     MultiSkins(4)=Texture'fgrhk.Skins.MadIngramTex1'
     MultiSkins(5)=Texture'fgrhk.Skins.MadIngramTex2'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex4'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex2'
     BindName="MadIngram"
     FamiliarName="Mad Ingram"
     UnfamiliarName="Mad Ingram"
}
