//=============================================
// NYCMission63Script.
//=============================================
class NYCMission63Script expands MissionScript;

function InitStateMachine() {

    super.InitStateMachine();
    FirstFrame();

}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{

	local Actor A;

	Super.FirstFrame();

	if (localURL == "63_NYC_QUEENSSTREETS")
	{

		if (!flags.GetBool('M63_Introlnik'))
		{
			Player.StartDataLinkTransmission("DL_M63_ZavichIntro");
			Player.GoalCompleted('M62JoinedXVA');
			Player.GoalCompleted('M62JoinedMJ12');
			Player.GoalCompleted('M62ApprehendYoon');
			Player.GoalCompleted('M62SpiderAL');
			flags.SetBool('M63_Introlnik', True,, 64);
		}


	}

	if (localURL == "63_NYC_CUTTERRESIDENCE")
	{

		if (!flags.GetBool('M63_Housequest'))
		{
				foreach AllActors(class'Actor', A, 'M63PortraitMagicBanner')
					A.Trigger(Self, Player);
			Player.GoalCompleted('M63GetToSubway');
			Player.StartDataLinkTransmission("DL_M63_CutterOverview");
			flags.SetBool('M63_Housequest', True,, 64);
		}


	}


}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{

	local ScriptedPawn P;
	local DeusExMover M;
	local ThugMale2 thug;
	local RiotCop RiotCop;
	local Actor A;
	local DeusExDecoration D;
	local BlackHelicopter lanacopter;
	local int count;
	local Robot bot;
	local SpawnPoint SP;
	local AlistairCarlsburn AlistairCarlsburn;
	local MacFarlane MacFarlane;
	local EliasNadel EliasNadel;
	local AlistairTorso AlistairTorso;
	local MacFarlaneCarcass carc;
	local Folder Folder;
	local Inventory item, nextItem;

	Super.Timer();

	if (localURL == "63_NYC_QUEENSSTREETS")
	{

		if (flags.GetBool('NadelCell_Played') && !flags.GetBool('sntriggered'))
		{
				foreach AllActors(class'Actor', A, 'ZymeSnigger')
					A.Trigger(Self, Player);
			flags.SetBool('sntriggered', True,, 64);
		}

		if (flags.GetBool('M63MacFarlaneAppears') && !flags.GetBool('ClubRacket'))
		{
			foreach AllActors(class'ScriptedPawn', P, 'ZymeSnipers')
			{
							P.HealthTorso = 0;
							P.Health = 0;
							P.TakeDamage(1, P, P.Location, vect(0,0,0), 'Shot');
			}
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "ZymeTender")
					{
						SP = GetSpawnPoint('BarSpawn');
						if (SP != None)
						{
							P.SetLocation(SP.Location);
							P.SetRotation(SP.Rotation);
							P.SetOrders('Standing',, True);
							P.SetHomeBase(SP.Location, SP.Rotation);

						}
							P.HealthTorso = 0;
							P.Health = 0;
							P.bStunned = True;
							P.TakeDamage(1, P, P.Location, vect(0,0,0), 'KnockedOut');
					}
			}
			flags.SetBool('ClubRacket', True,, 64);
		}

		if (flags.GetBool('M63BarEntryCheck') && !flags.GetBool('M63ZymeLetIngramIn') && !flags.GetBool('RiggidyBraxicona4'))
		{
			foreach AllActors(class'Actor', A, 'ZymeSnigger')
				A.Trigger(Self, Player);
			flags.SetBool('RiggidyBraxicona4', True,, 62);
		}

		if (!flags.GetBool('M63BarAllDead'))
		{
			count = 0;

			foreach AllActors(class'ScriptedPawn', P, 'ZymeSnipers')
				count++;
			if (count == 0)
			flags.SetBool('M63BarAllDead', True,, 64);

		}
		if (flags.GetBool('AlistairRushStarted') && !flags.GetBool('YeahYeahBoat'))
		{
			foreach AllActors(class'ScriptedPawn', P, 'DoorMan')
				P.LeaveWorld();
			flags.SetBool('YeahYeahBoat', True,, 64);
		}

		if (flags.GetBool('M63DelaByeBye') && !flags.GetBool('YeahYeahBoat3'))
		{
			foreach AllActors(class'ScriptedPawn', P, 'Delacroix')
				P.LeaveWorld();
			flags.SetBool('YeahYeahBoat3', True,, 64);
		}

		if(flags.getbool('AlistairKeyOK') && flags.getbool('AlistairHelpOK') && !flags.GetBool('Alis1Hand'))
		{
			flags.setbool('DoneWithAlistair',true);
			flags.setbool('Alis1Hand',true);
		}
		if (!flags.GetBool('AlistairRushReady'))
		{
			count = 0;
			foreach AllActors(class'Robot', bot, 'NYBots')
				if (bot.EMPHitPoints > 0)
					count++;

			if (count == 4)
			flags.SetBool('M63FourBots', True,, 64);
			else if (count == 3)
			flags.SetBool('M63ThreeBots', True,, 64);
			else if (count == 2)
			flags.SetBool('M63TwoBots', True,, 64);
			else if (count == 1)
			flags.SetBool('M63OneBot', True,, 64);
			else if (count == 0)
			{
				Player.GoalCompleted('AlistairBots');
				flags.SetBool('AlistairRushReady', True,, 64);
			}
		}
		if(flags.getbool('AlistairRushReady') && !flags.getbool('AlistairHasMoved'))
		{
				foreach AllActors(class'Actor', A, 'AlistairSpotMover')
					A.Trigger(Self, Player);
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "AlistairCarlsburn")
					{
						SP = GetSpawnPoint('Aliceport');
						if (SP != None)
						{
							P.SetLocation(SP.Location);
							P.SetRotation(SP.Rotation);
							P.SetOrders('Standing',, True);
							P.SetHomeBase(SP.Location, SP.Rotation);
							flags.setbool('AlistairHasMoved',true);
						}
					}
			}
		}
		if(flags.GetBool('AlistairTheMagicTorso') && flags.GetBool('AlistairRestored_Played') && !flags.getbool('AlistairReteleport'))
		{
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "AlistairCarlsburn")
					{
						SP = GetSpawnPoint('Aliceport');
						if (SP != None)
						{
							P.SetLocation(SP.Location);
							P.SetRotation(SP.Rotation);
							P.SetOrders('Standing',, True);
							P.SetHomeBase(SP.Location, SP.Rotation);
							flags.setbool('AlistairReteleport',true,, 64);
						}
					}
			}
		}
		if(flags.getbool('AlistairRestored_Played') && !flags.GetBool('AlistairWalks'))
		{
				foreach AllActors(class'Actor', A, 'AlistairSpotWonder')
					A.Trigger(Self, Player);
				flags.SetBool('AlistairWalks', True,, 64);
		}
		if(flags.getbool('AlistairGEPGuns') && !flags.GetBool('MagicSplode'))
		{
				foreach AllActors(class'Actor', A, 'ExplosionTrigger')
					A.Trigger(Self, Player);
				flags.SetBool('MagicSplode', True,, 64);
		}
		if(flags.GetBool('AlistairEstateEntry') && !flags.GetBool('MacDone'))
		{
			foreach AllActors(class'AlistairCarlsburn', AlistairCarlsburn, 'AlistairCarlsburn')
			AlistairCarlsburn.leaveWorld();
				flags.SetBool('MacDone', True,, 64);
		}
		if (!flags.GetBool('RiotCopMurderTier1'))
		{
			count = 0;
			foreach AllActors(class'RiotCop', RiotCop)
				count++;

			if (count <= 24)
				flags.SetBool('RiotCopMurderTier1', True);
		}
		if (!flags.GetBool('RiotCopMurderTier2'))
		{
			count = 0;
			foreach AllActors(class'RiotCop', RiotCop)
				count++;

			if (count <= 18)
				flags.SetBool('RiotCopMurderTier2', True);
		}
		if(flags.getbool('RiotCopMurderTier1') && !flags.GetBool('ApMurderTier1'))
		{
				foreach AllActors(class'Actor', A, 'M63Reinforcements1')
					A.Trigger(Self, Player);
				flags.SetBool('ApMurderTier1', True,, 64);
		}
		if(flags.getbool('RiotCopMurderTier2') && !flags.GetBool('ApMurderTier2'))
		{
				foreach AllActors(class'Actor', A, 'M63Reinforcements2')
					A.Trigger(Self, Player);
				flags.SetBool('ApMurderTier2', True,, 64);
		}
		if(flags.getbool('RiotCopArmoryFail') && !flags.GetBool('ApMurderTier1AC'))
		{
				foreach AllActors(class'Actor', A, 'PoliceBrutality')
					A.Trigger(Self, Player);
				flags.SetBool('ApMurderTier1AC', True,, 64);
		}

		if(flags.GetBool('DL_M63_CutterOverView_Played') && !flags.GetBool('club1handle'))
		{
			foreach AllActors(class'ScriptedPawn', P, 'DoorMan')
				P.LeaveWorld();
				flags.SetBool('club1handle', True,, 64);
		}

		if(flags.getbool('DL_M63_CutterOverview_Played') && !flags.GetBool('AlistairRestored_Played') && !flags.GetBool('TorsoHell11'))
		{
				foreach AllActors(class'Actor', A, 'AlistairTorso')
					A.Destroy();
				flags.SetBool('TorsoHell11', True,, 64);
		}
		if(flags.getbool('DL_M63_CutterOverview_Played') && !flags.GetBool('AlistairHelpOK') && !flags.GetBool('TorsoHell21'))
		{
				foreach AllActors(class'Actor', A, 'AlistairTorso')
					A.Destroy();
				foreach AllActors(class'AlistairCarlsburn', AlistairCarlsburn, 'AlistairCarlsburn')
					AlistairCarlsburn.Destroy();
				flags.SetBool('TorsoHell21', True,, 64);
		}
		if (!flags.GetBool('M63FolderGag'))
		{
		foreach AllActors(class'Folder', Folder)
		{
			if (flags.GetBool('NEU_JoinedXVA'))
			{
				if ((Folder.BindName == "MacXVA"))
				{
				Folder.bHidden = False;
				flags.SetBool('M63FolderGag', True,, 63);
				}
			}
			if (!flags.GetBool('NEU_JoinedXVA'))
			{
				if ((Folder.BindName == "MacNormal"))
				{
				Folder.bHidden = False;
				flags.SetBool('M63FolderGag', True,, 63);
				}
			}
		}
		}

	}
	if (localURL == "63_NYC_CUTTERRESIDENCE")
	{
		if (flags.GetBool('CubeCheckMil1') && flags.GetBool('CubeCheckMil2') && !flags.GetBool('M63DatacubeDone'))
		{
			flags.SetBool('IngramKnowsTheTruth', True,, 0);
			flags.SetBool('M63DatacubeDone', True,, 64);
		}
		if (!flags.GetBool('MostGangMembersDead'))
		{
			count = 0;
			foreach AllActors(class'ThugMale2', thug)
				count++;

			// if two or less are still alive
			if (count <= 2)
				flags.SetBool('MostGangMembersDead', True);
		}
		if (flags.GetBool('MostGangMembersDead') && flags.GetBool('BeforeBasement'))
		{
				foreach AllActors(class'Actor', A, 'GuardRespect')
					A.Trigger(Self, Player);
		}
		if (flags.GetBool('MeetNadel_played') && !flags.GetBool('M63_NadelDone'))
		{
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "ThatGuyFromBronx")
					{
							P.HealthTorso = 0;
							P.Health = 0;
							P.bStunned = True;
							P.TakeDamage(1, P, P.Location, vect(0,0,0), 'KnockedOut');
					}
			}
			foreach AllActors(class'BlackHelicopter', lanacopter, 'BlackHelicopter')
			lanacopter.EnterWorld();
			flags.SetBool('M63MacFarlaneAppears', True,, 64);
			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'DoorOfFork'))
				{
					// close and lock the door
					if (M.KeyNum != 0)
						M.Trigger(None, None);
					M.bBreakable = False;
					M.bPickable = False;
					M.bFrobbable = False;
					M.bHighlight = False;
					M.bLocked = True;
				}
			}
			Player.StartDataLinkTransmission("DL_M63_MeetStafford");
				if (flags.GetBool('AlistairRushComplete'))
				{
				flags.SetBool('AlistairEstateEntry', True,, 64);
				}
			flags.SetBool('M63_NadelDone', True,, 64);
		}

		if (flags.GetBool('M63MacFarlaneAppears') && !flags.GetBool('MacFarlaneIsHere'))
		{
			foreach AllActors(class'MacFarlane', MacFarlane, 'MacFarlane')
			MacFarlane.EnterWorld();
			foreach AllActors(class'ThugMale2', thug)
			{
						thug.HealthTorso = 0;
						thug.Health = 0;
						thug.TakeDamage(1, thug, thug.Location, vect(0,0,0), 'Shot');
						if (thug.Inventory != None)
						{
							do
							{
								item = thug.Inventory;
								nextItem = item.Inventory;
								thug.DeleteInventory(item);
								item.Destroy();
								item = nextItem;
							}
							until (item == None);
						}
			}
			flags.SetBool('MacFarlaneIsHere', True,, 64);
		}

		if (flags.GetBool('AlistairEstateEntry') && !flags.GetBool('Alistaired'))
		{
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "AlistairCarlsburn")
					{
						SP = GetSpawnPoint('Antonypoint');
						if (SP != None)
						{
							P.SetLocation(SP.Location);
							P.SetRotation(SP.Rotation);
							P.SetOrders('Standing',, True);
							P.SetHomeBase(SP.Location, SP.Rotation);
							flags.SetBool('Alistaired', True,, 64);
						}
					}
			}
		}
		if (flags.GetBool('MeetMacFarlane_Played') && !flags.GetBool('Macfarlaned'))
		{
			foreach AllActors(class'MacFarlane', MacFarlane, 'MacFarlane')
				MacFarlane.bInvincible = False;
			flags.SetBool('Macfarlaned', True,, 64);
		}
		if (flags.GetBool('MacFarlane_Dead') && !flags.GetBool('MacPatrolled'))
		{
				foreach AllActors(class'Actor', A, 'AlistairChills')
					A.Trigger(Self, Player);
			flags.SetBool('MacPatrolled', True,, 64);
		}
		if (!flags.GetBool('PlayerKilledMacFarlane') && flags.GetBool('MacFarlane_Dead'))
		{
			foreach AllActors(class'MacFarlaneCarcass', carc)
			{
			if ((carc.KillerBindName == "MadIngram") || (carc.KillerBindName == ""))
				{
					flags.SetBool('PlayerKilledMacFarlane', True,, 64);
				}
				else if (carc.KillerBindName == "AlistairCarlsburn")
					flags.SetBool('AlistairKilledMacFarlane', True,, 64);
				else
					return;

			}
		}
	}
}
		

defaultproperties
{
}
