//=============================================================================
// RocketEMP.
//=============================================================================
class RocketEMP extends Rocket;

var float	mpBlastRadius;
var float	mpEMPDamage;

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local SphereEffect sphere;
   	local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
	if (light != None)
	{
         light.RemoteRole = ROLE_None;
	 light.size = 8;
	 light.LightHue = 128;
	 light.LightSaturation = 96;
	 light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(class'ExplosionSmall',,, HitLocation);
      	if (expeffect != None)
      	    expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	sphere = Spawn(class'SphereEffect',,, HitLocation);
	if (sphere != None)
            sphere.RemoteRole = ROLE_None;
	    sphere.size = blastRadius / 32.0;
}
simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ( Level.NetMode != NM_Standalone ) && (Class == Class'RocketEMP') )
	{
      speed = 2000.0000;
      SetTimer(5,false);
      Damage = mpEMPDamage;
      blastRadius = mpBlastRadius;
      bIgnoresNanoDefense=True;
      SoundRadius=76;
	}
}

defaultproperties
{
     mpEMPDamage=250.000000
     mpBlastRadius=512.000000
     bBlood=False
     bDebris=False
     blastRadius=512.000000
     DamageType=EMP
     ItemName="Electromagnetic Pulse (EMP) Rocket"
     ImpactSound=Sound'DeusExSounds.Weapons.EMPGrenadeExplode'
     Mesh=LodMesh'fgrhk.RocketEMP'
     DrawScale=1.000000
     AmbientSound=Sound'DeusExSounds.Weapons.WPApproach'
}