//=============================================================================
// WeaponM249SAW. 
//=============================================================================
class WeaponM249DXN extends WeaponM249SAW;

var float	mpRecoilStrength;

simulated state ClientFiring
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}
		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;
				if (DeusExPlayer(Owner).bAutoReload)
				{
					bClientReadyToFire = False;
					bInProcess = False;
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
					GotoState('SimQuickFinish');
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					IdleFunction();
					GotoState('SimQuickFinish');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			IdleFunction();
			GotoState('SimQuickFinish');
		}
	}
	Sleep(GetSimShotTime());
	if (bAutomatic)
	{
		SimGenerateBullet();
		Goto('Begin');
	}
	bFiring = False;
	if(Pawn(Owner)!=None)
    {
       if(Pawn(Owner).bFire==0)
       {
          FinishAnim();
       }
    }
	bInProcess = False;
Done:
	bInProcess = False;
	bFiring = False;
	SimFinish();
}



simulated function PlaySelectiveFiring()
{
   local Pawn aPawn;
   local float rnd;
   local Name anim;

   anim = 'Shoot';

   if (DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn()))
   {
      PlayAnim('Shoot',,0.00);
   }
}

state NormalFire
{
   function float GetShotTime()
   {
      local float mult, sTime;

      if (ScriptedPawn(Owner) != None)
         return ShotTime * (ScriptedPawn(Owner).BaseAccuracy*2+1);
      else
      {
         // AugCombat decreases shot time
         mult = 1.0;
         if (bHandToHand && DeusExPlayer(Owner) != None)
         {
            mult = 1.0 / DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'AugCombat');
            if (mult == -1.0)
               mult = 1.0;
         }
         sTime = ShotTime * mult;
         return (sTime);
      }
   }

Begin:
   if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
   {
      if (Owner != None)
      {
         if (Owner.IsA('DeusExPlayer'))
         {
            bFiring = False;

            // should we autoreload?
            if (DeusExPlayer(Owner).bAutoReload)
            {
               // auto switch ammo if we're out of ammo and
               // we're not using the primary ammo
               FinishAnim();
               if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
                  CycleAmmo();
               ReloadAmmo();
            }
            else
            {
               if (bHasMuzzleFlash)
                  EraseMuzzleFlashTexture();
               GotoState('Idle');
            }
         }
         else if (Owner.IsA('ScriptedPawn'))
         {
            bFiring = False;
            ReloadAmmo();
         }
      }
      else
      {
         if (bHasMuzzleFlash)
            EraseMuzzleFlashTexture();
         GotoState('Idle');
      }
   }

   Sleep(GetShotTime());
   bFiring = False;
   if(Pawn(Owner)!=None)
   {
      if(Pawn(Owner).bFire==0)
      {
         FinishAnim();
      }
   }
   ReadyToFire();
Done:
   bFiring = False;
   Finish();
} 

simulated function M249Open()
{
      Owner.PlaySound(Sound'EnhancedM249.M249CoverUp', SLOT_None,,, 1024); 
}

simulated function M249BoxOut()
{
      Owner.PlaySound(Sound'EnhancedM249.M249BoxOut', SLOT_None,,, 1024); 
}

simulated function M249Chain()
{
      Owner.PlaySound(Sound'EnhancedM249.M249Chain', SLOT_None,,, 1024); 
}

simulated function M249BoxIn()
{
      Owner.PlaySound(Sound'EnhancedM249.M249BoxIn', SLOT_None,,, 1024); 
}

simulated function M249Close()
{
      Owner.PlaySound(Sound'EnhancedM249.M249CoverDown', SLOT_None,,, 1024); 
}

simulated function M249Bolt()
{
      Owner.PlaySound(Sound'EnhancedM249.M249BoltPull', SLOT_None,,, 1024); 
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;

		// Tuned for advanced -> master skill system (Monte & Ricardo's number) client-side
		recoilStrength = 0.75;
	}
}

defaultproperties
{
	LowAmmoWaterMark=100
	GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
	EnviroEffective=1
	Concealability=1
	ShotTime=0.10
	reloadTime=4.50
	HitDamage=15
	BaseAccuracy=0.30
	bCanHaveScope=true
	bCanHaveLaser=true
	recoilStrength=0.90
	MinWeaponAcc=0.20
	mpReloadTime=0.50
	mpHitDamage=12
	mpBaseAccuracy=0.85
	mpAccurateRange=2400
	mpMaxRange=2400
	mpReloadCount=100
	bCanHaveModBaseAccuracy=true
	bCanHaveModRecoilStrength=true
	AmmoName=class'fgrhk.Ammo556DXN'
	ReloadCount=100
	PickupAmmoCount=100
	bInstantHit=true
	FireOffset=(X=-16.00,Y=5.00,Z=11.50)
	shakemag=450.00
	FireSound=Sound'EnhancedM249.Weapons.M249Fire'
	SelectSound=Sound'EnhancedM249.Weapons.M249Chain'
	InventoryGroup=249
	ItemName="Light Machine Gun 2049"
	PlayerViewOffset=(X=16.00,Y=-5.00,Z=-11.50)
	PlayerViewMesh=LodMesh'm2491st'
	PickupViewMesh=LodMesh'm249pickup'
	ThirdPersonMesh=LodMesh'm2493rd'
	LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
	Icon=Texture'fgrhk.Icons.BeltIconM249'
	largeIcon=Texture'fgrhk.Icons.LargeM249Icon'
	largeIconWidth=203
	largeIconHeight=77
	invSlotsX=4
	invSlotsY=2
	Description="The Light Machine Gun 2049 chambers 5.56x45mm XVA rounds, but due to the innovative heatshield and barrel design, the weapon can dispatch a large amount of ammunition in a very short amount of time with little to no decrease in accuracy. However, due to the bulky design and the substantial amount of ammunition in a single box-type magazine, an inexperienced agent would have a difficult time trying to use the weapon for any other purposes besides supporting fire."
	beltDescription="LMG2049"
	Mesh=LodMesh'm249pickup'
	CollisionRadius=15.00
	CollisionHeight=1.10
	Mass=40.00
}