class AIEventTrigger extends Trigger;

/*
possible events are:
Futz,
MegaFutz,
WeaponDrawn,
WeaponFire,
Carcass,
LoudNoise,
Distress,
Projectile,
Alarm,
god knows what else
*/

var() name AIEvent; 

function PostBeginPlay()
{
	Super.PostBeginPlay();
	AISetEventCallback(AIEvent, 'EventOccured');
}

singular function Touch(Actor Other)
{
	// does nothing when touched
}

function Trigger(Actor Other, Pawn Instigator)
{
	// does nothing when triggered
}

function EventOccured()
{
	local actor a;
	if (Event != '')
	{
		foreach allactors(class'actor', a, Event)
			a.Trigger(self, none);
	}

	if (bTriggerOnceOnly)
		AIClearEventCallback(AIEvent);
}

defaultproperties
{
}
