class AllianceToggleTrigger expands Trigger;

struct InitialAllianceInfo  {
	var() Name  AllianceName;
	var() float AllianceLevel;
	var() bool  bPermanent;
};

var(AllianceEnabled) name Alliance_Enabled;
var(AllianceEnabled) InitialAllianceInfo Alliances_Enabled[8];
var(AllianceDisabled) name Alliance_Disabled;
var(AllianceDisabled) InitialAllianceInfo Alliances_Disabled[8];

//
// Set an NPCs alliances
//

function Trigger(Actor Other, Pawn Instigator)
{
	if (SetAlliancesOn())
	{
		Super.Trigger(Other, Instigator);
		if (bTriggerOnceOnly)
			Destroy();
	}
}

function UnTrigger(Actor Other, Pawn Instigator)
{
	if (SetAlliancesOff())
	{
		Super.Trigger(Other, Instigator);
		if (bTriggerOnceOnly)
			Destroy();
	}
}

singular function Touch(Actor Other)
{
	if (!IsRelevant(Other))
		return;

	if (SetAlliancesOn())
		if (bTriggerOnceOnly)
			Destroy();
}

function bool SetAlliancesOn()
{
	local tnmpawn P;
	local int i;

	// find the target NPC to set alliances
	if (Event != '')
		foreach AllActors (class'tnmPawn', P, Event)
			P.bHateBreakAndEnter = true;

	trestkon(GetPlayerPawn()).bBreakAndEnter = true;

	return True;
}

function bool SetAlliancesOff()
{
	local tnmpawn P;
	local int i;

	// find the target NPC to set alliances
	if (Event != '')
		foreach AllActors (class'tnmPawn', P, Event)
			P.bHateBreakAndEnter = false;

	trestkon(GetPlayerPawn()).bBreakAndEnter = false;

	return True;
}

defaultproperties
{
     bTriggerOnceOnly=False
     CollisionRadius=96.000000
}
