//=============================================================================
// AmmoManaPotion.
//=============================================================================
class AmmoManaPotion extends TNMAmmo;

var() bool bFloating;
var rotator origRot;


//
// This will make the Mana Potion look as if it's floating.
//
simulated function Tick(float deltaTime)
{
     local float        ang;
     local rotator      rot;
     local DeusExPlayer player;

     Super.Tick(deltaTime);

     if (bFloating)
     {
          ang = 2 * Pi * Level.TimeSeconds / 4.0;
          rot = origRot;
          rot.Pitch += Sin(ang) * 512;
          rot.Roll += Cos(ang) * 512;
          rot.Yaw += Sin(ang) * 256;
          SetRotation(rot);
     }
}

//
//Large and Belt Icon stuff.
//
#exec TEXTURE IMPORT NAME=LargeIconAmmoMana FILE=Textures\LargeIconAmmoMana.pcx GROUP=Skins MIPS=off // Large Icon
#exec TEXTURE IMPORT NAME=BeltIconAmmoMana FILE=Textures\BeltIconAmmoMana.pcx GROUP=Skins MIPS=off // Belt Icon



//
// Mesh import stuff
//
#exec MESH IMPORT MESH=ManaPotion ANIVFILE=MODELS\ManaPotion_a.3d DATAFILE=MODELS\ManaPotion_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ManaPotion X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=ManaPotion SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ManaPotion SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=Bottle FILE=Textures\ManaPotion1.PCX GROUP=Skins // SKIN
#exec TEXTURE IMPORT NAME=Cork FILE=Textures\ManaPotion2.PCX GROUP=Skins // TRANSLUCENT

#exec MESHMAP NEW   MESHMAP=ManaPotion MESH=ManaPotion
#exec MESHMAP SCALE MESHMAP=ManaPotion X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=ManaPotion NUM=0 TEXTURE=Cork
#exec MESHMAP SETTEXTURE MESHMAP=ManaPotion NUM=1 TEXTURE=Bottle
#exec MESHMAP SETTEXTURE MESHMAP=ManaPotion NUM=2 TEXTURE=Effects.Electricity.WEPN_Prod_FX

defaultproperties
{
     bFloating=True
     bShowInfo=True
     AmmoAmount=100
     MaxAmmo=400
     bAmbientGlow=True
     ItemName="Firestaff Mana Potion"
     ItemArticle="a"
     PickupViewMesh=LodMesh'ManaPotion'
     PickupViewScale=0.200000
     LandSound=Sound'DeusExSounds.Generic.GlassDrop'
     Icon=Texture'BeltIconAmmoMana'
     largeIcon=Texture'LargeIconAmmoMana'
     largeIconWidth=21
     largeIconHeight=34
     Description="Large numbers of these bottles containing an arcane substance known as 'mana' were brought to PDX Forum City by a Planet Diablo merchant several years ago. Apparently the merchant had heard that Deus Ex was a role-playing game, and assumed too much about the genre. Difficult to sell in a city where they have no utility, they are now mostly found in long-term storage or curio shops."
     beltDescription="MANA"
     Texture=FireTexture'Effects.Electricity.Wepn_Prod_FX'
     Mesh=LodMesh'ManaPotion'
     DrawScale=0.200000
     AmbientGlow=255
     CollisionRadius=2.100000
     CollisionHeight=2.700000
     bCollideActors=True
}
