class AthenaRespawnEffect extends Effects;

simulated function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	if (Owner == None)
		Destroy();
}

simulated function PostBeginPlay()
{
	local int i;

	for(i=0;i<8;i++) //make the particle probability 1/8
	{
		if(i==0)
			MultiSkins[i]=Texture;
		else
			MultiSkins[i]=Texture'BlackMaskTex';
	}

	Super.PostBeginPlay();

	Mesh = Owner.Mesh;
	DrawScale = Owner.DrawScale*0.5;

	bTrailerSameRotation = true;
	bAnimByOwner = true;

	SetBase(Owner);
}

defaultproperties
{
     bTravel=True
     Physics=PHYS_Trailer
     DrawType=DT_Mesh
     Style=STY_Translucent
     Texture=FireTexture'TNM_Core_Tex.Effects.AthenaSpawn'
     bUnlit=True
     bParticles=True
     bRandomFrame=True
     bOwnerNoSee=True
     ScaleGlow=0.5
}