class Augbot extends Augmentation;

var tnmrobot dominatedbot;
var trestkon tplayer;

state Active
{
	function Timer()
	{
		if (dominatedbot == none)
			deactivate();
		if(dominatedbot.getstatename() == 'disabled')
			deactivate();
	}

Begin:
	SetTimer(1, True);
	dominatedbot = findnearestbot();
	if (dominatedbot != none)
	{
		tplayer = trestkon(player);
		tplayer.dominatedbot = dominatedbot;
		tplayer.bdominatingbot = true;
		dominatedbot.becomedominated(tplayer);
	}
}

/*
function Activate()
{
local trestkon tplayer;
	Super.Activate();

	dominatedbot = findnearestbot();
	if (dominatedbot != none)
	{
		tplayer = trestkon(player);
		tplayer.dominatedbot = dominatedbot;
		tplayer.bdominatingbot = true;
		dominatedbot.becomedominated(tplayer);
	}
}
*/		

	
	

function Deactivate()
{
dominatedbot = none;
tplayer.dominatedbot = none;
tplayer.bdominatingbot = false;
	Super.Deactivate();

	SetTimer(1, False);
}

simulated function tnmrobot FindNearestBot()
{
   local tnmrobot bot, minbot;
   local float dist, mindist;

   minbot = None;
   mindist = 999999;
   foreach AllActors(class'tnmrobot', bot)
   {
	if (bot.GetStateName() != 'Disabled')  //no use taking a disabled bot
	{
		if (bot.dominatable)  //no point taking an allied bot
		{
			dist = VSize(Player.Location - bot.Location);
			if (dist < mindist)
			{
				mindist = dist;
				minbot = bot;
			}
		}
	}
   }
if (mindist < LevelValues[currentlevel])
   return minbot;
}


// Smoke39 - test only for being below maxlevel instead of CanBeUpgraded()
// which also looks for an aug upgrade can because
// 1. it's unnecessary here
// 2. it prevents upgrading with a redundant aug can
function bool IncLevel()
{
	if ( CurrentLevel >= MaxLevel )
	{
		Player.ClientMessage(Sprintf(AugAlreadyHave, AugmentationName));
		return False;
	}

	if (bIsActive)
		Deactivate();

	CurrentLevel++;
				
	Player.ClientMessage(Sprintf(AugNowHave, AugmentationName, CurrentLevel + 1));
}


defaultproperties
{
     EnergyRate=10.000000
     Icon=Texture'DeusExUI.UserInterface.AugIconDefense'
     smallIcon=Texture'DeusExUI.UserInterface.AugIconDefense_Small'
     AugmentationName="Aggressive Defense System"
     Description="Aerosol nanoparticles are released upon the detection of objects fitting the electromagnetic threat profile of missiles and grenades; these nanoparticles will prematurely detonate such objects prior to reaching the agent.|n|nTECH ONE: The range at which incoming rockets and grenades are detonated is short.|n|nTECH TWO: The range at which detonation occurs is increased slightly.|n|nTECH THREE: The range at which detonation occurs is increased moderately.|n|nTECH FOUR: Rockets and grenades are detonated almost before they are fired."
     MPInfo="When active, enemy rockets detonate when they get close, doing reduced damage.  Some large rockets may still be close enough to do damage when they explode.  Energy Drain: Low"
     LevelValues(0)=16000.000000
     LevelValues(1)=32000.000000
     LevelValues(2)=48000.000000
     LevelValues(3)=80000.000000
     MPConflictSlot=7
}
