class AugFX extends Effects
	abstract;

simulated function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	ScaleGlow=LifeSpan/Default.LifeSpan;

	if (Owner == None)
		Destroy();
	else
	{
		if(Fatness!=Owner.Fatness)
			Fatness=Owner.Fatness;

		if(PrePivot!=Owner.PrePivot)
			PrePivot=Owner.PrePivot;
	}
}

simulated function PostBeginPlay()
{
	local int i;

	Super.PostBeginPlay();

	Mesh = Owner.Mesh;
	DrawScale = Owner.DrawScale;

	//don't draw masked stuff, blackmasktex will be completely translucent
	for(i=0;i<8;i++)
		if(Owner.MultiSkins[i]==None||Owner.MultiSkins[i]==Texture'BlackMaskTex'||Owner.MultiSkins[i]==Texture'PinkMaskTex'||Owner.MultiSkins[i]==Texture'GrayMaskTex')
			MultiSkins[i]=Texture'BlackMaskTex'; //don't show masked stuff
		else
			MultiSkins[i]=Texture;

	//don't draw glasses, they don't look good with their material settings and the firetexture
	if	(Mesh==LodMesh'GM_DressShirt_B')
	{
		MultiSkins[4]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_DressShirt')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_Jumpsuit' || Mesh==LodMesh'mp_jumpsuit')
	{
		MultiSkins[5]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_DressShirt_F')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_DressShirt_S')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_Suit')
	{
		MultiSkins[5]=Texture'BlackMaskTex';
		MultiSkins[6]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_Trench')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_Trench_F')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_TShirtPants')
	{
		MultiSkins[3]=Texture'BlackMaskTex';
		MultiSkins[4]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_SuitSkirt_F')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_SuitSkirt')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_Trench')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_Dress')
	{
		//no glasses
	}
	else if	(Mesh==LodMesh'GMK_DressShirt_F')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GMK_DressShirt')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}

	Texture=Owner.Texture;
	bTrailerSameRotation = true;
	bAnimByOwner = true;

	SetBase(Owner);
}

defaultproperties
{
     bTravel=True
     Physics=PHYS_Trailer
     DrawType=DT_Mesh
     Style=STY_Translucent
     ScaleGlow=0.7
     bUnlit=True
     bParticles=False
     bOwnerNoSee=True
     LifeSpan=1.0
}