class BanInfo extends Info
	nousercreate;

var bool		bBanEnabled;
var BanEffect 		ban_fx;
var float		ban_timer;
var tnmpawn		ban_target;

#EXEC OBJ LOAD FILE=TNMSounds

function StartBan(tnmpawn p)
{
	ban_target=p;
	ban_target.Style=STY_Translucent;
	ban_target.PlaySound(Sound'TNMSounds.OneShot.IntroBan',SLOT_None,2.0,,);
	ban_target.ScaleGlow=1;
	ban_fx=Spawn(Class'BanEffect',p);
	ban_timer=0;
	bBanEnabled=true;
}

function UpdateBanFX()
{
	local tnmcarcass c;
	local actor a;
	local smoketrail smoke;

	ban_target.ScaleGlow -= 0.04;
	ban_fx.ScaleGlow=ban_target.ScaleGlow/2;
	if (ban_target.ScaleGlow <= 0)
	{
		Spawn(class'Shadow', Self,, Location-vect(0,0,1)*CollisionHeight, rot(16384,0,0));
		Spawn(Class'ScorchMark',,,ban_target.Location-vect(0,0,1)*ban_target.CollisionHeight,rot(16384,0,0));
		smoke=Spawn(Class'SmokeTrail',,,ban_target.Location-vect(0,0,1)*ban_target.CollisionHeight,rot(16384,0,0));
		smoke.origlifespan=5.0;
		smoke.lifespan=5.0;
		smoke.origscale=0.5;
		smoke.drawscale=0.5;
		ban_target.Destroy();
		ban_fx.Destroy();
		ban_fx=None; //should happen anyways, just in case with garbage collection
		bBanEnabled=false;
		Destroy();
	}
	if ( ban_target.ScaleGlow <= 0 )
		ban_target.Destroy();
}

function Tick(float deltaTime)
{
	super.Tick(deltaTime);

	if(bBanEnabled) //more gradual fade
	{
		ban_timer+=deltaTime;	
		if(ban_timer>0.0001)
		{
			UpdateBanFX();
			ban_timer=0;
		}
	}
}