//=============================================================================
// BotDisablerTrigger.
//=============================================================================
class BotDisablerTrigger expands Trigger;

function Trigger( Actor Other, Pawn Instigator )
{
	DisableBots();
	Super.Trigger( Other, Instigator );
	if ( bTriggerOnceOnly )
		Destroy();
}

singular function Touch( Actor Other )
{
	if ( IsRelevant(Other) )
	{
		DisableBots();
		if ( bTriggerOnceOnly )
			Destroy();
	}
}

function DisableBots()
{
	local Robot B;

	if ( Event != '' )
	{
		foreach AllActors( class'Robot', B, Event )
		{
			B.EMPHitPoints = 0;
			if ( !B.IsInState('Disabled') )
				B.GotoState('Disabled');
		}
	}
}

defaultproperties
{
     bTriggerOnceOnly=True
     CollisionRadius=96.000000
}
