//handles all bullet time stuff as not to clutter trestkon
//	-NVShacker 7/4/07
class BulletTimeManager extends Actor;

#exec AUDIO IMPORT NAME=BulletTimeStart FILE=Sounds\BulletTime\bullettime-start.wav
#exec AUDIO IMPORT NAME=BulletTimeEnd FILE=Sounds\BulletTime\bullettime-end.wav

var private Trestkon 			player;

var private bool			bBTKeyWait;
var private bool			bBTKeyWaitSelect;	

var private float			SpeedUpper;
var private float			SpeedLower;

var private Window			SpeedSelectionWin;

var private int				SpeedColorLow;
var private int				SpeedColorHigh;
var private int				SpeedColorCur;

var private float			SpeedSelectionTime;
var private float			SpeedSelectionFadeTime;
var private float			SpeedSelectionTimer;

var private class<DeusExProjectile> 	bulletProjectile;
var private string		 	bulletWeaponsStr[128];
var private class<DeusExWeapon> 	bulletWeapons[128];

event Spawned()
{
	local int i;

	player=Trestkon(owner);
	if(player==None)
	{
		Destroy();
		return;
	}

	for(i=0;bulletWeaponsStr[i]!="";i++)
		bulletWeapons[i]=class<DeusExWeapon>(DynamicLoadObject(bulletWeaponsStr[i],class'Class'));
}

function ModifyWeapons()
{
	local DeusExWeapon WEP;
	local int i;

	/*for(i=0;bulletWeaponsStr[i]!="";i++)
	{
		bulletWeapons[i].Default.bInstantHit=false;
		bulletWeapons[i].Default.ProjectileClass=bulletProjectile;
	}

	foreach AllActors(class'DeusExWeapon',WEP)
	{
		for(i=0;bulletWeaponsStr[i]!="";i++)
			if(WEP.Class==bulletWeapons[i])
			{
				WEP.bInstantHit=false;
				WEP.ProjectileClass=bulletProjectile;
				break;
			}
	}*/
}

function SetGameSpeed(float S)
{
	class'tnmSoundModifier'.static.On();
	class'tnmSoundModifier'.static.SetPitchMultiplier(S*0.75+0.25);
	player.Level.Game.GameSpeed = S;
	player.Level.Game.Level.TimeDilation = S;
	player.Level.Game.SetTimer(S, true);
}

function ToggleBulletTime()
{
	warn("ToggleBulletTime called in global context. Report this as a bug.");
	return;
}

function bool IsEnabled()
{
	return player.bUnlockedBulletTime;
}

function Tick(float deltaTime)
{
	if(!IsEnabled())
		return;

	if(player.bBulletTimePressed!=0 && !bBTKeyWait)
		ToggleBulletTime();
	else if(player.bBulletTimePressed==0 && bBTKeyWait)
		bBTKeyWait=false;
}

auto state Disabled
{
	function Tick(float deltaTime)
	{
		local float speed;

		player.TrestkonTick(deltaTime); //gross but at least I know it'll be called

		if(!bBTKeyWaitSelect)
		{
			Global.Tick(deltaTime);
			return;
		}

		SpeedSelectionTimer+=deltaTime;
		SpeedSelectionWin.SetTileColorRGB(0,0,SpeedColorHigh*FMin(SpeedSelectionTimer,SpeedSelectionTime)/SpeedSelectionTime);

		speed=(1-FMin(SpeedSelectionTimer,SpeedSelectionTime)/SpeedSelectionTime)*(SpeedUpper-SpeedLower)+SpeedLower;

		SetGameSpeed(speed);
		player.GroundSpeed=player.Default.GroundSpeed/speed*1.5;
		player.JumpZ=player.Default.JumpZ*(1+SpeedUpper-speed);
		player.AccelRate=player.Default.AccelRate/speed*1.5;

		if(player.bBulletTimePressed==0)
		{
			SpeedColorCur=SpeedColorHigh*FMin(SpeedSelectionTimer,SpeedSelectionTime)/SpeedSelectionTime;
			SpeedSelectionTimer=0.0;
			class'tnmSoundModifier'.static.Off();
			player.PlaySound(Sound'BulletTimeEnd',SLOT_None,1.0);
			class'tnmSoundModifier'.static.On();
			GotoState('Enabled');
		}
	}

	function ToggleBulletTime()
	{
		local TNMOggMusicManager music;

		player.bInBulletTime=true;

		bBTKeyWait=true;
		bBTKeyWaitSelect=true;
		SpeedSelectionTimer=0.0;

		SpeedSelectionWin=player.rootwindow.NewChild(Class'Window');
		SpeedSelectionWin.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
		SpeedSelectionWin.SetBackground(texture'Extension.Solid');
		SpeedSelectionWin.SetBackgroundStretching(true);
		SpeedSelectionWin.SetBackgroundStyle(DSTY_Translucent);
		SpeedSelectionWin.SetTileColorRGB(0,0,0);

//		class'tnmSoundModifier'.static.Off();
//		player.PlaySound(Sound'Foghorn',SLOT_None,1.0);
//		class'tnmSoundModifier'.static.On();

		foreach AllActors(Class'TNMOggMusicManager',music)
			break;
		if(music==None)
			music=Spawn(Class'TNMOggMusicManager');
		music.Pause();
		music.SetCurrentOgg("Slowmotion.ogg", "Slowmotion.ogg", 0.0, MTRAN_Instant);
	}

	Begin:
	player.bInBulletTime=false;
}

state Enabled
{
	function Tick(float deltaTime)
	{
		player.TrestkonTick(deltaTime);

		if(!bBTKeyWaitSelect)
		{
			Global.Tick(deltaTime);
			return;
		}

		SpeedSelectionTimer+=deltaTime;
		SpeedSelectionWin.SetTileColorRGB(0,0,(SpeedColorCur-SpeedColorLow)*(1-FMin(SpeedSelectionTimer,SpeedSelectionFadeTime)/SpeedSelectionFadeTime)+SpeedColorLow);

		if(SpeedSelectionTimer>SpeedSelectionFadeTime)
			bBTKeyWaitSelect=false;
	}

	function ToggleBulletTime()
	{
		local TNMOggMusicManager music;

//		SpeedSelectionWin.Destroy(); //destroying a window can cause crashes. damn the dx gui system!
		SpeedSelectionWin.Hide();
		SpeedSelectionWin.DisableWindow();
		SpeedSelectionWin=None;

		class'tnmSoundModifier'.static.Off();
		player.PlayOwnedSound(Sound'BulletTimeEnd',SLOT_None,1.0);
		class'tnmSoundModifier'.static.On();

		SetGameSpeed(player.Level.Game.Default.GameSpeed);
		player.GroundSpeed=player.Default.GroundSpeed;
		player.JumpZ=player.Default.JumpZ;
		player.AccelRate=player.Default.AccelRate;
		bBTKeyWait=true;

		foreach AllActors(Class'TNMOggMusicManager',music)
			break;
		music.SetCurrentOgg( "Blank.ogg" , "Blank.ogg" , 0.0 , MTRAN_Instant);
		music.UnPause();

		GotoState('Disabled');
	}
}

event Destroyed()
{
	if(SpeedSelectionWin!=None)
	{
		SpeedSelectionWin.Hide();
		SpeedSelectionWin.DisableWindow();
		SpeedSelectionWin=None;
	}
	player=None;
}

defaultproperties
{
     SpeedUpper=0.600000
     SpeedLower=0.080000
     SpeedColorLow=96
     SpeedColorHigh=192
     SpeedSelectionTime=1.500000
     SpeedSelectionFadeTime=0.500000
     bulletProjectile=Class'TNM.tnmProjectileBullet'
     bulletWeaponsStr(0)="DeusEx.WeaponPistol"
     bulletWeaponsStr(1)="DeusEx.WeaponStealthPistol"
     bulletWeaponsStr(2)="DeusEx.WeaponAssaultGun"
     bulletWeaponsStr(3)="DeusEx.WeaponAssaultShotgun"
     bulletWeaponsStr(4)="DeusEx.WeaponSawedOffShotgun"
     bulletWeaponsStr(5)="DeusEx.WeaponRifle"
     bulletWeaponsStr(6)="TNMItems.WeaponShotgun"
     bulletWeaponsStr(7)="TNMItems.WeaponTNMAssaultGun"
     bHidden=True
}
