//=============================================================================
// CamFadeWindow.
// Smoke39 - handles fading to/from black/white! :O
//=============================================================================
class CamFadeWindow expands Window;


// smooth gradient for fading, feel free to change the group if there's one set up for this sorta stuff
#exec TEXTURE IMPORT NAME=GreyBlackGradient FILE=textures\GreyBlackGradient.pcx GROUP=HUD MIPS=OFF

var bool bWhite;
var bool bFading;		// are we fading?
// negative values: fading to black
// positive values: fading from black
var float BlackFading;		// how far into the fade we are, zero means we're done
var float BlackFadeTime;	// duration, in seconds, of the fade


// set up fading to or from black in FadeDuration seconds
function StartFade( float FadeDuration )
{
	BlackFading = FadeDuration;
	BlackFadeTime = FadeDuration;
	bFading = true;
	bTickEnabled = true;
}

// this makes it fade rather than simply discolor :)
function Tick( float dt )
{
	if ( BlackFadeTime > 0 )
	{
		BlackFading -= dt;
		// have we faded all the way back in?
		if ( BlackFading <= 0 )
		{
			bFading = false;
			bTickEnabled = false;
		}
	}
	else
	{
		BlackFading = FMin( BlackFading+dt, 0 );
		// nothing for setting bFading to false here so we can keep the screen black until we fade back in
		// (really fast fade-in could be used if an immediate jump back to visibility was desired)
		if ( BlackFading >= 0 )
			bTickEnabled = false;
	}
}

// draw the darkness to the screen
function DrawWindow( GC gc )
{
	local float pos;
	local int str;

	// no one cares!
	if ( !bFading )
		return;

	// figure out how dark we should be
	if ( BlackFadeTime < 0 )
	{
		pos = (BlackFading-BlackFadeTime) / -BlackFadeTime * 125.0;
		str = 255 * (BlackFading-BlackFadeTime) / -BlackFadeTime; //unreal floating point math is fucked
	}
	else
	{
		pos = BlackFading / BlackFadeTime * 125.0;
		str = BlackFading / BlackFadeTime * 255;
	}

	// draw the actual darkness
	gc.SetTileColorRGB( 255, 255, 255 );
	if ( pos >= 125 )
	{
		gc.SetStyle( DSTY_Normal );
		if(bWhite)
			gc.DrawStretchedTexture( 0, 0, width, height, 0, 0, 1, 1, Texture'Extension.Solid' );
		else
			gc.DrawStretchedTexture( 0, 0, width, height, 0, 0, 1, 1, Texture'BlackMaskTex' );
	}
	else
	{
		if(bWhite)
		{
			gc.SetStyle( DSTY_Translucent );
			gc.SetTileColorRGB(str,str,str);
			gc.DrawStretchedTexture( 0, 0, width, height, 0, 0, 1, 1, Texture'Extension.Solid' );
		}
		else
		{
			gc.SetStyle( DSTY_Modulated );
			gc.DrawStretchedTexture( 0, 0, width, height, 0, Max(pos,1), 1, 1, Texture'GreyBlackGradient' );
		}
	}
}

defaultproperties
{
}
