class CheatListWindow extends DeusExBaseWindow;

var int padding;
var string text[256];
var int text_len;
var tnmlog dump;

var float typetime;
var float typetimerange;
var float newlinetime;
var int progress;
var float timer;
var bool bTyping;
var bool bWaiting;
var float typewait;
var string nextchar;
var localized string endstr1, endstr2;

function PlayTypeSound(bool backspace)
{
	local sound snd;
	local float pitch;
	if(typewait>0)
		return;
	switch(rand(2))
	{
	case 0:
		snd = Sound'DeusExSounds.Generic.KeyboardClick1';
		break;
	case 1:
		snd = Sound'DeusExSounds.Generic.KeyboardClick2';
		break;
	}
	if(backspace)
		snd = Sound'DeusExSounds.Generic.KeyboardClick3';
	pitch=0.8+frand()*0.4;
	typewait = player.GetSoundDuration(snd)/pitch+0.02;
	player.playsound(snd,,,,,pitch);
}

function Tick(float dt)
{
	if(typewait>0)
		typewait-=dt;
	if(bTyping && !bWaiting)
	{
		timer -= dt;
		if(timer < 0)
		{
			progress++;
			if(nextchar!=" ")
			{
				if(len(nextchar)==2)
					PlayTypeSound(true);
				else
					PlayTypeSound(false);
			}
			bWaiting = true;
		}
	}
}

event DrawWindow(GC gc)
{
	local int counter;
	local int i;
	local int y;
	local string str;
	local bool done;
	super.DrawWindow(gc);
	gc.SetTextColorRGB(255, 255, 255);	

	done = true;

	for(i=0; i<text_len && counter<=progress; i++)
	{
		if(counter==progress && bWaiting)
		{
			timer = newlinetime + (frand()-0.5) * 2 * typetimerange;
			bWaiting = false;
			done = false;
			nextchar="|n";
			break;
		}
		str=text[i];
		if(left(str, 3) ~= "<B>")
		{
			gc.SetFont(Font'FontMenuExtraLarge');
			str = right(str, len(str)-3);
		}
		else
		{
			gc.SetFont(Font'FontComputer8x20_B');
		}
		if(counter+len(str) > progress)
		{
			str=left(str, progress-counter);
			nextchar=right(str, len(str)-progress+counter);
			nextchar=left(nextchar, 1);
			counter = progress;
			done = false;
		}
		else
		{
			counter+=len(str);
		}
		gc.DrawText(padding,padding+y,width-padding,height-padding,str);
		y+=gc.getfontheight();
		if(!done)
			break;
	}

	if(done)
	{
		gc.SetFont(Font'FontMenuExtraLarge');
		i = progress - counter;
		if(i<=len(endstr1))
		{
			str=left(endstr1, i);
			nextchar=left(right(endstr1, len(endstr1)-i),1);
			done=false;
		}
		else if(i<=len(endstr1)*2)
		{
			i-=len(endstr1);
			i=len(endstr1)-i;
			str=left(endstr1, i);
			done=false;
			nextchar="|b";
		}
		else
		{
			i-=len(endstr1)*2;
			if(i>=len(endstr2))
			{
				str=endstr2;				
			}
			else
			{
				str=left(endstr2, i);
				nextchar=left(right(endstr1, len(endstr1)-i),1);
				done=false;
			}
		}
		gc.DrawText(padding,padding+y,width-padding,height-padding,str);
	}

	if(done)
	{
		bTyping = false;
		bWaiting = false;
	}
	else if (bWaiting)
	{
		timer = typetime + (frand()-0.5) * 2 * typetimerange;
		bWaiting = false;
	}
}

function ProcessTextTag(DeusExTextParser parser)
{
	local String str;
	local byte tag;
	local Name fontName;
	local String textPart;
	local String fileStringName;
	local String fileStringDesc;

	tag  = parser.GetTag();

	switch(tag)
	{
		case 0:				// TT_Text:
			str = parser.GetText();

			text[text_len]=text[text_len++]$str;
			dump.fLog(str);
			break;

		case 1:				// TT_File (graphic, baby!)
			parser.GetFileInfo(fileStringName, fileStringDesc);
			break;

		// Bold
		case 19:
			text[text_len]="<B>"$text[text_len];
			break;

		case 13:				// TT_LeftJustify:
			break;

		case 12:				// TT_CenterText:
			break;
	}
}

event InitWindow()
{
	local DeusExTextParser parser;
	Super.InitWindow();

	// Create the text parser
	parser = new(None) Class'DeusExTextParser';

	dump=new (None) Class'tnmLog';
	dump.fOpen("TNMCheats.log");

	// Attempt to find the text object
	if (parser.OpenText('TNMCheats',"TNMText"))
	{
		while(parser.ProcessText())
			ProcessTextTag(parser);

		parser.CloseText();
	}

	dump.fClose();

	CriticalDelete(parser);
	SetWindowAlignments(HALIGN_Full, VALIGN_Full);

	// Draw a black background for now
	SetBackgroundStyle(DSTY_Normal);
	SetBackground(Texture'Solid');
	SetTileColorRGB(0, 0, 0);

	SetMouseFocusMode(MFOCUS_Click);

	root.ShowHUD(False);
	bTickEnabled = true;
	bTyping = true;
	bWaiting = true;
	trestkon(player).bEscapeSkip=true;
}

event DestroyWindow()
{
	trestkon(player).bEscapeSkip=false;
	player.ClientTravel("TNMonly.dx", TRAVEL_Relative, True);
	Super.DestroyWindow();
}

defaultproperties
{
	padding=15
	typetime=0.082
	typetimerange=0.002
	newlinetime=0.2
	endstr1="Enjoy :)"
	endstr2="Don't cheat!"
}