//=============================================================================
// CreditReader.
//=============================================================================
class CreditReader extends HackableDevices;

var HUDCreditReaderWindow readerwindow;
var() name HackEvent;
var() name OpenEvent;
var() bool bBought;
var() int cost;

//callback from the window
function Bought()
{
	local Actor a;
	bBought = true;
	if ( OpenEvent != '' )
	{
		foreach allactors(class'actor', a, OpenEvent)
		{
			a.trigger( none, none );
		}
	}
}

function Hacked()
{
	local Actor a;
	if ( HackEvent != '' )
	{
		foreach allactors(class'actor', a, HackEvent)
		{
			a.trigger( none, none );
		}
	}
	Bought();
}

// ----------------------------------------------------------------------
// HackAction()
// ----------------------------------------------------------------------

function HackAction(Actor Hacker, bool bHacked)
{
	local DeusExPlayer Player;

	// if we're already using this keypad, get out
	if (readerwindow != None)
		return;

	Player = DeusExPlayer(Hacker);

	if (Player != None)
	{
		if ( bBought )
		{
			Bought();
		}
		else if ( bHacked )
		{
			Bought();
			Hacked();
		}
		else
			ActivateKeypadWindow(DeusexPlayer(Hacker), bHacked);
	}
}

// ----------------------------------------------------------------------
// ActivateKeypadWindow
// DEUS_EX AMSD Bounce back call from player so function rep works right.
// ----------------------------------------------------------------------
simulated function ActivateKeypadWindow(DeusExPlayer Hacker, bool bHacked)
{
      local Trestkon player;

      player = trestkon(hacker);

      player.tryBuy( self, bHacked);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

// Import model and texture
#exec mesh IMPORT MESH=TNMCardReader ANIVFILE=MODELS\TNMCardReader_a.3d DATAFILE=MODELS\TNMCardReader_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=TNMCardReader X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=TNMCardReader SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TNMCardReader SEQ=CardReader STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JTNMCardReader1 FILE=Textures\TNMCardReaderTex.PCX GROUP=Skins // 01 - default

#exec MESHMAP NEW   MESHMAP=TNMCardReader MESH=TNMCardReader
#exec MESHMAP SCALE MESHMAP=TNMCardReader X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMCardReader NUM=1 TEXTURE=JTNMCardReader1

defaultproperties
{
     ItemName="Credit Card Reader"
     Mass=10.000000
     Buoyancy=5.000000
     Mesh=LodMesh'TNMCardReader'
     DrawScale=1.000000
     CollisionRadius=8.000000
     CollisionHeight=5.000000
     msgNotHacked=""
}
