class CreditsImageWindow extends Window;

var float liveTime;
var float fadeinTime;
var float fadeouttime;
var float basefadetime;

var bool bFadeIn;
var bool bLive;
var bool bFadeOut;
var bool bHide;

function init(int x,int y,texture tex, float inLiveTime, float FadeTime)
{
	SetPos(x,y);
	SetSize(256,256);
	SetTileColorRGB(0,0,0);
	SetBackground(tex);
	SetBackgroundStyle(DSTY_Translucent);
	livetime = inLiveTime;
	fadeintime = FadeTime;
	fadeouttime = FadeTime;
	basefadetime = fadetime;
	bTickEnabled = True;
	bFadeIn=true;
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

function Tick(float deltaTime)
{
	local color colfade;

	if (bFadeIn && fadeintime > 0.0)
	{
		colfade.r = 255 * (1.0 - fadeintime / basefadetime);
		colfade.g = 255 * (1.0 - fadeintime / basefadetime);
		colfade.b = 255 * (1.0 - fadeintime / basefadetime);
		fadeintime -= deltatime;
		if(fadeintime <= 0.0)
		{
			bFadeIn=false;
			bLive=true;
		}
	}

	if (bLive && livetime > 0.0)
	{
		livetime -= deltatime;
		colfade.r = 255;
		colfade.g = 255;
		colfade.b = 255;
		if(livetime <= 0.0)
		{
			bLive=false;
			bFadeOut=true;
		}
	}

	if (bFadeOut && fadeouttime > 0.0)
	{
		colfade.r = 255 * (fadeouttime / basefadetime);
		colfade.g = 255 * (fadeouttime / basefadetime);
		colfade.b = 255 * (fadeouttime / basefadetime);
		fadeouttime -= deltatime;
		if(fadeouttime <= 0.0)
		{
			bFadeOut=false;
			bHide=true;
		}
	}

	if (bHide)
	{
		colfade.r = 0;
		colfade.g = 0;
		colfade.b = 0;
		Hide();
		bTickEnabled=false;
	}

	SetTileColor(colfade);
}