class CutsceneShakeTrigger extends Trigger;

var() bool 	bDisableAfterTransition;	//stop shaking after transition?
var() float 	MagnitudeStart;			//magnitude to start shaking at
var() float 	MagnitudeEnd;			//magnitude to end shaking at
var() float 	TransitionTime;			//time to transition between start and end magnitudes

var bool	bEnabled;
var float	time;

function Tick(float dt)
{
	local tnmCameraPoint cam;
	local int start, end, diff;

	if(bEnabled)
	{
		cam=Trestkon(GetPlayerPawn()).CurrentCam;
		if(cam==None)
		{
			log("Warning: Current Camera Point is None!",Name);
			return;
		}

		time+=dt;
		cam.bShaking=true;

		if(time>TransitionTime)
		{
			if(bDisableAfterTransition)
				cam.bShaking=false;
			else
				cam.ShakeMagnitude=MagnitudeEnd;

			bEnabled=false;

			if(bTriggerOnceOnly)
				Destroy();

			return;
		}

		start=MagnitudeStart;
		end=MagnitudeEnd;
		diff=end-start;

		cam.ShakeMagnitude=start+diff*time/transitiontime;
	}
}

function Trigger(Actor Other, Pawn Instigator)
{
	bEnabled=true;
	time=0;
}
