class CutsceneSoundTrigger extends trigger;

var() bool bStopMusic;
var() Sound Sound;

var() float volume;

var float playtime;

function tick(float deltatime)
{
	local tnmoggmusicmanager ogg;
	if ( playtime > -1 )
	{
		playtime += deltatime;
		if (playtime > GetSoundDuration( Sound ))
		{
			foreach allactors( class'tnmoggmusicmanager', ogg, )
			{
				ogg.unpause();
			}
			playtime = -1;
		}
	}
}

function Trigger( actor Other, pawn EventInstigator )
{
	local pawn P;
	local trestkon t;
	local tnmoggmusicmanager ogg;
	local actor a;

	super.Trigger( Self, EventInstigator );

	if (sound != none)
	{
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		{
			t = trestkon(P);
			if (t != none)
			{
				playtime = 0;
//				t.ambientsound = Sound;
//				t.tcam.ambientsound = Sound;
//				t.tcam.PlayOwnedSound(Sound, SLOT_Ambient, volume,,65536);
//				t.PlayOwnedSound(Sound,SLOT_Ambient,volume,,65536);
				t.PlayOwnedSound(Sound,SLOT_None,volume,True, 65536);
//				PlayOwnedSound(Sound,SLOT_Ambient,volume,,65536);

				if ( Event != '' )
				{
					foreach allactors(class'actor', a, Event)
					{
						a.PlayOwnedSound(Sound,SLOT_Ambient,volume,,65536);
						a.ambientsound = sound;
					}
				}
			}
		}

		foreach allactors( class'tnmoggmusicmanager', ogg, )
		{
			ogg.pause();
		}
	}
}

defaultproperties
{
     playtime=-1
     volume=4.0
}
