class FlagDump extends ExtensionObject;

static function dumpflags(tnmlog l, flagbase f)
{
	local name flagname;
	local EFlagType flagtype;
	local int it;
	local string str;

	it=f.createiterator();
	while(f.getnextflag(it,flagname,flagtype))
	{
		str=""$flagname;
		switch(flagtype)
		{
		case FLAG_Bool:
			str=str@"Bool";
			str=str@f.GetBool(flagname);
			break;
		case FLAG_Byte:
			str=str@"Byte";
			str=str@f.GetByte(flagname);
			break;
		case FLAG_Int:
			str=str@"Int";
			str=str@f.GetInt(flagname);
			break;
		case FLAG_Float:
			str=str@"Float";
			str=str@f.GetFloat(flagname);
			break;
		case FLAG_Name:
			str=str@"Name";
			str=str@f.GetName(flagname);
			break;
		case FLAG_Vector:
			str=str@"Vector";
			str=str@f.GetVector(flagname);
			break;
		case FLAG_Rotator:
			str=str@"Rotator";
			str=str@f.GetRotator(flagname);
			break;
		}
		l.fLog(str);
	}
}