//=============================================================================
// Flame
// Smoke39 - fancy effect for on-fire stuff
//=============================================================================
class Flame extends Effects;

var vector origVel, vel;

// set up location, velocity, draw scale
function BeginPlay()
{
	local rotator r;
	local vector v;
	local float f;

	r.Yaw = FRand() * 65536;

	f = FRand() * Owner.CollisionRadius;

	v = f * vector(r);
	v += Owner.Location;
	v.Z += (FRand()-FRand()) * Owner.CollisionHeight;
	SetLocation(v);

	f = Owner.CollisionRadius - f;
	f *= 50 * LifeSpan;

	origVel = f*vector(r) + (1+FRand())*vect(0,0,150);
	vel = origVel;
	Velocity = Owner.Velocity + vel;

	DrawScale *= 1 + Frand();
}

// shrink, curve in
simulated function Tick( float dt )
{
	local float f;

	if(Owner==None)
	{
		Destroy();
		return;
	}

	DrawScale = Default.DrawScale * LifeSpan / Default.LifeSpan;

	f = dt / (Default.LifeSpan/2);
	vel.X -= origVel.X * f;
	vel.Y -= origVel.Y * f;
	Velocity = Owner.Velocity + vel;
}

defaultproperties
{
     Physics=PHYS_Projectile
     LifeSpan=0.350000
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=FireTexture'Effects.Fire.OneFlame_J'
     DrawScale=1.500000
     bUnlit=True
}
