//=============================================================================
// GasMask.
//=============================================================================
class GasMask extends ChargedPickup;

#exec texture IMPORT NAME=BeltIconGasMask FILE=Textures\GasMaskBeltIcon.pcx GROUP=Skins MIPS=off // Belt Icon
#exec texture IMPORT NAME=LargeIconGasMask FILE=Textures\GasMaskLargeIcon.pcx GROUP=Skins MIPS=off // Inventory Icon
#exec texture IMPORT NAME=ChargeIconGasMask FILE=Textures\GasMaskChargeIcon.pcx GROUP=Skins MIPS=off // Charge Icon

//First Person & 3rd
#exec mesh IMPORT MESH=GasMask ANIVFILE=MODELS\GasMask_a.3d DATAFILE=MODELS\GasMask_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=GasMask X=0 Y=0 Z=0 YAW=64

#exec mesh SEQUENCE MESH=GasMask SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GasMask SEQ=GasMask3rd STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JGasMask1 FILE=Textures\GasMaskTex1.pcx GROUP=Skins // 01 - default

#exec MESHMAP NEW   MESHMAP=GasMask MESH=GasMask
#exec MESHMAP SCALE MESHMAP=GasMask X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=GasMask NUM=1 TEXTURE=JGasMask1


//Pickup mesh
#exec mesh IMPORT MESH=GasMaskPickup ANIVFILE=MODELS\GasMaskPickup_a.3d DATAFILE=MODELS\GasMaskPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GasMaskPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=GasMaskPickup SEQ=All           STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GasMaskPickup SEQ=GasMaskPickup STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JGasMaskPickup1 FILE=Textures\GasMaskTex1.pcx GROUP=Skins // 01 - default

#exec MESHMAP NEW   MESHMAP=GasMaskPickup MESH=GasMaskPickup
#exec MESHMAP SCALE MESHMAP=GasMaskPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=GasMaskPickup NUM=1 TEXTURE=JGasMaskPickup1

var localized string noskillmsg;

function Activate()
{
	local trestkon player;

	player = trestkon(Owner);
	if (player != None)
	{
		if( player.skillsystem.GetSkillLevel(skillNeeded) > 0)
			Super.Activate();
		else
			player.ClientMessage(noskillmsg); //...
	}
	
}

defaultproperties
{
     noskillmsg="You have insufficient skill to operate the gas mask."
     skillNeeded=Class'DeusEx.SkillEnviro'
     LoopSound=Sound'GasMaskBreathe'
     ChargedIcon=Texture'ChargeIconGasMask'
     ExpireMessage="Oops, batteries ran out. How long can you hold your breath?"
     ItemName="Gas Mask"
     ItemArticle="a"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'GasMask'
     PickupViewMesh=LodMesh'GasMaskPickup'
     ThirdPersonMesh=LodMesh'GasMask'
     Charge=300
     LandSound=Sound'DeusExSounds.Generic.PaperHit2'
     Icon=Texture'BeltIconGasMask'
     largeIcon=Texture'LargeIconGasMask'
     largeIconWidth=34
     largeIconHeight=49
     Description="This is a gas mask, or more correctly, a full-face supplied-air respirator. The fact that it covers your whole face means it protects well against tear gas, while the air canister will keep you alive even when there is no air left around you to purify (for example if you're standing in a room full of halon gas). Unfortunately it doesn't work under water, as it's not built to handle the pressure. The problem is that when the batteries die, so do you."
     beltDescription="GASMASK"
     Mesh=LodMesh'GasMaskPickup'
     PickupViewScale=0.700000
     PlayerViewScale=0.700000
     ThirdPersonScale=0.700000
     Drawscale=0.700000
     CollisionRadius=11.500000
     CollisionHeight=5.500000
     Mass=40.000000
     Buoyancy=30.000000
}
