//=============================================================================
// DeusExScopeView.
//=============================================================================
class GasMaskView expands Window;

//var bool bActive;		// is this view actually active?

var deusexplayer player;
var Color colLines;
var Bool  bViewVisible;
var int   desiredFOV;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
	
	// Get a pointer to the player
	player = deusexplayer(GetRootWindow().parentPawn);

	bTickEnabled = false;

	StyleChanged();
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

event Tick(float deltaSeconds)
{
//	local Crosshair        cross;
//	local DeusExRootWindow dxRoot;

//	dxRoot = DeusExRootWindow(GetRootWindow());
//	if (dxRoot != None)
//	{
//		cross = dxRoot.hud.cross;

//		if (bActive)
//			cross.SetCrosshair(false);
//		else
//			cross.SetCrosshair(player.bCrosshairVisible);
//	}
}

// ----------------------------------------------------------------------
// ActivateView()
// ----------------------------------------------------------------------

function ActivateView(int newFOV, bool bInstant)
{
	desiredFOV = newFOV;

	if (player != None)
	{
		if (bInstant)
			player.SetFOVAngle(desiredFOV);
		else
			player.desiredFOV = desiredFOV;

		bViewVisible = True;
		Show();
	}
}

// ----------------------------------------------------------------------
// DeactivateView()
// ----------------------------------------------------------------------

function DeactivateView()
{
	if (player != None)
	{
		Player.DesiredFOV = Player.Default.DefaultFOV;
		bViewVisible = False;
		Hide();
	}
}

// ----------------------------------------------------------------------
// HideView()
// ----------------------------------------------------------------------

function HideView()
{
	if (bViewVisible)
	{
		Hide();
		Player.SetFOVAngle(Player.Default.DefaultFOV);
	}
}

// ----------------------------------------------------------------------
// ShowView()
// ----------------------------------------------------------------------

function ShowView()
{
	if (bViewVisible)
	{
		Player.SetFOVAngle(desiredFOV);
		Show();
	}
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	local float			fromX, toX;
	local float			fromY, toY;
	local float			scopeWidth, scopeHeight;

	Super.DrawWindow(gc);

	if (GetRootWindow().parentPawn != None)
	{
		if (player.IsInState('Dying'))
			return;
	}

	scopeWidth  = 512;

	scopeHeight = 512;

	fromX = (width-scopeWidth)/2;
	fromY = (height-scopeHeight)/2;
	toX   = fromX + scopeWidth;
	toY   = fromY + scopeHeight;

	// Draw the black borders
	gc.SetTileColorRGB(0, 0, 0);
	gc.SetStyle(DSTY_Normal);
	if ( Player.Level.NetMode == NM_Standalone )	// Only block out screen real estate in single player
	{
		gc.DrawPattern(0, 0, width, fromY, 0, 0, Texture'Solid');
		gc.DrawPattern(0, toY, width, fromY, 0, 0, Texture'Solid');
		gc.DrawPattern(0, fromY, fromX, scopeHeight, 0, 0, Texture'Solid');
		gc.DrawPattern(toX, fromY, fromX, scopeHeight, 0, 0, Texture'Solid');
	}
	// Draw the center scope bitmap
	// Use the Header Text color 

	gc.SetStyle(DSTY_Modulated);
	gc.DrawTexture(fromX,       fromY, 256, 256, 0, 0, Texture'MaskOverlay01');
	gc.DrawTexture(fromX + 256, fromY, 256, 256, 0, 0, Texture'MaskOverlay02');
	gc.DrawTexture(fromX,       fromY + 256, 256, 256, 0, 0, Texture'MaskOverlay03');
	gc.DrawTexture(fromX + 256, fromY + 256, 256, 256, 0, 0, Texture'MaskOverlay04');
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	colLines = theme.GetColorFromName('HUDColor_HeaderText');
}

defaultproperties
{
}
