class MSCallbackTrigger extends Trigger;

var() name ScriptFunction;

function Touch( actor Other )
{
	local actor A;
	local bool  restoreGroup;  // DEUS_EX CNN

	if( IsRelevant( Other ) )
	{
		if ( ReTriggerDelay > 0 )
		{
			if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
				return;
			TriggerTime = Level.TimeSeconds;
		}

		Trigger(Other, none);


		if ( Other.IsA('Pawn') && (Pawn(Other).SpecialGoal == self) )
			Pawn(Other).SpecialGoal = None;
				
		if( Message != "" )
			// Send a string message to the toucher.
			Other.Instigator.ClientMessage( Message );

		if( bTriggerOnceOnly )
			// Ignore future touches.
			SetCollision(False);
		else if ( RepeatTriggerTime > 0 )
			SetTimer(RepeatTriggerTime, false);
	}
}

function Trigger(Actor Other, Pawn Instigator)
{
	local tnmmissionscript scr;
	foreach allactors(class'tnmmissionscript',scr)
		break;
	if (scr != none)
		scr.HandleGameEvent(ScriptFunction);
	else
		Log("Mission script does not exist", name);
}

defaultproperties
{
}
