class PongTextureController extends tnmTextureController;

//var() ScriptedTexture SlaveTexture;
var Texture palTexture;
var Texture drawTexture;
var Texture blankTexture;

var() name P1ScoreEvent;
var() name P2ScoreEvent;

//pong vars
var float boardX;
var float boardY;
var float boardW;
var float boardH;

var float ballW;
var float ballH;
var float paddleW;
var float paddleH;

var float ballX;
var float ballY;
var float ballVX;
var float ballVY;
var float ballSpeed;

var float p1X;
var float p1Y;
var float p1speed;
var int   p1score;

var float p2X;
var float p2Y;
var float p2speed;
var int   p2score;

var float AIdest;
var bool  bAIsearch;

var float AI2dest;
var bool  bAI2search;

var float wait;

var float AIspeed;
//end pong vars

simulated function BeginPlay() 
{ 
	if(slaveTexture != None)
	{
		slaveTexture.NotifyActor = Self;
		slaveTexture.Palette = palTexture.Palette;
		SetupGame();
	}
	else
		Destroy(); //without swapTexture our existence is meaningless! meaningless I say!
}


simulated function SetupGame()
{
	p1X=0;
	p1Y=boardH/2-paddleH/2;
	p2X=boardW-paddleW;
	p2Y=p1Y;

	p1score=0;
	p2score=0;

	AIdest  = p1Y;
	AI2dest = p2y;

	ResetBall();
}

simulated function ResetBall()
{
	ballX=boardW/2-ballW;
	ballY=boardH/2-ballH;

	ballVX=FRand()*0.5+0.5;
	ballVY=sqrt(1-ballVX*ballVX);

	if(FRand()<0.5)
		ballVX=-ballVX;
	if(FRand()<0.5)
		ballVY=-ballVY;
	ballSpeed=1.5;

	bAIsearch  = true;
	bAI2search = true;

	wait=1;
}

simulated function Tick(float deltaTime)
{
	local float newX, newY, AItime1, AItime2, AIpos, AImult;
	local int AIfubar;
	local bool bUpdateBall;

//	if(slaveTexture.NotifyActor!=Self)
//		BeginPlay();

	if(wait>0)
	{
		wait-=deltaTime;
		return;
	}

	deltaTime*=150; //semi-arbitrary speed factor

	//ai searches for dest
	if(bAIsearch)
	{
		if(ballVX<0)
		{
			AItime1=(paddleW-ballX)/ballVX; //get time to reach ai's side
			AIdest=ballY+ballVY*AItime1;
			AImult=1;
			AIpos=ballY;
			AIfubar=0;

			//loop through to project the final y velocity
			while((AIdest<0 || AIdest>boardH-paddleH) && AIfubar<10)
			{
				//find the collision
				if(AImult*ballVY<0)
				{
					AItime2=-AIpos/ballVY*AImult;
					AIpos=0;
				}
				else
				{
					AItime2=(boardH-AIpos)/ballVY*AImult;
					AIpos=boardH-ballH;
				}

				//alter the projection based on this location
				AItime1-=AItime2;
				AImult*=-1;
				AIdest=AIpos + ballVY * AItime1 *AImult;
				AIfubar++;
			}
			if(AIdest-paddleH/2>0) //center paddle
				AIdest-=paddleH/2;
		}
		if(AIfubar<10)
			bAIsearch=false;
	}
	else if(ballVX>0)
		AIdest=ballY;

	//ai approaches its dest
	p1speed=0;
	if(abs(p1Y-AIdest)>3)
	{
		if(p1Y>AIDest)
			p1speed=-AIspeed;
		else
			p1speed=AIspeed;
	}

	//paddle movement shit. ai
	newY=p1Y+p1speed*deltaTime;
	if(newY>=0 && newY<=boardH-paddleH)
		p1Y=newY;

	//ai searches for dest
	if(bAI2search)
	{
		if(ballVX>0)
		{
			AItime1=(p2X-ballX)/ballVX; //get time to reach ai's side
			AI2dest=ballY+ballVY*AItime1;
			AImult=1;
			AIpos=ballY;
			AIfubar=0;

			//loop through to project the final y velocity
			while((AI2dest<0 || AI2dest>boardH-paddleH) && AIfubar<10)
			{
				//find the collision
				if(AImult*ballVY<0)
				{
					AItime2=-AIpos/ballVY*AImult;
					AIpos=0;
				}
				else
				{
					AItime2=(boardH-AIpos)/ballVY*AImult;
					AIpos=boardH-ballH;
				}

				//alter the projection based on this location
				AItime1-=AItime2;
				AImult*=-1;
				AIdest=AIpos + ballVY * AItime1 *AImult;
				AIfubar++;
			}
			if(AIdest-paddleH/2>0) //center paddle
				AIdest-=paddleH/2;
		}
		if(AIfubar<10)
			bAI2search=false;
	}
	else if(ballVX<0)
		AI2dest=ballY;

	//ai approaches its dest
	p2speed=0;
	if(abs(p2Y-AI2dest)>3)
	{
		if(p2Y>AI2Dest)
			p2speed=-AIspeed;
		else
			p2speed=AIspeed;
	}
	
	//paddle movement shit. ai
	newY=p2Y+p2speed*deltaTime;
	if(newY>=0 && newY<=boardH-paddleH)
		p2Y=newY;		

	//default (non collision) ball behavior
	bUpdateBall=true;

	newX=ballX+ballVX*deltaTime*ballSpeed;
	newY=ballY+ballVY*deltaTime*ballSpeed;

	//collision detection
	if(newY<0 || newY+ballW>boardH)
	{
		ballVY=-ballVY;	
		if(ballVX<0)
			bAIsearch=true; //just to be thorough
		else
			bAI2search=true;
		bUpdateBall=false;
	}

	if(newX<=paddleW && newY<=p1Y+paddleH && newY+ballH>=p1Y)
	{
		ballX=paddleW+1;
		ballVX=-ballVX;
		ballSpeed*=1.1;
		bAI2search=true;
		bUpdateBall=false;
	}

	if(newX+ballW>=p2X && newY<=p2Y+paddleH && newY+ballH>=p2Y)
	{
		ballX=p2X-ballW-1;
		ballVX=-ballVX;
		ballSpeed*=1.1;
		bAIsearch=true;
		bUpdateBall=false;
	}

	//handles default behavior and collision for scoring
	if(bUpdateBall)
	{
		ballX=newX;
		ballY=newY;
		if(ballX<=0)
		{
			ResetBall();
			Player2Scored();
		}
		else if(ballX+ballW>=boardW)
		{
			ResetBall();
			Player1Scored();
		}
	}
}

simulated function Player1Scored()
{
	local Actor A;
	if(P1ScoreEvent!='')
	{
		foreach AllActors(class'Actor', A, P1ScoreEvent)
			A.Trigger(Self, getPlayerPawn());
	}
}

simulated function Player2Scored()
{
	local Actor A;
	if(P2ScoreEvent!='')
	{
		foreach AllActors(class'Actor', A, P2ScoreEvent)
			A.Trigger(Self, getPlayerPawn());
	}
}

simulated event RenderTexture(ScriptedTexture T)
{
//	T.ReplaceTexture(blankTexture);
	T.DrawTile(boardW/2-2,   0,            4,       256,     0, 1, 1, 8, palTexture,   false);
	T.DrawTile(0,            0,            256,     256,     0, 0, 1, 1, blankTexture, false);
	T.DrawTile(p1X+boardX,   p1Y+boardY,   paddleW, paddleH, 0, 0, 8, 8, drawTexture,  false);
	T.DrawTile(p2X+boardX,   p2Y+boardY,   paddleW, paddleH, 0, 0, 8, 8, drawTexture,  false);
	T.DrawTile(ballX+boardX, ballY+boardY, ballW,   ballH  , 0, 0, 8, 8, drawTexture,  false);
	return;
}

defaultproperties
{
     palTexture=Texture'Extension.Dithered'
     DrawTexture=Texture'Extension.Solid'
     blankTexture=Texture'DeusExItems.Skins.BlackMaskTex'
     boardX=2.000000
     boardY=2.000000
     boardW=254.000000
     boardH=254.000000
     ballW=4.000000
     ballH=4.000000
     paddleW=6.000000
     paddleH=24.000000
     AIspeed=2.000000
     RemoteRole=ROLE_SimulatedProxy
     bAlwaysRelevant=True
}
