//=============================================================================
// Fireball Smoke.
// Smoke39 - attached to TNMFireball an' then go ploof...
//=============================================================================
class TNMFireballSmoke expands Effects;

// necessary for this smoke puff, but not for the texture in Flame? \=|
#exec OBJ LOAD FILE=Effects

var bool bRelinquished;
var float origLifeSpan;

simulated function Tick( float dt )
{
	Super.Tick(dt);

	if ( !bRelinquished )
		return;

	Velocity *= 1-dt;
	Velocity.Z += 200*dt;
	DrawScale += 2*dt;
	ScaleGlow = LifeSpan / origLifeSpan;
}

defaultproperties
{
     Physics=PHYS_Projectile
     LifeSpan=1.000000
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=FireTexture'Effects.Smoke.SmokePuff1'
     DrawScale=0.100000
     bCollideWorld=True
}
