class tnmHUDHitDisplay expands HUDHitDisplay;

event Tick(float deltaSeconds)
{
   // DEUS_EX AMSD Server doesn't need to do this.
   if ((player.Level.NetMode != NM_Standalone)  && (!Player.PlayerIsClient()))
   {
      Hide();
      return;
   }
	if ((player != None) && ( bVisible ))
	{
		SetHitColor(head,     deltaSeconds, false, player.HealthHead);
		SetHitColor(torso,    deltaSeconds, false, player.HealthTorso);
		SetHitColor(armLeft,  deltaSeconds, false, player.HealthArmLeft);
		SetHitColor(armRight, deltaSeconds, false, player.HealthArmRight);
		SetHitColor(legLeft,  deltaSeconds, false, player.HealthLegLeft);
		SetHitColor(legRight, deltaSeconds, false, player.HealthLegRight);

		// Calculate the energy bar percentage
		energyPercent = 100.0 * (player.Energy / player.EnergyMax);
		winEnergy.SetCurrentValue(energyPercent);
		
		// If we're underwater, draw the breath bar
		if (bUnderwater)
		{
			// if we are already underwater
			if ((player.HeadRegion.Zone.bWaterZone) || trestkon(player).bNoOxygen)
			{
				// if we are still underwater
				breathPercent = 100.0 * player.swimTimer / player.swimDuration;
				breathPercent = FClamp(breathPercent, 0.0, 100.0);
			}
			else
			{
				// if we are getting out of the water
				bUnderwater = False;
				breathPercent = 100;
			}
		}
		else if (player.HeadRegion.Zone.bWaterZone || trestkon(player).bNoOxygen)
		{
			// if we just went underwater
			bUnderwater = True;
			breathPercent = 100;
		}

		// Now show or hide the breath meter
		if (bUnderwater)
		{
			if (!winBreath.IsVisible())
				winBreath.Show();

			winBreath.SetCurrentValue(breathPercent);
		}
		else
		{
			if (winBreath.IsVisible())
				winBreath.Hide();
		}

		Show();
	}
	else
		Hide();
}

defaultproperties
{
}
