class TNMOggMusicManager extends DXOggMusicManager;

var(DXOggMusicManager) string Ambient2IntroOggFile;
var(DXOggMusicManager) string Ambient2OggFile;
var(DXOggMusicManager) string Ambient1IntroOggFile;
var(DXOggMusicManager) string Ambient1OggFile;

var(DXOggMusicManager) name FlagName;

var bool bShouldPlayStereo;
var bool bPlayingStereo;

var string stereoTrack;
var tnmstereo stereo;

var int soundPauses;

var transient bool binited;

var bool bPlayOutro;

function Pause()
{
  soundPauses++;
  if (soundPauses == 1)
  {
	savedSongPos = GetCurrentSongPosition();
  	SetCurrentOgg( "Blank.ogg" , "Blank.ogg" , 0.0 , MTRAN_Instant);
	MusicMode = MUS_None;
  }
}

function UnPause()
{
  soundPauses--;
  if (soundPauses < 0)
	soundpauses = 0;
  if (soundPauses == 0)
  {
    tick(0.0); //this has the potential to do dodgy things (e.g. div 0) but hopefully will be ok.    
  }	
}

function PostPostBeginPlay()
{
}

function init()
{
    local FlagBase flags;

    flags = DeusExPlayer(GetPlayerPawn()).FlagBase;

    if (flags.GetBool(FlagName))
    {
	AmbientIntroOggFile = Ambient2IntroOggFile;
	AmbientOggFile = Ambient2OggFile;
    }
    else
    {
	AmbientIntroOggFile = Ambient1IntroOggFile;
	AmbientOggFile = Ambient1OggFile;
    }

    Super.PostPostBeginPlay();
}


function PlayStereoSong(string inStereoTrack, tnmstereo inStereo)
{
	if ((bShouldPlayStereo == true) && (stereoTrack == inStereoTrack) && (stereo == inStereo))
		return;

	if((Len(inStereoTrack) > 0) && (inStereo != none))
	{
		stereo = inStereo;
		stereoTrack = inStereoTrack;
		SetCurrentOgg("", stereoTrack, 0.0, MTRAN_FastFade);
		bShouldPlayStereo = true;
		bPlayingStereo = true;
	}
	else
	{
		bShouldPlayStereo = false;
		bPlayingStereo = false;
		if ( musicMode == MUS_Ambient )
			SetCurrentOgg(AmbientIntroOggFile, AmbientOggFile, 0.0, MTRAN_Fade);
	}
}

function Tick(float deltaTime)
{
	local trestkon player;
	local DeusExLevelInfo info;

	if ( !binited )
	{
		init();
		binited = true;
	}

	if (soundPauses == 0)
	{
		player = trestkon(GetPlayerPawn());
		if (musicMode == MUS_Outro)
			return;

        	if (!player.PlayerIsClient() && (musicMode == MUS_Dying))
	                return;

		if (bPlayOutro)
		{
        	       	if(Len(OutroOggFile) > 0)
	                {
       	        	    SetCurrentOgg(OutroOggFile, "blank.ogg", 0.0, MTRAN_FastFade);
        	       	    musicMode = MUS_Outro;
	                }
		}
		else if (player.IsInState('Interpolating'))
        	{
	            // don't mess with the music on any of the intro maps
        	    info = player.GetLevelInfo();
	            if ((info != None) && (info.MissionNumber < 0))
        	    {
                	musicMode = MUS_Outro;
	                return;
        	    }

	            if (musicMode != MUS_Outro)
        	    {
                	if(Len(OutroOggFile) > 0)
	                {
        	            SetCurrentOgg(OutroOggFile, "blank.ogg", 0.0, MTRAN_FastFade);
                	    musicMode = MUS_Outro;
	                }
        	    }
	        }
		else if (player.IsInState('Dying'))
	        {
        	    if (musicMode != MUS_Dying)
            	    {
                	if(Len(DeathOggFile) > 0)
	                {
        	            SetCurrentOgg(DeathOggFile, "blank.ogg", 0.0, MTRAN_Fade);
                	    musicMode = MUS_Dying;
	                }
        	    }
	        }
		else if ( player.bCinematic )
		{
			if (musicMode != MUS_Ambient)
			{
				if(Len(AmbientOggFile) > 0)
				{
                        		// fade slower for combat transitions
					SetCurrentOgg(AmbientIntroOggFile, AmbientOggFile, savedSongPos, MTRAN_SlowFade);
		                        savedSongPos = 0.0;
                		        musicMode = MUS_Ambient;
		                        musicChangeTimer = 0.0;
				}
			}
		}
		else
		{
			Super.Tick(deltaTime);
		}
	}
}

defaultproperties
{
     bPlayOutro=false
     soundPauses=0
     Ambient2IntroOggFile=""
     Ambient2OggFile=""
     Ambient1IntroOggFile=""
     Ambient1OggFile=""
}
