//=============================================================================
// TNMWeapon.
//=============================================================================
class TNMWeapon extends DeusExWeapon
	abstract;

//var(shopping) bool bstolen;
//replaced with bSplashDamage
//var(shopping) int cost;
//replaced with armorabsorption

var bool busefiremode;
var string firemode;
var string belttext;

var() sound hitfleshsound;
var() sound hitwoodsound;
var() sound hitmetalsound;
var() sound hitothersound;
var() sound deselectsound;
var() sound firesilencedsound;
var() sound altfiresilencedsound;
var() sound AltFireSoundReal;

var texture ScopeTexture01;
var texture ScopeTexture02;
var texture ScopeTexture03;
var texture ScopeTexture04;

//var bool bHasUberScope;
var int targetDistance;

var bool bNoMetal;

enum EScopeType
{
	EScopeType_Normal,
	EScopeType_HighTech,
	EScopeType_Custom
};

var EScopeType ScopeType;

// Smoke39 - bloody weapon variables
var() bool bGetsBloody;		// typically, melee weapons will have this set to true
var travel float Bloodiness;	// how bloody the weapon currently is

var bool bReloadAnimHack;

var class<Inventory> ModelClass; //for hdtp compatability


//laser stuff: actually far far more effort that was really worth it

var float laserupdatetime, laserupdatetimer;
var float laserupdatetime2, laserupdatetimer2;

var bool bLasingNew;
var bool bCountLaser1, bCountLaser2;
var bool buselaser1;

var vector newlaservec;
var vector lastlaservec;
var vector futurelaservec;


//laser functions
//
// copied from Weapon.uc so we can add range information
//
simulated function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot;
	local actor Other;
	local float dist, alpha, degrade;
	local int i, numSlugs;
	local float volume, radius;

	// make noise if we are not silenced
	if (!bHasSilencer && !bHandToHand)
	{
		GetAIVolume(volume, radius);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);

	// check to see if we are a shotgun-type weapon
	if (AreaOfEffect == AOE_Cone)
		numSlugs = 5;
	else
		numSlugs = 1;

	// if there is a scope, but the player isn't using it, decrease the accuracy
	// so there is an advantage to using the scope
	//if (bHasScope && !bZoomed && !bLasing)
	//	Accuracy += 0.2;
	// if the laser sight is on, make this shot dead on
	// also, if the scope is on, zero the accuracy so the shake makes the shot inaccurate
	if (bLasing || bZoomed)
		Accuracy = 0.0;


	for (i=0; i<numSlugs; i++)
	{
	  // If we have multiple slugs, then lower our accuracy a bit after the first slug so the slugs DON'T all go to the same place
	  if ((i > 0) && !(bHandToHand))
		 if (Accuracy < MinSpreadAcc)
			Accuracy = MinSpreadAcc;

	  // Let handtohand weapons have a better swing
	  if ((bHandToHand) && (NumSlugs > 1) && (Level.NetMode != NM_Standalone))
	  {
		 StartTrace = ComputeProjectileStart(X,Y,Z);
		 StartTrace = StartTrace + (numSlugs/2 - i) * SwingOffset;
	  }

		if(!bLasing || Emitter == none)
		{
			EndTrace = StartTrace + Accuracy * (FRand()-0.5)*Y*1000 + Accuracy * (FRand()-0.5)*Z*1000 ;
			EndTrace += (FMax(1024.0, MaxRange) * vector(AdjustedAim));
		}
		else //we take it direct from  the emitter
		{
			StartTrace = emitter.Location;
			endtrace = starttrace + vector(emitter.Rotation)*FMax(1024.0, MaxRange);
		}

	  Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

		// randomly draw a tracer for relevant ammo types
		// don't draw tracers if we're zoomed in with a scope - looks stupid
	  // DEUS_EX AMSD In multiplayer, draw tracers all the time.
		if ( ((Level.NetMode == NM_Standalone) && (!bZoomed && (numSlugs == 1) && (FRand() < 0.5))) ||
		   ((Level.NetMode != NM_Standalone) && (Role == ROLE_Authority) && (numSlugs == 1)) )
		{
			if ((AmmoName == Class'Ammo10mm') || (AmmoName == Class'Ammo3006') ||
				(AmmoName == Class'Ammo762mm'))
			{
				if (VSize(HitLocation - StartTrace) > 250)
				{
					rot = Rotator(EndTrace - StartTrace);
			   if ((Level.NetMode != NM_Standalone) && (Self.IsA('WeaponRifle')))
				  Spawn(class'SniperTracer',,, StartTrace + 96 * Vector(rot), rot);
			   else
				  Spawn(class'Tracer',,, StartTrace + 96 * Vector(rot), rot);
				}
			}
		}

		// check our range
		dist = Abs(VSize(HitLocation - Owner.Location));

		if (dist <= AccurateRange)		// we hit just fine
			ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		else if (dist <= MaxRange)
		{
			// simulate gravity by lowering the bullet's hit point
			// based on the owner's distance from the ground
			alpha = (dist - AccurateRange) / (MaxRange - AccurateRange);
			degrade = 0.5 * Square(alpha);
			HitLocation.Z += degrade * (Owner.Location.Z - Owner.CollisionHeight);
			ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		}
	}

	// otherwise we don't hit the target at all
}

function PreBeginPlay()
{
	Super.PreBeginPlay();

	CheckWeaponSkins();
}

function DropFrom(vector StartLocation)
{
	checkweaponskins();

	super.dropfrom(startlocation);
}

Function CheckWeaponSkins()
{
//empty placeholder :p
}

function PostBeginPlay()
{
	super.PostBeginPlay();

	//the blood will automatically show itself when the weapon is bloody and not in first person
	Spawn(Class'tnmWeaponBlood1',Self);
	Spawn(Class'tnmWeaponBlood2',Self);

	if(ModelClass==None)
		return;
	class'tnmUtil'.static.AttemptReplaceModel(Self,ModelClass);
	class'tnmUtil'.static.AttemptReplaceInventoryModel(Self,ModelClass);
}

function DrawAdditionalScope(GC gc, int width, int height)
{
}

// Smoke39 - draw blood on the weapon
simulated event RenderOverlays( canvas Canvas )
{
	local PlayerPawn PlayerOwner;

	Super.RenderOverlays( Canvas );

	if ( bHideWeapon || (Owner == None) )
		return;

	PlayerOwner = PlayerPawn(Owner);

	if ( PlayerOwner != None && PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
		return;

	if ( Bloodiness < 2 )
		return;

	Style = STY_Modulated;
	Texture = Texture'BlackMaskTex';  // foil any enviromap bits

	MultiSkins[0] = Texture'FlatFXTex2';
	MultiSkins[1] = Texture'FlatFXTex2';
	MultiSkins[2] = Texture'FlatFXTex2';
	Canvas.DrawActor(self, false);

	if ( Bloodiness > 4 )
	{
		MultiSkins[0] = Texture'FlatFXTex3';
		MultiSkins[1] = Texture'FlatFXTex3';
		MultiSkins[2] = Texture'FlatFXTex3';
		Canvas.DrawActor(self, false);
	}

	Style = Default.Style;
	Texture = Default.Texture;
	MultiSkins[0] = Default.MultiSkins[0];
	MultiSkins[1] = Default.MultiSkins[1];
	MultiSkins[2] = Default.MultiSkins[2];
}


//
// scope, laser, and targetting updates are done here
//
simulated function Tick(float deltaTime)
{
	local vector loc, point, offset;
	local rotator rota, defrot;
	local vector X, Y, Z, endtrace;
	local float beepspeed, recoil, mod, mod2, origmod;
	local DeusExPlayer player;
	local Actor RealTarget;
	local Pawn pawn;

	// Smoke39 - slowly rinse off blood while underwater
	if ( Bloodiness > 0 && region.zone.bWaterZone )
		Bloodiness = FMax( Bloodiness - deltatime/4, 0 );
	
	player = DeusExPlayer(Owner);
	pawn = Pawn(Owner);

	super(weapon).Tick(deltaTime);

	// don't do any of this if this weapon isn't currently in use
	if (pawn == None)
	{
		LockMode = LOCK_None;
		MaintainLockTimer = 0;
		LockTarget = None;
		LockTimer = 0;
		return;
	}

	if (pawn.Weapon != self)
	{
		LockMode = LOCK_None;
		MaintainLockTimer = 0;
		LockTarget = None;
		LockTimer = 0;
		return;
	}

	// all this should only happen IF you have ammo loaded
	if (ClipCount < ReloadCount)
	{
		// check for LAM or other placed mine placement
		if (bHandToHand && (ProjectileClass != None) && (!Self.IsA('WeaponShuriken')))
		{
			if (NearWallCheck())
			{
				if (( Level.NetMode != NM_Standalone ) && IsAnimating() && (AnimSequence == 'Select'))
				{
				}
				else
				{
					if (!bNearWall || (AnimSequence == 'Select'))
					{
						PlayAnim('PlaceBegin',, 0.1);
						bNearWall = True;
					}
				}
			}
			else
			{
				if (bNearWall)
				{
					PlayAnim('PlaceEnd',, 0.1);
					bNearWall = False;
				}
			}
		}


	  SoundTimer += deltaTime;

	  if ( (Level.Netmode == NM_Standalone) || ( (Player != None) && (Player.PlayerIsClient()) ) )
	  {
		 if (bCanTrack)
		 {
			Target = AcquireTarget();
			RealTarget = Target;

			// calculate the range
			if (Target != None)
			   TargetRange = Abs(VSize(Target.Location - Location));

			// update our timers
			//SoundTimer += deltaTime;
			MaintainLockTimer -= deltaTime;

			// check target and range info to see what our mode is
			if ((Target == None) || IsInState('Reload'))
			{
			   if (MaintainLockTimer <= 0)
			   {
				  SetLockMode(LOCK_None);
				  MaintainLockTimer = 0;
				  LockTarget = None;
			   }
			   else if (LockMode == LOCK_Locked)
			   {
				  Target = LockTarget;
			   }
			}
			else if ((Target != LockTarget) && (Target.IsA('Pawn')) && (LockMode == LOCK_Locked))
			{
			   SetLockMode(LOCK_None);
			   LockTarget = None;
			}
			else if (!Target.IsA('Pawn'))
			{
			   if (MaintainLockTimer <=0 )
			   {
				  SetLockMode(LOCK_Invalid);
			   }
			}
			else if ( (Target.IsA('DeusExPlayer')) && (Target.Style == STY_Translucent) )
			{
			   //DEUS_EX AMSD Don't allow locks on cloaked targets.
			   SetLockMode(LOCK_Invalid);
			}
			else if ( (Target.IsA('DeusExPlayer')) && (Player.DXGame.IsA('TeamDMGame')) && (TeamDMGame(Player.DXGame).ArePlayersAllied(Player,DeusExPlayer(Target))) )
			{
			   //DEUS_EX AMSD Don't allow locks on allies.
			   SetLockMode(LOCK_Invalid);
			}
			else
			{
			   if (TargetRange > MaxRange)
			   {
				  SetLockMode(LOCK_Range);
			   }
			   else
			   {
				  // change LockTime based on skill
				  // -0.7 = max skill
				  // DEUS_EX AMSD Only do weaponskill check here when first checking.
				  if (LockTimer == 0)
				  {
					 LockTime = FMax(Default.LockTime + 3.0 * GetWeaponSkill(), 0.0);
					 if ((Level.Netmode != NM_Standalone) && (LockTime < 0.25))
						LockTime = 0.25;
				  }

				  LockTimer += deltaTime;
				  if (LockTimer >= LockTime)
				  {
					 SetLockMode(LOCK_Locked);
				  }
				  else
				  {
					 SetLockMode(LOCK_Acquire);
				  }
			   }
			}

			// act on the lock mode
			switch (LockMode)
			{
			case LOCK_None:
			   TargetMessage = msgNone;
			   LockTimer -= deltaTime;
			   break;

			case LOCK_Invalid:
			   TargetMessage = msgLockInvalid;
			   LockTimer -= deltaTime;
			   break;

			case LOCK_Range:
			   TargetMessage = msgLockRange @ Int(TargetRange/16) @ msgRangeUnit;
			   LockTimer -= deltaTime;
			   break;

			case LOCK_Acquire:
			   TargetMessage = msgLockAcquire @ Left(String(LockTime-LockTimer), 4) @ msgTimeUnit;
			   beepspeed = FClamp((LockTime - LockTimer) / Default.LockTime, 0.2, 1.0);
			   if (SoundTimer > beepspeed)
			   {
				  Owner.PlaySound(TrackingSound, SLOT_None);
				  SoundTimer = 0;
			   }
			   break;

			case LOCK_Locked:
			   // If maintaining a lock, or getting a new one, increment maintainlocktimer
			   if ((RealTarget != None) && ((RealTarget == LockTarget) || (LockTarget == None)))
			   {
				  if (Level.NetMode != NM_Standalone)
					 MaintainLockTimer = default.MaintainLockTimer;
				  else
					 MaintainLockTimer = 0;
				  LockTarget = Target;
			   }
			   TargetMessage = msgLockLocked @ Int(TargetRange/16) @ msgRangeUnit;
			   // DEUS_EX AMSD Moved out so server can play it so that client knows for sure when locked.
			   /*if (SoundTimer > 0.1)
			   {
				  Owner.PlaySound(LockedSound, SLOT_None);
				  SoundTimer = 0;
			   }*/
			   break;
			}
		 }
		 else
		 {
			LockMode = LOCK_None;
			TargetMessage = msgNone;
			LockTimer = 0;
			MaintainLockTimer = 0;
			LockTarget = None;
		 }

		 if (LockTimer < 0)
			LockTimer = 0;
	  }
   }
   else
   {
	  LockMode = LOCK_None;
	  TargetMessage=msgNone;
	  MaintainLockTimer = 0;
	  LockTarget = None;
	  LockTimer = 0;
   }

   if ((LockMode == LOCK_Locked) && (SoundTimer > 0.1) && (Role == ROLE_Authority))
   {
	  PlayLockSound();
	  SoundTimer = 0;
   }

	currentAccuracy = CalculateAccuracy();

	if (player != None)
	{
		// reduce the recoil based on skill
		recoil = recoilStrength + GetWeaponSkill() * 2.0;
		if (recoil < 0.0)
			recoil = 0.0;

		// simulate recoil while firing
		if (bFiring && IsAnimating() && (AnimSequence == 'Shoot') && (recoil > 0.0))
		{
			player.ViewRotation.Yaw += deltaTime * (Rand(4096) - 2048) * recoil;
			player.ViewRotation.Pitch += deltaTime * (Rand(4096) + 4096) * recoil;
			if ((player.ViewRotation.Pitch > 16384) && (player.ViewRotation.Pitch < 32768))
				player.ViewRotation.Pitch = 16384;
		}
	}

	// if were standing still, increase the timer
	if (VSize(Owner.Velocity) < 10)
		standingTimer += deltaTime;
	else	// otherwise, decrease it slowly based on velocity
		standingTimer = FMax(0, standingTimer - 0.03*deltaTime*VSize(Owner.Velocity));

	if (bLasing || bZoomed)
	{
		// shake our view to simulate poor aiming
		if (ShakeTimer > 0.25)
		{
			ShakeYaw = currentAccuracy * (Rand(4096) - 2048);
			ShakePitch = currentAccuracy * (Rand(4096) - 2048);
			ShakeTimer -= 0.25;
		}

		ShakeTimer += deltaTime;

		if ((player != None) && bZoomed)
		{
			player.ViewRotation.Yaw += deltaTime * ShakeYaw;
			player.ViewRotation.Pitch += deltaTime * ShakePitch;
		}

		if (bLasing && (Emitter != None))
		{
			loc = calcLaserOffset();
			Emitter.SetLocation(loc);


			if(bZoomed) //skip all this shit
			{
				lastlaservec = vect(10,0,0);
				newlaservec = vect(10,0,0);
				futurelaservec = vect(10,0,0);
				Emitter.Setrotation(pawn(owner).viewrotation);
			}

			else
			{
				if(!bLasingNew)
				{
					bLasingNew = true;
					Emitter.Setrotation(pawn(owner).viewrotation);

					lastlaservec = vect(10,0,0);
					newlaservec = vect(10,0,0);
					futurelaservec = vect(10,0,0); //will be sorted out soon enough
					bCountlaser1 = true;
					buselaser1 = true;
					bCountlaser2 = false;
					laserupdatetimer = 0;
					laserupdatetime = 0;
					laserupdatetimer2 = 0;
					laserupdatetime2 = 0;
				}
				else  //we've established shit
				{
					//try for something a little innovative

					//and for the record, this is about the extent of my fucking trig POWA
					//so if you don't like it: FUCK YOU


					//we cycle from laser1's start to finish, transfer across to laser2's finish using
					//laser1's current vect as start, then go from laser1's final to laser2's final
					//then transfer across to laser1's new finish using laser2's current vect as start
					//and so on

					//.....in theory

					if(bCountlaser1 && buselaser1)
					{
						mod2 = laserupdatetime/laserupdatetimer;

						//mod2 = GetLaserVect(mod);


						offset = lastlaservec * mod2;
						offset += newlaservec * (1-mod2);


						if(bCountlaser2)
						{

							mod2 = laserupdatetime2/laserupdatetimer2;

							//mod2 = GetLaserVect(mod);


							offset = normal(offset)*mod2;
							offset += futurelaservec * (1-mod2);
							//offset = normal(offset);
						}
					}
					else if(bCountlaser2) //if laser1 is not counting, then everything's been shifted
					{
						mod2 = laserupdatetime2/laserupdatetimer2;

						//mod2 = GetLaserVect(mod);


						offset = lastlaservec * mod2;
						offset += newlaservec * (1-mod2);

						if(bCountlaser1)
						{
							mod2 = laserupdatetime/laserupdatetimer;

							//mod2 = GetLaserVect(mod);


							offset = normal(offset)*mod2;
							offset += futurelaservec * (1-mod2);
							//offset = normal(offset);
						}
					}



					//translate to worldspace

					offset = offset >> pawn(owner).ViewRotation;
					rota = rotator(offset);
					//add a touch of random jiggle
					rota.Yaw += Rand(5) - 2;
					rota.Pitch += Rand(5) - 2;
					Emitter.Setrotation(rotator(offset));
				}

				if(bCountlaser1)
				{
					laserupdatetime -= deltatime;

					if(laserupdatetimer > 0 && laserupdatetime/laserupdatetimer < 0.2 && !bCountlaser2)
					{
						bCountlaser2 = true;
						//pawn(owner).ClientMessage("2 count!");
					}

					if(laserupdatetime <= 0)
					{
						laserupdatetime = 0.2 + 0.4*frand();
						laserupdatetimer = laserupdatetime;

						point = GetNewLaserDir();

						if(newlaservec == vect(10,0,0))
						{
							newlaservec = point;
						}
						else   //cycle them all
						{
							bCountlaser1 = false;
							//pawn(owner).ClientMessage("1 count stop!");
							buselaser1 = false;
							lastlaservec = newlaservec;
							newlaservec = futurelaservec;
							futurelaservec = point;
						}
					}
				}
				if(bCountlaser2)
				{
					laserupdatetime2 -= deltatime;

					if(laserupdatetimer2 > 0 && laserupdatetime2/laserupdatetimer2 < 0.2 && !bCountlaser1)
					{
						bCountlaser1 = true;
						//pawn(owner).ClientMessage("1 count!");
					}

					if(laserupdatetime2 <= 0)
					{
						laserupdatetime2 = 0.2 + 0.4*frand();
						laserupdatetimer2 = laserupdatetime2;

						point = GetNewLaserDir();

						if(futurelaservec == vect(10,0,0)) //we haven't established yet
						{
							futurelaservec = point;
						}
						else //keep cycling
						{
							bCountlaser2 = false;
							//pawn(owner).ClientMessage("2 count stop!");
							buselaser1 = true;
							lastlaservec = newlaservec;
							newlaservec = futurelaservec;
							futurelaservec = point;
						}
					}
				}
			}
		}
	}
}


function vector GetNewLaserDir()
{
	local vector X,Y,Z, endtrace, point;

	X = vect(1,0,0);
	Y = vect(0,1,0);
	Z = vect(0,0,1);

	EndTrace = currentaccuracy * (FRand()-0.5)*Y*1000 + currentaccuracy * (FRand()-0.5)*Z*1000 ;
	EndTrace += FMax(1024.0, MaxRange)*X;
	point = normal(endtrace);

	return point;
}


function laseroff()
{
	super.LaserOff();
	bLasingnew = false;
}

function Vector CalcLaserOffset()
{

	local vector Offset, X, Y, Z, OffsetInit;
	local scriptedpawn P;

	if(scriptedPawn(owner) != none)
	{
		//hrmm..I'd really rather the pawn's weapon kinda pointed at the pawn's target, rather than his view rotation..
		//well, we'll see how this works for now, I guess
		Offset = Owner.Location + CalcDrawOffset();
		Offset.Z += Pawn(Owner).BaseEyeHeight;

	}
	else if(playerPawn(Owner) != none)
	{
		Offset = Owner.Location;
		Offset.Z += Pawn(Owner).BaseEyeHeight;
	}
	else
		Offset = location;

	return offset;

}

simulated function MakeSilenceVis();

simulated function PlayFiringSound()
{
	if (bHasSilencer)
		PlaySimSound( FireSilencedSound, SLOT_None, TransientSoundVolume, 2048 );
	else
	{
		// The sniper rifle sound is heard to it's range in multiplayer
		if ( ( Level.NetMode != NM_Standalone ) &&  Self.IsA('WeaponRifle') )	
			PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, class'WeaponRifle'.Default.mpMaxRange );
		else
			PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, 2048 );
	}
}

// Smoke39 - wipe off some blood
function BringUp()
{
	Bloodiness = FMax( Bloodiness-1, 0 );	
	CheckWeaponSkins();
	Super.BringUp();
}

state DownWeapon
{
ignores Fire, AltFire;

	function bool PutDown()
	{
		// alert NPCs that I'm putting away my gun
		AIEndEvent('WeaponDrawn', EAITYPE_Visual);
		return Super.PutDown();
	}

Begin:
	ScopeOff();
	LaserOff();
	Owner.PlaySound(deselectsound, SLOT_None,,, 1024);

	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
		ClientDownWeapon();

	TweenDown();
	FinishAnim();

	if ( Level.NetMode != NM_Standalone )
	{
		ClipCount = 0;	// Auto-reload in multiplayer (when putting away)
	}
	bOnlyOwnerSee = false;
	if (Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
}

//
//	SpawnEffects - Spawns the effects like it did in single player
//
function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other, float Damage)
{
   local TraceHitSpawner hitspawner;
	local Name damageType;

	damageType = WeaponDamageType();

   if (bPenetrating)
   {
      if (bHandToHand)
      {
         hitspawner = Spawn(class'TraceHitHandSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
      else
      {
         hitspawner = Spawn(class'TraceHitSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
   }
   else
   {
      if (bHandToHand)
      {
         hitspawner = Spawn(class'TraceHitHandNonPenSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
      else
      {
         hitspawner = Spawn(class'TraceHitNonPenSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
   }
   if (hitSpawner != None)
	{
      hitspawner.HitDamage = Damage;
		hitSpawner.damageType = damageType;
	}
   spawneffectsounds(hitlocation,hitnormal,other,damage);
}

simulated function SpawnEffectSounds( Vector HitLocation, Vector HitNormal, Actor Other, float Damage )
{
	local name surfacetype;
	if (bHandToHand)
	{
		// if we are hand to hand, play an appropriate sound
		if (Other.IsA('DeusExDecoration'))
			Owner.PlayOwnedSound(hitothersound, SLOT_None,,, 1024);
		else if (Other.IsA('Pawn') || Other.IsA('carcass'))
			Owner.PlayOwnedSound(hitfleshsound, SLOT_None,,, 1024);
		else if (Other.IsA('BreakableGlass'))
			Owner.PlayOwnedSound(sound'GlassHit1', SLOT_None,,, 1024);
		else 
		{
			surfacetype = GetWallMaterial(HitLocation, HitNormal);
			if (surfacetype  == 'Glass')
				Owner.PlayOwnedSound(sound'BulletProofHit', SLOT_None,,, 1024);
			else if (surfacetype == 'wood')
				Owner.PlayOwnedSound(hitwoodsound, SLOT_None,,, 1024);
			else if (surfacetype == 'metal')
				Owner.PlayOwnedSound(hitmetalsound, SLOT_None,,, 1024);
			else
				Owner.PlayOwnedSound(hitothersound, SLOT_None,,, 1024);
		}
	}
}

state pickup //removed auto
{
	function Frob(Actor Other, Inventory frobWith)
	{
		local actor A;
		local Pawn P;
		super.frob(other,frobwith);

		P = Pawn(other);
		if (Event != '')
			foreach AllActors(class 'Actor', A, Event)
				A.Trigger(Self, P);
	}
}

//
// copied from Weapon.uc
//
simulated function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X, Y, Z;
	local DeusExProjectile proj;
	local float mult;
	local float volume, radius;
	local int i, numProj;
	local Pawn aPawn;

	// tnmpcaugcombat increases our speed (distance) if hand to hand
	mult = 1.0;
	if (bHandToHand)
	{
		if (DeusExPlayer(Owner) != None)
			mult = DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'tnmpcaugcombat');
		else if (tnmpawn(Owner) != None)
			if (tnmpawn(owner).TNMPAM != none)
				mult = (tnmpawn(Owner).tnmpam.getcombatvalue());
		if (mult == -1.0)
			mult = 1.0;
		ProjSpeed *= mult;
	}

	// skill also affects our damage
	// GetWeaponSkill returns 0.0 to -0.7 (max skill/aug)
	mult += -2.0 * GetWeaponSkill();

	// make noise if we are not silenced
	if (!bHasSilencer && !bHandToHand)
	{
		GetAIVolume(volume, radius);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	// should we shoot multiple projectiles in a spread?
	if (AreaOfEffect == AOE_Cone)
		numProj = 3;
	else
		numProj = 1;

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	Start = ComputeProjectileStart(X, Y, Z);

	for (i=0; i<numProj; i++)
	{
      // If we have multiple slugs, then lower our accuracy a bit after the first slug so the slugs DON'T all go to the same place
      if ((i > 0) && (Level.NetMode != NM_Standalone))
         if (currentAccuracy < MinProjSpreadAcc)
            currentAccuracy = MinProjSpreadAcc;

		AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, Start, AimError, True, bWarn);
		AdjustedAim.Yaw += currentAccuracy * (Rand(1024) - 512);
		AdjustedAim.Pitch += currentAccuracy * (Rand(1024) - 512);


		if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient()) )
		{
			proj = DeusExProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
			if (proj != None)
			{
				//  increases our damage as well
				proj.Damage *= mult;

				// send the targetting information to the projectile
				if (bCanTrack && (LockTarget != None) && (LockMode == LOCK_Locked))
				{
					proj.Target = LockTarget;
					proj.bTracking = True;
				}
			}
		}
		else
		{
			if (( Role == ROLE_Authority ) || (DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn())) )
			{
				// Do it the old fashioned way if it can track, or if we are a projectile that we could pick up again
				if ( bCanTrack || Self.IsA('WeaponShuriken') || Self.IsA('WeaponMiniCrossbow') || Self.IsA('WeaponLAM') || Self.IsA('WeaponEMPGrenade') || Self.IsA('WeaponGasGrenade'))
				{
					if ( Role == ROLE_Authority )
					{
						proj = DeusExProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
						if (proj != None)
						{
							// tnmpcaugcombat increases our damage as well
								proj.Damage *= mult;
							// send the targetting information to the projectile
							if (bCanTrack && (LockTarget != None) && (LockMode == LOCK_Locked))
							{
								proj.Target = LockTarget;
								proj.bTracking = True;
							}
						}
					}
				}
				else
				{
					proj = DeusExProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
					if (proj != None)
					{
						proj.RemoteRole = ROLE_None;
						// tnmpcaugcombat increases our damage as well
						if ( Role == ROLE_Authority )
							proj.Damage *= mult;
						else
							proj.Damage = 0;
					}
					if ( Role == ROLE_Authority )
					{
						for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
						{
							if ( aPawn.IsA('DeusExPlayer') && ( DeusExPlayer(aPawn) != DeusExPlayer(Owner) ))
								DeusExPlayer(aPawn).ClientSpawnProjectile( ProjClass, Owner, Start, AdjustedAim );
						}
					}
				}
			}
		}

	}
	return proj;
}


simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local float        mult;
	local name         damageType;
	local DeusExPlayer dxPlayer;

	if (Other != None)
	{
		// tnmpcaugcombat increases our damage if hand to hand
		mult = 1.0;
		if (bHandToHand)
		{
			if (DeusExPlayer(Owner) != None)
				mult = DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'tnmpcaugcombat');
			else if (tnmpawn(Owner) != None)
				if (tnmpawn(owner).TNMPAM != none)
					mult = (tnmpawn(Owner).tnmpam.getcombatvalue());
			if (mult == -1.0)
				mult = 1.0;
		}

		// skill also affects our damage
		// GetWeaponSkill returns 0.0 to -0.7 (max skill/aug)
		mult += -2.0 * GetWeaponSkill();

		// Determine damage type
		damageType = WeaponDamageType();

		if (Other != None)
		{
			if (Other.bOwned)
			{
				dxPlayer = DeusExPlayer(Owner);
				if (dxPlayer != None)
					dxPlayer.AISendEvent('Futz', EAITYPE_Visual);
			}
		}

		if ((Other == Level) || (Other.IsA('Mover')))
		{
			if ( Role == ROLE_Authority )
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 1000.0*X, damageType);

			SelectiveSpawnEffects( HitLocation, HitNormal, Other, HitDamage * mult);
		}
		else if ((Other != self) && (Other != Owner))
		{
			if ( Role == ROLE_Authority )
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 1000.0*X, damageType);

			if (bHandToHand)
				SelectiveSpawnEffects( HitLocation, HitNormal, Other, HitDamage * mult);

			// Smoke39 - become bloody if appropriate
			if ( Other.IsA('scriptedPawn') && !Other.IsA('Robot') && scriptedpawn(other).bCanBleed)
			{
				if ( bPenetrating )
				{
					SpawnBlood(HitLocation, HitNormal);
					if ( bGetsBloody )
						Bloodiness = FMin( Bloodiness + 1, 8 );
				}
				else if ( bGetsBloody )
					Bloodiness = FMin( Bloodiness + 0.5, 8 );
			}
			else if ( Other.IsA('Carcass') && bGetsBloody )
			{
				if ( bPenetrating )
					Bloodiness = FMin( Bloodiness + 1, 8 );
				else
					Bloodiness = FMin( Bloodiness + 0.5, 8 );
			}
		}
	}

	if (DeusExMPGame(Level.Game) != None)
	{
		if (DeusExPlayer(Other) != None)
			DeusExMPGame(Level.Game).TrackWeapon(self,HitDamage * mult);
		else
			DeusExMPGame(Level.Game).TrackWeapon(self,0);
	}
}



state NormalFire
{
	function AnimEnd()
	{
		if (bAutomatic)
		{
			if ((Pawn(Owner).bFire != 0) && (AmmoType.AmmoAmount > 0))
			{
				if (PlayerPawn(Owner) != None)
					Global.Fire(0);
				else
					GotoState('FinishFire');
			}
			else
				GotoState('FinishFire');
		}
		else
		{
			// if we are a thrown weapon and we run out of ammo, destroy the weapon
			if (bHandToHand && (ReloadCount > 0) && (AmmoType.AmmoAmount <= 0))
				Destroy();
		}
	}
	function float GetShotTime()
	{
		local float mult, sTime;

		if (ScriptedPawn(Owner) != None)
			return ShotTime * (ScriptedPawn(Owner).BaseAccuracy*2+1);
		else
		{
			// tnmpcaugcombat decreases shot time
	mult = 1.0;
	if (bHandToHand)
	{
		if (DeusExPlayer(Owner) != None)
			mult = DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'tnmpcaugcombat');
		else if (tnmpawn(Owner) != None)
			if (tnmpawn(owner).TNMPAM != none)
				mult = (tnmpawn(Owner).tnmpam.getcombatvalue());
		if (mult == -1.0)
			mult = 1.0;
	}
			sTime = ShotTime / mult;
			return (sTime);
		}
	}

Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;

				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((!busefiremode) && (AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

	// if ReloadCount is 0 and we're not hand to hand, then this is a
	// single-use weapon so destroy it after firing once
	if ((ReloadCount == 0) && !bHandToHand)
	{
		if (DeusExPlayer(Owner) != None)
			DeusExPlayer(Owner).RemoveItemFromSlot(Self);   // remove it from the inventory grid
		Destroy();
	}
	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}



simulated state ClientFiring
{
	simulated function AnimEnd()
	{
		bInProcess = False;

		if (bAutomatic)
		{
			if ((Pawn(Owner).bFire != 0) && (AmmoType.AmmoAmount > 0))
			{
				if (PlayerPawn(Owner) != None)
					ClientReFire(0);
				else
					GotoState('SimFinishFire');
			}
			else
				GotoState('SimFinishFire');
		}
	}
	simulated function float GetSimShotTime()
	{
		local float mult, sTime;

		if (ScriptedPawn(Owner) != None)
			return ShotTime * (ScriptedPawn(Owner).BaseAccuracy*2+1);
		else
		{
			// tnmpcaugcombat decreases shot time
	mult = 1.0;
	if (bHandToHand)
	{
		if (DeusExPlayer(Owner) != None)
			mult = DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'tnmpcaugcombat');
		else if (tnmpawn(Owner) != None)
			if (tnmpawn(owner).TNMPAM != none)
				mult = (tnmpawn(Owner).tnmpam.getcombatvalue());
		if (mult == -1.0)
			mult = 1.0;
	}
			sTime = ShotTime * mult;
			return (sTime);
		}
	}
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}
		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;
				if (DeusExPlayer(Owner).bAutoReload)
				{
					bClientReadyToFire = False;
					bInProcess = False;
					if ((!busefiremode) && (AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
					GotoState('SimQuickFinish');
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					IdleFunction();
					GotoState('SimQuickFinish');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			IdleFunction();
			GotoState('SimQuickFinish');
		}
	}
	Sleep(GetSimShotTime());
	if (bAutomatic)
	{
		SimGenerateBullet();
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();
	bInProcess = False;
Done:
	bInProcess = False;
	bFiring = False;
	SimFinish();
}




state FlameThrowerOn
{
	function float GetShotTime()
	{
		local float mult, sTime;

		if (ScriptedPawn(Owner) != None)
			return ShotTime * (ScriptedPawn(Owner).BaseAccuracy*2+1);
		else
		{
			// tnmpcaugcombat decreases shot time
	mult = 1.0;
	if (bHandToHand)
	{
		if (DeusExPlayer(Owner) != None)
			mult = DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'tnmpcaugcombat');
		else if (tnmpawn(Owner) != None)
			if (tnmpawn(owner).TNMPAM != none)
				mult = (tnmpawn(Owner).tnmpam.getcombatvalue());
		if (mult == -1.0)
			mult = 1.0;
	}
			sTime = ShotTime * mult;
			return (sTime);
		}
	}
Begin:
	if ( (DeusExPlayer(Owner).Health > 0) && bFlameOn && (ClipCount < ReloadCount))
	{
		if (( flameShotCount == 0 ) && (Owner != None))
		{
			PlayerPawn(Owner).PlayFiring();
			PlaySelectiveFiring();
			PlayFiringSound();
			flameShotCount = 6;
		}
		else
			flameShotCount--;

		Sleep( GetShotTime() );
		GenerateBullet();
		goto('Begin');
	}
Done:
	bFlameOn = False;
	GotoState('FinishFire');
}

state Reload
{
ignores Fire, AltFire;

Begin:
	FinishAnim();

	// only reload if we have ammo left
	if (AmmoType.AmmoAmount > 0)
	{
		if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
		{
			ClientReload();
			Sleep(GetReloadTime());
			ReadyClientToFire( True );
		}
		else
		{
			bWasZoomed = bZoomed;
			if (bWasZoomed)
				ScopeOff();

			Owner.PlaySound(CockingSound, SLOT_None,,, 1024);		// CockingSound is reloadbegin
			if(!bReloadAnimHack)
				PlayAnim('ReloadBegin');
			NotifyOwner(True);
			FinishAnim();
			if(!bReloadAnimHack)
				LoopAnim('Reload');
			else
				PlayAnim('Reload',Default.ReloadTime/GetReloadTime());
			Sleep(GetReloadTime());
			Owner.PlaySound(AltFireSound, SLOT_None,,, 1024);		// AltFireSound is reloadend
			if(!bReloadAnimHack)
				PlayAnim('ReloadEnd');
			FinishAnim();
			NotifyOwner(False);

			if (bWasZoomed)
				ScopeOn();

			ClipCount = 0;
		}
	}
	GotoState('Idle');
}

defaultproperties
{
     AIRating=1000.000000
     ScopeType=EScopeType_Normal
}
