//=============================================================================
//
// TNM_MedbotAugScreen
//
// works like the normal one except augs you already have can be selected
// with the "install" button being replaced with an "upgrade" button
//
//=============================================================================
class TNM_MedbotAugScreen extends HUDMedBotAddAugsScreen;

var() localized string upgradeButtonText;

function SelectAugmentation(PersonaItemButton buttonPressed)
{
	// Don't do extra work.
	if (selectedAugButton != buttonPressed)
	{
		// Deselect current button
		if (selectedAugButton != None)
			selectedAugButton.SelectButton(False);

		selectedAugButton = buttonPressed;
		selectedAug       = Augmentation(selectedAugButton.GetClientObject());

		// Smoke39 - wanna say "Install" unless special case outlined below
		btnInstall.SetButtonText( InstallButtonLabel );

		// Check to see if this augmentation has already been installed
		if (HUDMedBotAugItemButton(buttonPressed).bHasIt)
		{
			// Smoke39 - act like normal if it can be upgraded
			if ( selectedAug.CurrentLevel < selectedAug.MaxLevel )
			{
				selectedAug.UsingMedBot(True);
				selectedAug.UpdateInfo(winInfo);
				selectedAugButton.SelectButton(True);
			}
			else
			{
				winInfo.Clear();
				winInfo.SetTitle(selectedAug.AugmentationName);
				winInfo.SetText(AlreadyHasItText);
				winInfo.SetText(SelectAnotherText); 
				selectedAug = None;
				selectedAugButton = None;
			}

			// Smoke39 - whether or not we CAN upgrade it, that would be the option if we already have it
			btnInstall.SetButtonText( upgradeButtonText );
		}
		else if (HUDMedBotAugItemButton(buttonPressed).bSlotFull) 
		{
			winInfo.Clear();
			winInfo.SetTitle(selectedAug.AugmentationName);
			winInfo.SetText(SlotFullText);
			winInfo.SetText(SelectAnotherText); 
			selectedAug = None;
			selectedAugButton = None;
		}
		else
		{
			selectedAug.UsingMedBot(True);
			selectedAug.UpdateInfo(winInfo);
			selectedAugButton.SelectButton(True);
		}

		EnableButtons();
	}
}

function PopulateAugCanList()
{
	local Inventory item;
	local int canCount;
	local HUDMedBotAugCanWindow augCanWindow;
	local PersonaNormalTextWindow txtNoCans;

	winAugsTile.DestroyAllChildren();

	// Loop through all the Augmentation Cannisters in the player's 
	// inventory, adding one row for each can.
	item = player.Inventory;

	while(item != None)
	{
		if (item.IsA('AugmentationCannister'))
		{
			augCanWindow = HUDMedBotAugCanWindow(winAugsTile.NewChild(Class'tnmMedBotAugCanWindow'));
			augCanWindow.SetCannister(AugmentationCannister(item));

			canCount++;
		}
		item = item.Inventory;
	}

	// If we didn't add any cans, then display "No Aug Cannisters Available!"
	if (canCount == 0)
	{
		txtNoCans = PersonaNormalTextWindow(winAugsTile.NewChild(Class'PersonaNormalTextWindow'));
		txtNoCans.SetText(NoCansAvailableText);
		txtNoCans.SetTextMargins(4, 4);
		txtNoCans.SetTextAlignments(HALIGN_Left, VALIGN_Center);
	}
}

defaultproperties
{
     upgradeButtonText="|&Upgrade"
     AlreadyHasItText="You already have this augmentation at its maximum level."
}
