//=============================================================================
// WeaponMolBottle.
//=============================================================================
class WeaponMolBottle extends TNMWeapon;

#exec OBJ LOAD FILE=Effects

var float firetime;

simulated function MakeFireVis()
{
     MultiSkins[3] = Texture'effects.fire.flame_b';
     MultiSkins[6] = Texture'effects.fire.fireball1';
     MultiSkins[2] = Texture'LabelTexBurn';
     firetime = 0.0;
}

function Tick(float deltatime)
{
     if (firetime < 0.8)
     {
          firetime += deltatime;
          if (firetime >= 0.8)
          {
               HandToHandAttack();
               MultiSkins[2] = Texture'LabelTex';
               MultiSkins[3] = Texture'BlackMaskTex';
               MultiSkins[6] = Texture'BlackMaskTex';
	  }
     }
}

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconMolotov FILE=Textures\LargeIconMolotov.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconMolotov FILE=Textures\BeltIconMolotov.pcx GROUP=Skins MIPS=off

//Player View
#exec mesh IMPORT MESH=MolBottle ANIVFILE=MODELS\MolBottle_a.3d DATAFILE=MODELS\MolBottle_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=MolBottle X=8000 Y=0 Z=-2000 YAW=64 //(z=+down/-up x=+Left/-Right)

#exec mesh SEQUENCE MESH=MolBottle  SEQ=All		    STARTFRAME=0	NUMFRAMES=59
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Select		STARTFRAME=1	NUMFRAMES=8		    RATE=7	GROUP=Select
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Attack		STARTFRAME=8	NUMFRAMES=17		RATE=11
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Attack2		STARTFRAME=8	NUMFRAMES=17		RATE=11
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Attack3		STARTFRAME=8	NUMFRAMES=17		RATE=11
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Down		STARTFRAME=25	NUMFRAMES=6		    RATE=7
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Idle1		STARTFRAME=31	NUMFRAMES=10		RATE=3
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Idle2		STARTFRAME=40	NUMFRAMES=10		RATE=3
#exec mesh SEQUENCE MESH=MolBottle  SEQ=Idle3		STARTFRAME=49	NUMFRAMES=10		RATE=3

#exec mesh NOTIFY MESH=MolBottle  SEQ=Attack		TIME=0.4	FUNCTION=MakeFireVis
#exec mesh NOTIFY MESH=MolBottle  SEQ=Attack2		TIME=0.4	FUNCTION=MakeFireVis
#exec mesh NOTIFY MESH=MolBottle  SEQ=Attack3		TIME=0.4	FUNCTION=MakeFireVis

#exec texture IMPORT NAME=MoloBottleTex1 FILE=Textures\MolotovBottleTex1.PCX GROUP=Skins // BOTTLE.TE
#exec texture IMPORT NAME=LabelTex FILE=Textures\MolotovLabelTex.pcx GROUP=Skins // Label/Cloth
#exec texture IMPORT NAME=LabelTexBurn FILE=Textures\MolotovLabelTexBurn.pcx GROUP=Skins // Label/Cloth
#exec texture IMPORT NAME=LighterTex FILE=Textures\LighterTex.PCX GROUP=Skins // Lighter
#exec texture IMPORT NAME=Hands FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // HANDS

#exec MESHMAP NEW   MESHMAP=MolBottle MESH=MolBottle
#exec MESHMAP scale MESHMAP=MolBottle X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=MolBottle NUM=1 TEXTURE=MoloBottleTex1
#exec MESHMAP SETTEXTURE MESHMAP=MolBottle NUM=2 TEXTURE=LabelTex
#exec MESHMAP SETTEXTURE MESHMAP=MolBottle NUM=3 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=MolBottle NUM=4 TEXTURE=LighterTex
#exec MESHMAP SETTEXTURE MESHMAP=MolBottle NUM=5 TEXTURE=Hands
#exec MESHMAP SETTEXTURE MESHMAP=MolBottle NUM=6 TEXTURE=BlackMaskTex

//Pickup View
#exec mesh IMPORT MESH=MolBottlePickup ANIVFILE=MODELS\MolBottlePickup_a.3d DATAFILE=MODELS\MolBottlePickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=MolBottlePickup X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=MolBottlePickup SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=MolBottlePickup SEQ=Bottle STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=MolBottlePickup MESH=MolBottlePickup
#exec MESHMAP scale MESHMAP=MolBottlePickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=MolBottlePickup NUM=1 TEXTURE=MoloBottleTex1
#exec MESHMAP SETTEXTURE MESHMAP=MolBottlePickup NUM=2 TEXTURE=LabelTex

//Third Person View
#exec mesh IMPORT MESH=MolBottleThird ANIVFILE=MODELS\MolBottleThird_a.3d DATAFILE=MODELS\MolBottleThird_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=MolBottleThird X=0 Y=0 Z=-2000

#exec mesh SEQUENCE MESH=MolBottleThird SEQ=All    STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=MolBottleThird MESH=MolBottleThird
#exec MESHMAP scale MESHMAP=MolBottleThird X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=MolBottleThird NUM=1 TEXTURE=MoloBottleTex1
#exec MESHMAP SETTEXTURE MESHMAP=MolBottleThird NUM=2 TEXTURE=LabelTex
#exec MESHMAP SETTEXTURE MESHMAP=MolBottleThird NUM=3 TEXTURE=BlackMaskTex

defaultproperties
{
     fireTime=0.800000
     bNoMetal=True
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_All
     ShotTime=0.300000
     reloadTime=0.100000
     HitDamage=50
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bUseAsDrawnWeapon=False
     AITimeLimit=3.500000
     AIFireDelay=5.000000
     bNeedToSetMPPickupAmmo=False
     mpReloadTime=0.100000
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     AmmoName=Class'AmmoMolotov'
     ReloadCount=1
     PickupAmmoCount=1
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'MolotovProj'
     shakemag=50.000000
     SelectSound=Sound'DeusExSounds.Weapons.HideAGunSelect'
     InventoryGroup=25
     ItemName="Molotov Cocktail"
     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'MolBottle'
     PlayerViewScale=0.600000
     PickupViewMesh=LodMesh'MolBottlePickup'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'MolBottleThird'
     ThirdPersonScale=0.400000
     Icon=Texture'BeltIconMolotov'
     largeIcon=Texture'LargeIconMolotov'
     largeIconWidth=35
     largeIconHeight=45
     Description="This is an old beer bottle full of a highly flammable combination of household chemicals. When the bottle breaks while the cloth is lit, the chemicals will come into contact with the flames and subsequently erupt into infernal death. Anybody caught in the blast is likely to be set on fire, as is anybody stupid enough to move through the flames. Not to be served chilled."
     beltDescription="MOLOTOV"
     Texture=Texture'MoloBottleTex1'
     Mesh=LodMesh'MolBottlePickup'
     DrawScale=0.500000
     CollisionRadius=3.800000
     CollisionHeight=11.500000
     Mass=5.000000
     Buoyancy=2.000000
}
