class WeaponSenseTrigger expands Trigger;

var() Name failedEvent;

enum ETriggerCause
{
	ECONC_All,
	ECONC_Visual,
	ECONC_None,
	EMetalDetect,
};

var() bool binhand;
var() ETriggerCause TriggerCause;

singular function Touch(Actor Other)
{
	local bool bDoIt;
	local Inventory inv;
	local Actor A;
	local trestkon t; //single letter variable names rock the house.

	bDoIt = False;

	// should we even pay attention to this actor?
	if (!IsRelevant(Other))
		return;

	t = Trestkon(Other);
	if (t == none) return;

	if (bInHand)
	{
		bDoIt = deusexweapon(t.inhand) != none;
	}
	else
	{
		for (inv=t.Inventory; inv!=None; inv=inv.Inventory)
			if (WeaponSetsItOff(deusexweapon(inv)))
			{
				bDoIt = True;
				break;
			}
	}

	if (bDoIt)
		Super.Touch(Other);
	else
		if (failedEvent != '')
			foreach AllActors(class'Actor', A, failedEvent)
				A.Trigger(Other, Other.Instigator);
}

function bool WeaponSetsItOff(deusexweapon w)
{
	if (w==none) return false;
	switch ( TriggerCause )
	{
	case ECONC_All: return true; //no need for breaks since we're returning anyway.
	case ECONC_Visual: return ((w.Concealability == CONC_Visual) || (w.Concealability == CONC_none));
	case ECONC_None: return (w.Concealability == CONC_None);
	case EMetalDetect: return ( !(
				        w.isA('WeaponFists')      ||
					w.isA('weaponbaton')      ||
					w.isA('hideagun')         ||
					w.isA('weaponPepperGun')  ||
					(w.isA('tnmweapon') && tnmweapon(w).bNoMetal)
                                     ));
	}
}

//you got overridden bitch
function UnTouch( actor Other )
{
}

defaultproperties
{
     ReTriggerDelay=1.000000
}
