class altergravzone extends tnmzoneinfo;

struct GravType  {
	var() vector grav;
	var() bool bAlterPhysics;
};

var() GravType gravs[10];
var() int gravnum;

function prebeginplay()
{
	changegrav(gravnum);
}

function changegrav(int num)
{
	gravnum = num;
	zonegravity = gravs[gravnum].grav;
}

function flipgrav()
{
	if (gravnum == 0)
		changegrav(1);
	else
		changegrav(0);
}

// When an actor enters this zone.
event ActorEntered( actor Other )
{
	super.actorentered(other);
	if ( other.IsA('pawn') )
		if (gravs[gravnum].bAlterPhysics)
			pawn(other).AirControl = 0.050000 * 4;
//			pawn(other).setphysics(PHYS_swimming);
}

// When an actor leaves this zone.
event ActorLeaving( actor Other )
{
	super.actorleaving(other);
	if ( other.IsA('pawn') )
		if ( gravs[gravnum].bAlterPhysics)
			pawn(other).AirControl = 0.050000;
//		pawn(other).setphysics(PHYS_walking);
}

defaultproperties
{
     ZoneFluidFriction=0.000000
     bGravityZone=True
}
